/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.network.syncher;

import de.markusbordihn.easynpc.data.action.ActionEventSet;
import de.markusbordihn.easynpc.data.attribute.CustomAttributes;
import de.markusbordihn.easynpc.data.attribute.EntityAttributes;
import de.markusbordihn.easynpc.data.dialog.DialogDataSet;
import de.markusbordihn.easynpc.data.display.DisplayAttributeEntry;
import de.markusbordihn.easynpc.data.display.DisplayAttributeType;
import de.markusbordihn.easynpc.data.model.ModelPartType;
import de.markusbordihn.easynpc.data.model.ModelPose;
import de.markusbordihn.easynpc.data.objective.ObjectiveDataSet;
import de.markusbordihn.easynpc.data.position.CustomPosition;
import de.markusbordihn.easynpc.data.profession.Profession;
import de.markusbordihn.easynpc.data.render.RenderDataSet;
import de.markusbordihn.easynpc.data.rotation.CustomRotation;
import de.markusbordihn.easynpc.data.scale.CustomScale;
import de.markusbordihn.easynpc.data.skin.SkinDataEntry;
import de.markusbordihn.easynpc.data.sound.SoundDataSet;
import de.markusbordihn.easynpc.data.trading.TradingDataSet;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1916;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EntityDataSerializersManager {
    private static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");
    private static final Map<String, class_2941<?>> ENTITY_DATA_SERIALIZERS = new LinkedHashMap();
    public static final class_2941<ActionEventSet> ACTION_EVENT_SET = EntityDataSerializersManager.defineSerializer(ActionEventSet.class.getSimpleName(), new class_2941<ActionEventSet>(){

        public void write(class_2540 buffer, ActionEventSet value) {
            buffer.method_10794(value.createTag());
        }

        public ActionEventSet read(class_2540 buffer) {
            return new ActionEventSet(buffer.method_10798());
        }

        public ActionEventSet copy(ActionEventSet value) {
            return value;
        }
    });
    public static final class_2941<CustomAttributes> CUSTOM_ATTRIBUTES = EntityDataSerializersManager.defineSerializer(CustomAttributes.class.getSimpleName(), new class_2941<CustomAttributes>(){

        public void write(class_2540 buffer, CustomAttributes value) {
            buffer.method_10794(value.createTag());
        }

        public CustomAttributes read(class_2540 buffer) {
            return new CustomAttributes(buffer.method_10798());
        }

        public CustomAttributes copy(CustomAttributes value) {
            return value;
        }
    });
    public static final class_2941<DialogDataSet> DIALOG_DATA_SET = EntityDataSerializersManager.defineSerializer(DialogDataSet.class.getSimpleName(), new class_2941<DialogDataSet>(){

        public void write(class_2540 buffer, DialogDataSet value) {
            buffer.method_10794(value.createTag());
        }

        public DialogDataSet read(class_2540 buffer) {
            return new DialogDataSet(buffer.method_10798());
        }

        public DialogDataSet copy(DialogDataSet value) {
            return value;
        }
    });
    public static final class_2941<EnumMap<DisplayAttributeType, DisplayAttributeEntry>> DISPLAY_ATTRIBUTE = EntityDataSerializersManager.defineSerializer(DisplayAttributeType.class.getSimpleName() + ":DisplayAttribute", new class_2941<EnumMap<DisplayAttributeType, DisplayAttributeEntry>>(){

        public void write(class_2540 buffer, EnumMap<DisplayAttributeType, DisplayAttributeEntry> value) {
            buffer.method_10804(value.size());
            for (Map.Entry<DisplayAttributeType, DisplayAttributeEntry> entry : value.entrySet()) {
                buffer.method_10817((Enum)entry.getKey());
                buffer.method_10794(entry.getValue().createTag());
            }
        }

        public EnumMap<DisplayAttributeType, DisplayAttributeEntry> read(class_2540 buffer) {
            int size = buffer.method_10816();
            EnumMap<DisplayAttributeType, DisplayAttributeEntry> value = new EnumMap<DisplayAttributeType, DisplayAttributeEntry>(DisplayAttributeType.class);
            for (int i = 0; i < size; ++i) {
                DisplayAttributeType type = (DisplayAttributeType)buffer.method_10818(DisplayAttributeType.class);
                class_2487 nbt = buffer.method_10798();
                if (nbt == null) continue;
                DisplayAttributeEntry entry = new DisplayAttributeEntry(nbt);
                value.put(type, entry);
            }
            return value;
        }

        public EnumMap<DisplayAttributeType, DisplayAttributeEntry> copy(EnumMap<DisplayAttributeType, DisplayAttributeEntry> value) {
            return new EnumMap<DisplayAttributeType, DisplayAttributeEntry>(value);
        }
    });
    public static final class_2941<EntityAttributes> ENTITY_ATTRIBUTES = EntityDataSerializersManager.defineSerializer(EntityAttributes.class.getSimpleName(), new class_2941<EntityAttributes>(){

        public void write(class_2540 buffer, EntityAttributes value) {
            buffer.method_10794(value.createTag());
        }

        public EntityAttributes read(class_2540 buffer) {
            return new EntityAttributes(buffer.method_10798());
        }

        public EntityAttributes copy(EntityAttributes value) {
            return value;
        }
    });
    public static final class_2941<class_1916> MERCHANT_OFFERS = EntityDataSerializersManager.defineSerializer(class_1916.class.getSimpleName(), new class_2941<class_1916>(){

        public void write(class_2540 buffer, class_1916 value) {
            buffer.method_10794(value.method_8268());
        }

        public class_1916 read(class_2540 buffer) {
            class_2487 compoundTag = buffer.method_10798();
            return compoundTag != null ? new class_1916(compoundTag) : new class_1916();
        }

        public class_1916 copy(class_1916 value) {
            return value;
        }
    });
    public static final class_2941<ModelPose> MODEL_POSE = EntityDataSerializersManager.defineSerializer(ModelPose.class.getSimpleName(), new class_2941<ModelPose>(){

        public void write(class_2540 buffer, ModelPose modelPose) {
            buffer.method_10817((Enum)modelPose);
        }

        public ModelPose read(class_2540 buffer) {
            return (ModelPose)buffer.method_10818(ModelPose.class);
        }

        public ModelPose copy(ModelPose value) {
            return value;
        }
    });
    public static final class_2941<ObjectiveDataSet> OBJECTIVE_DATA_SET = EntityDataSerializersManager.defineSerializer(ObjectiveDataSet.class.getSimpleName(), new class_2941<ObjectiveDataSet>(){

        public void write(class_2540 buffer, ObjectiveDataSet value) {
            buffer.method_10794(value.createTag());
        }

        public ObjectiveDataSet read(class_2540 buffer) {
            return new ObjectiveDataSet(buffer.method_10798());
        }

        public ObjectiveDataSet copy(ObjectiveDataSet value) {
            return value;
        }
    });
    public static final class_2941<Profession> PROFESSION = EntityDataSerializersManager.defineSerializer(Profession.class.getSimpleName(), new class_2941<Profession>(){

        public void write(class_2540 buffer, Profession value) {
            buffer.method_10817((Enum)value);
        }

        public Profession read(class_2540 buffer) {
            return (Profession)buffer.method_10818(Profession.class);
        }

        public Profession copy(Profession value) {
            return value;
        }
    });
    public static final class_2941<RenderDataSet> RENDER_DATA_SET = EntityDataSerializersManager.defineSerializer(RenderDataSet.class.getSimpleName(), new class_2941<RenderDataSet>(){

        public void write(class_2540 buffer, RenderDataSet value) {
            buffer.method_10794(value.createTag());
        }

        public RenderDataSet read(class_2540 buffer) {
            return new RenderDataSet(buffer.method_10798());
        }

        public RenderDataSet copy(RenderDataSet value) {
            return value;
        }
    });
    public static final class_2941<Map<ModelPartType, CustomRotation>> MODEL_PART_ROTATION = EntityDataSerializersManager.defineSerializer(ModelPartType.class.getSimpleName() + ":CustomRotation", new class_2941<Map<ModelPartType, CustomRotation>>(){

        public void write(class_2540 buffer, Map<ModelPartType, CustomRotation> value) {
            buffer.method_10804(value.size());
            for (Map.Entry<ModelPartType, CustomRotation> entry : value.entrySet()) {
                buffer.method_10817((Enum)entry.getKey());
                entry.getValue().encode(buffer);
            }
        }

        public Map<ModelPartType, CustomRotation> read(class_2540 buffer) {
            int size = buffer.method_10816();
            EnumMap<ModelPartType, CustomRotation> value = new EnumMap<ModelPartType, CustomRotation>(ModelPartType.class);
            for (int i = 0; i < size; ++i) {
                value.put((ModelPartType)buffer.method_10818(ModelPartType.class), CustomRotation.decode(buffer));
            }
            return value;
        }

        public Map<ModelPartType, CustomRotation> copy(Map<ModelPartType, CustomRotation> value) {
            return new EnumMap<ModelPartType, CustomRotation>(value);
        }
    });
    public static final class_2941<Map<ModelPartType, CustomPosition>> MODEL_PART_POSITION = EntityDataSerializersManager.defineSerializer(ModelPartType.class.getSimpleName() + ":CustomPosition", new class_2941<Map<ModelPartType, CustomPosition>>(){

        public void write(class_2540 buffer, Map<ModelPartType, CustomPosition> value) {
            buffer.method_10804(value.size());
            for (Map.Entry<ModelPartType, CustomPosition> entry : value.entrySet()) {
                buffer.method_10817((Enum)entry.getKey());
                entry.getValue().encode(buffer);
            }
        }

        public Map<ModelPartType, CustomPosition> read(class_2540 buffer) {
            int size = buffer.method_10816();
            EnumMap<ModelPartType, CustomPosition> value = new EnumMap<ModelPartType, CustomPosition>(ModelPartType.class);
            for (int i = 0; i < size; ++i) {
                value.put((ModelPartType)buffer.method_10818(ModelPartType.class), CustomPosition.decode(buffer));
            }
            return value;
        }

        public Map<ModelPartType, CustomPosition> copy(Map<ModelPartType, CustomPosition> value) {
            return new EnumMap<ModelPartType, CustomPosition>(value);
        }
    });
    public static final class_2941<Map<ModelPartType, CustomScale>> MODEL_PART_SCALE = EntityDataSerializersManager.defineSerializer(ModelPartType.class.getSimpleName() + ":CustomScale", new class_2941<Map<ModelPartType, CustomScale>>(){

        public void write(class_2540 buffer, Map<ModelPartType, CustomScale> value) {
            buffer.method_10804(value.size());
            for (Map.Entry<ModelPartType, CustomScale> entry : value.entrySet()) {
                buffer.method_10817((Enum)entry.getKey());
                entry.getValue().encode(buffer);
            }
        }

        public Map<ModelPartType, CustomScale> read(class_2540 buffer) {
            int size = buffer.method_10816();
            EnumMap<ModelPartType, CustomScale> value = new EnumMap<ModelPartType, CustomScale>(ModelPartType.class);
            for (int i = 0; i < size; ++i) {
                value.put((ModelPartType)buffer.method_10818(ModelPartType.class), CustomScale.decode(buffer));
            }
            return value;
        }

        public Map<ModelPartType, CustomScale> copy(Map<ModelPartType, CustomScale> value) {
            return new EnumMap<ModelPartType, CustomScale>(value);
        }
    });
    public static final class_2941<Map<ModelPartType, Boolean>> MODEL_PART_VISIBILITY = EntityDataSerializersManager.defineSerializer(ModelPartType.class.getSimpleName() + ":Visibility", new class_2941<Map<ModelPartType, Boolean>>(){

        public void write(class_2540 buffer, Map<ModelPartType, Boolean> value) {
            buffer.method_10804(value.size());
            for (Map.Entry<ModelPartType, Boolean> entry : value.entrySet()) {
                buffer.method_10817((Enum)entry.getKey());
                buffer.writeBoolean(entry.getValue().booleanValue());
            }
        }

        public Map<ModelPartType, Boolean> read(class_2540 buffer) {
            int size = buffer.method_10816();
            EnumMap<ModelPartType, Boolean> value = new EnumMap<ModelPartType, Boolean>(ModelPartType.class);
            for (int i = 0; i < size; ++i) {
                value.put((ModelPartType)buffer.method_10818(ModelPartType.class), buffer.readBoolean());
            }
            return value;
        }

        public Map<ModelPartType, Boolean> copy(Map<ModelPartType, Boolean> value) {
            return new EnumMap<ModelPartType, Boolean>(value);
        }
    });
    public static final class_2941<SkinDataEntry> SKIN_DATA_ENTRY = EntityDataSerializersManager.defineSerializer(SkinDataEntry.class.getSimpleName(), new class_2941<SkinDataEntry>(){

        public void write(class_2540 buffer, SkinDataEntry value) {
            buffer.method_10794(value.createTag());
        }

        public SkinDataEntry read(class_2540 buffer) {
            return new SkinDataEntry(buffer.method_10798());
        }

        public SkinDataEntry copy(SkinDataEntry value) {
            return value;
        }
    });
    public static final class_2941<SoundDataSet> SOUND_DATA_SET = EntityDataSerializersManager.defineSerializer(SoundDataSet.class.getSimpleName(), new class_2941<SoundDataSet>(){

        public void write(class_2540 buffer, SoundDataSet value) {
            buffer.method_10794(value.createTag());
        }

        public SoundDataSet read(class_2540 buffer) {
            return new SoundDataSet(buffer.method_10798());
        }

        public SoundDataSet copy(SoundDataSet value) {
            return value;
        }
    });
    public static final class_2941<HashSet<UUID>> TARGETED_ENTITY_HASH_SET = EntityDataSerializersManager.defineSerializer(HashSet.class.getSimpleName() + ":" + UUID.class.getSimpleName(), new class_2941<HashSet<UUID>>(){

        public void write(class_2540 buffer, HashSet<UUID> value) {
            for (UUID entry : value) {
                buffer.method_10797(entry);
            }
        }

        public HashSet<UUID> read(class_2540 buffer) {
            HashSet<UUID> value = new HashSet<UUID>();
            while (buffer.isReadable()) {
                value.add(buffer.method_10790());
            }
            return value;
        }

        public HashSet<UUID> copy(HashSet<UUID> value) {
            return value;
        }
    });
    public static final class_2941<HashSet<String>> TARGETED_PLAYER_HASH_SET = EntityDataSerializersManager.defineSerializer(HashSet.class.getSimpleName() + ":" + String.class.getSimpleName(), new class_2941<HashSet<String>>(){

        public void write(class_2540 buffer, HashSet<String> value) {
            for (String entry : value) {
                buffer.method_10814(entry);
            }
        }

        public HashSet<String> read(class_2540 buffer) {
            HashSet<String> value = new HashSet<String>();
            while (buffer.isReadable()) {
                value.add(buffer.method_19772());
            }
            return value;
        }

        public HashSet<String> copy(HashSet<String> value) {
            return value;
        }
    });
    public static final class_2941<TradingDataSet> TRADING_DATA_SET = EntityDataSerializersManager.defineSerializer(TradingDataSet.class.getSimpleName(), new class_2941<TradingDataSet>(){

        public void write(class_2540 buffer, TradingDataSet value) {
            buffer.method_10794(value.createTag());
        }

        public TradingDataSet read(class_2540 buffer) {
            return new TradingDataSet(buffer.method_10798());
        }

        public TradingDataSet copy(TradingDataSet value) {
            return value;
        }
    });
    public static final class_2941<UUID> UUID = EntityDataSerializersManager.defineSerializer(UUID.class.getSimpleName(), new class_2941<UUID>(){

        public void write(class_2540 buffer, UUID value) {
            buffer.method_10797(value);
        }

        public UUID read(class_2540 buffer) {
            return buffer.method_10790();
        }

        public UUID copy(UUID value) {
            return value;
        }
    });

    private EntityDataSerializersManager() {
    }

    public static <T> class_2941<T> defineSerializer(String className, class_2941<T> serializer) {
        if (ENTITY_DATA_SERIALIZERS.containsKey(className)) {
            log.error("Entity data serializer {} already defined with {}!", (Object)className, ENTITY_DATA_SERIALIZERS.get(className));
            return null;
        }
        ENTITY_DATA_SERIALIZERS.put(className, serializer);
        return serializer;
    }

    public static void register() {
        for (Map.Entry<String, class_2941<?>> entry : ENTITY_DATA_SERIALIZERS.entrySet()) {
            class_2941<?> serializer = entry.getValue();
            if (serializer == null) {
                log.error("Failed to register entity data serializer {}", (Object)entry.getKey());
                continue;
            }
            class_2943.method_12720(serializer);
            int id = class_2943.method_12719(serializer);
            if (id >= 0) {
                log.info("Registered entity data serializer {} with id {}", (Object)entry.getKey(), (Object)id);
                continue;
            }
            log.error("Failed to register entity data serializer {} with {}", (Object)entry.getKey(), serializer);
        }
    }
}

