/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.ai.goal;

import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.handlers.AttackHandler;
import java.util.EnumSet;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1352;
import net.minecraft.class_1764;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3745;
import net.minecraft.class_4802;
import net.minecraft.class_6019;

public class CrossbowAttackGoal<T extends EasyNPC<?>>
extends class_1352 {
    public static final class_6019 PATHFINDING_DELAY_RANGE = class_4802.method_24505((int)1, (int)2);
    private final double speedModifier;
    private final float attackRadiusSqr;
    private final class_1314 pathfinderMob;
    private final class_3745 crossbowAttackMob;
    private int attackDelay;
    private CrossbowState crossbowState;
    private int seeTime;
    private int updatePathDelay;

    public CrossbowAttackGoal(T easyNPC, double speedModifier, float attackRange) {
        this.pathfinderMob = easyNPC.getPathfinderMob();
        this.crossbowAttackMob = easyNPC.getCrossbowAttackMob();
        this.speedModifier = speedModifier;
        this.attackRadiusSqr = attackRange * attackRange;
        this.crossbowState = CrossbowState.UNCHARGED;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
    }

    public boolean method_6264() {
        return this.crossbowAttackMob != null && this.isValidTarget() && AttackHandler.isHoldingCrossbowWeapon((class_1309)this.pathfinderMob);
    }

    public boolean method_6266() {
        return this.isValidTarget() && (this.method_6264() || !this.pathfinderMob.method_5942().method_6357()) && AttackHandler.isHoldingCrossbowWeapon((class_1309)this.pathfinderMob);
    }

    private boolean isValidTarget() {
        return this.pathfinderMob.method_5968() != null && this.pathfinderMob.method_5968().method_5805();
    }

    public void method_6270() {
        super.method_6270();
        this.pathfinderMob.method_19540(false);
        this.pathfinderMob.method_5980(null);
        this.seeTime = 0;
        if (this.pathfinderMob.method_6115()) {
            this.pathfinderMob.method_6021();
            this.crossbowAttackMob.method_7110(false);
            class_1799 useItem = this.pathfinderMob.method_6030();
            this.clearChargedProjectiles(useItem);
        }
    }

    public void method_6269() {
        super.method_6269();
        this.pathfinderMob.method_19540(true);
    }

    public boolean method_38846() {
        return true;
    }

    public void method_6268() {
        boolean shouldNavigateToTarget;
        boolean hasSeen;
        class_1309 livingentity = this.pathfinderMob.method_5968();
        if (livingentity == null) {
            return;
        }
        boolean hasLineOfSight = this.pathfinderMob.method_5985().method_6369((class_1297)livingentity);
        boolean bl = hasSeen = this.seeTime > 0;
        if (hasLineOfSight != hasSeen) {
            this.seeTime = 0;
        }
        this.seeTime = hasLineOfSight ? ++this.seeTime : --this.seeTime;
        double distanceToTarget = this.pathfinderMob.method_5858((class_1297)livingentity);
        boolean bl2 = shouldNavigateToTarget = (distanceToTarget > (double)this.attackRadiusSqr || this.seeTime < 5) && this.attackDelay == 0;
        if (shouldNavigateToTarget) {
            --this.updatePathDelay;
            if (this.updatePathDelay <= 0) {
                this.pathfinderMob.method_5942().method_6335((class_1297)livingentity, this.canRun() ? this.speedModifier : this.speedModifier * 0.5);
                this.updatePathDelay = PATHFINDING_DELAY_RANGE.method_35008(this.pathfinderMob.method_6051());
            }
        } else {
            this.updatePathDelay = 0;
            this.pathfinderMob.method_5942().method_6340();
        }
        this.pathfinderMob.method_5988().method_6226((class_1297)livingentity, 30.0f, 30.0f);
        if (this.crossbowState == CrossbowState.UNCHARGED) {
            if (!shouldNavigateToTarget) {
                this.pathfinderMob.method_6019(AttackHandler.getCrossbowHoldingHand((class_1309)this.pathfinderMob));
                this.crossbowState = CrossbowState.CHARGING;
                this.crossbowAttackMob.method_7110(true);
            }
        } else if (this.crossbowState == CrossbowState.CHARGING) {
            class_1799 crossbowItem;
            int chargingTicks;
            if (!this.pathfinderMob.method_6115()) {
                this.crossbowState = CrossbowState.UNCHARGED;
            }
            if ((chargingTicks = this.pathfinderMob.method_6048()) >= class_1764.method_7775((class_1799)(crossbowItem = this.pathfinderMob.method_6030()))) {
                this.pathfinderMob.method_6075();
                this.crossbowState = CrossbowState.CHARGED;
                this.attackDelay = 20 + this.pathfinderMob.method_6051().method_43048(20);
                this.crossbowAttackMob.method_7110(false);
            }
        } else if (this.crossbowState == CrossbowState.CHARGED) {
            --this.attackDelay;
            if (this.attackDelay == 0) {
                this.crossbowState = CrossbowState.READY_TO_ATTACK;
            }
        } else if (this.crossbowState == CrossbowState.READY_TO_ATTACK && hasLineOfSight) {
            this.crossbowAttackMob.method_7105(livingentity, 1.0f);
            class_1799 crossbowInHand = this.pathfinderMob.method_5998(AttackHandler.getCrossbowHoldingHand((class_1309)this.pathfinderMob));
            this.clearChargedProjectiles(crossbowInHand);
            this.crossbowState = CrossbowState.UNCHARGED;
        }
    }

    private void clearChargedProjectiles(class_1799 crossbowItem) {
        if (crossbowItem.method_7960() || !(crossbowItem.method_7909() instanceof class_1764)) {
            return;
        }
        class_2487 itemTag = crossbowItem.method_7948();
        if (itemTag.method_10573("ChargedProjectiles", 9)) {
            itemTag.method_10566("ChargedProjectiles", (class_2520)new class_2499());
        }
    }

    private boolean canRun() {
        return this.crossbowState == CrossbowState.UNCHARGED;
    }

    static enum CrossbowState {
        UNCHARGED,
        CHARGING,
        CHARGED,
        READY_TO_ATTACK;

    }
}

