/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.handler;

import de.markusbordihn.easynpc.data.trading.TradingType;
import de.markusbordihn.easynpc.entity.easynpc.data.TradingDataCapable;
import net.minecraft.class_1799;
import net.minecraft.class_1914;
import net.minecraft.class_1916;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TradingOfferHandler {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");

    private TradingOfferHandler() {
    }

    public static void setAdvancedTradingMaxUses(TradingDataCapable<?> tradingData, int tradingOfferIndex, int maxUses) {
        class_1916 merchantOffers = tradingData.getTradingOffers();
        if (merchantOffers == null || merchantOffers.isEmpty() || merchantOffers.size() <= tradingOfferIndex) {
            return;
        }
        class_1914 merchantOffer = (class_1914)merchantOffers.get(tradingOfferIndex);
        if (merchantOffer == null) {
            return;
        }
        merchantOffers.set(tradingOfferIndex, (Object)new class_1914(merchantOffer.method_8246(), merchantOffer.method_8247(), merchantOffer.method_8250(), 0, maxUses, merchantOffer.method_19279(), merchantOffer.method_19278(), merchantOffer.method_21725()));
        tradingData.setTradingOffers(merchantOffers);
    }

    public static void setAdvancedTradingXp(TradingDataCapable<?> tradingData, int tradingOfferIndex, int xp) {
        class_1916 merchantOffers = tradingData.getTradingOffers();
        if (merchantOffers == null || merchantOffers.isEmpty() || merchantOffers.size() <= tradingOfferIndex) {
            return;
        }
        class_1914 merchantOffer = (class_1914)merchantOffers.get(tradingOfferIndex);
        if (merchantOffer == null) {
            return;
        }
        merchantOffers.set(tradingOfferIndex, (Object)new class_1914(merchantOffer.method_8246(), merchantOffer.method_8247(), merchantOffer.method_8250(), merchantOffer.method_8249(), merchantOffer.method_8248(), xp, merchantOffer.method_19278(), merchantOffer.method_21725()));
        tradingData.setTradingOffers(merchantOffers);
    }

    public static void setAdvancedTradingPriceMultiplier(TradingDataCapable<?> tradingData, int tradingOfferIndex, float priceMultiplier) {
        class_1916 merchantOffers = tradingData.getTradingOffers();
        if (merchantOffers == null || merchantOffers.isEmpty() || merchantOffers.size() <= tradingOfferIndex) {
            return;
        }
        class_1914 merchantOffer = (class_1914)merchantOffers.get(tradingOfferIndex);
        if (merchantOffer == null) {
            return;
        }
        merchantOffers.set(tradingOfferIndex, (Object)new class_1914(merchantOffer.method_8246(), merchantOffer.method_8247(), merchantOffer.method_8250(), merchantOffer.method_8249(), merchantOffer.method_8248(), merchantOffer.method_19279(), priceMultiplier, merchantOffer.method_21725()));
        tradingData.setTradingOffers(merchantOffers);
    }

    public static void setAdvancedTradingDemand(TradingDataCapable<?> tradingData, int tradingOfferIndex, int demand) {
        class_1916 merchantOffers = tradingData.getTradingOffers();
        if (merchantOffers == null || merchantOffers.isEmpty() || merchantOffers.size() <= tradingOfferIndex) {
            return;
        }
        class_1914 merchantOffer = (class_1914)merchantOffers.get(tradingOfferIndex);
        if (merchantOffer == null) {
            return;
        }
        merchantOffers.set(tradingOfferIndex, (Object)new class_1914(merchantOffer.method_8246(), merchantOffer.method_8247(), merchantOffer.method_8250(), merchantOffer.method_8249(), merchantOffer.method_8248(), merchantOffer.method_19279(), merchantOffer.method_19278(), demand));
        tradingData.setTradingOffers(merchantOffers);
    }

    public static void updateBasicTradingOffers(TradingDataCapable<?> tradingData) {
        if (tradingData.getTradingDataSet().isType(TradingType.BASIC)) {
            return;
        }
        class_1916 merchantOffers = tradingData.getTradingOffers();
        if (merchantOffers == null || merchantOffers.isEmpty()) {
            return;
        }
        class_1916 newMerchantOffers = new class_1916();
        for (class_1914 merchantOffer : merchantOffers) {
            if (!TradingOfferHandler.isValidTradingOffer(merchantOffer.method_8246(), merchantOffer.method_8247(), merchantOffer.method_8250())) continue;
            class_1914 newMerchantOffer = new class_1914(merchantOffer.method_8246(), merchantOffer.method_8247(), merchantOffer.method_8250(), tradingData.getTradingDataSet().getMaxUses(), tradingData.getTradingDataSet().getRewardedXP(), merchantOffer.method_19278());
            newMerchantOffers.add((Object)newMerchantOffer);
        }
        tradingData.setTradingOffers(newMerchantOffers);
    }

    private static boolean isValidTradingOffer(class_1799 itemA, class_1799 itemB, class_1799 itemResult) {
        if (itemResult == null || itemA == null && itemB == null) {
            return false;
        }
        return (itemA != null && !itemA.method_7960() || itemB != null && !itemB.method_7960()) && !itemResult.method_7960();
    }
}

