/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.server.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import de.markusbordihn.easynpc.access.AccessManager;
import de.markusbordihn.easynpc.commands.Command;
import de.markusbordihn.easynpc.commands.arguments.EasyNPCArgument;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.handler.RespawnHandler;
import java.util.Collection;
import java.util.UUID;
import net.minecraft.class_2168;
import net.minecraft.class_2170;

public class RespawnCommand
extends Command {
    private RespawnCommand() {
    }

    public static ArgumentBuilder<class_2168, ?> register() {
        return ((LiteralArgumentBuilder)class_2170.method_9247((String)"respawn").requires(cs -> cs.method_9259(0))).then(class_2170.method_9244((String)"npc_targets", (ArgumentType)EasyNPCArgument.npc()).executes(context -> RespawnCommand.respawn((class_2168)context.getSource(), EasyNPCArgument.getEntitiesWithAccess((CommandContext<class_2168>)context, "npc_targets"))));
    }

    private static int respawn(class_2168 context, Collection<? extends EasyNPC<?>> easyNPCs) {
        int respawnedEntities = 0;
        for (EasyNPC<?> easyNPC : easyNPCs) {
            UUID uuid = easyNPC.getEntityUUID();
            if (AccessManager.hasAccess(context, uuid)) {
                if (!RespawnHandler.respawnNPC(easyNPC, context.method_9225())) continue;
                ++respawnedEntities;
                continue;
            }
            RespawnCommand.sendFailureMessage(context, "You are not allowed to respawn the Easy NPC " + String.valueOf(uuid) + " !");
        }
        if (respawnedEntities == 1) {
            EasyNPC<?> easyNPC = easyNPCs.iterator().next();
            return RespawnCommand.sendSuccessMessage(context, "Respawn Easy NPC " + easyNPC.getEntity().method_5476().getString() + " !");
        }
        if (respawnedEntities > 1) {
            return RespawnCommand.sendSuccessMessage(context, "Respawned " + respawnedEntities + " of " + easyNPCs.size() + " selected Easy NPCs!");
        }
        return RespawnCommand.sendFailureMessage(context, "Nothing to respawn!");
    }
}

