/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.texture;

import de.markusbordihn.easynpc.Constants;
import de.markusbordihn.easynpc.client.texture.TextureManager;
import de.markusbordihn.easynpc.client.texture.TextureModelKey;
import de.markusbordihn.easynpc.data.skin.SkinModel;
import de.markusbordihn.easynpc.entity.easynpc.data.SkinDataCapable;
import de.markusbordihn.easynpc.io.CustomSkinDataFiles;
import de.markusbordihn.easynpc.network.components.TextComponent;
import java.io.File;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CustomTextureManager {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");
    protected static final int RELOAD_PROTECTION = 10000;
    private static final HashMap<TextureModelKey, ResourceLocation> textureCache = new HashMap();
    private static final HashSet<UUID> textureReloadProtection = new HashSet();
    private static final String LOG_PREFIX = "[Custom Texture Manager] ";
    private static int reloadProtectionCounter = 0;

    private CustomTextureManager() {
    }

    public static Set<UUID> getCustomTextureCacheKeys(SkinModel skinModel) {
        return CustomTextureManager.getCustomTextureCacheKeys(skinModel, null);
    }

    public static Set<UUID> getCustomTextureCacheKeys(SkinModel skinModel, String searchName) {
        HashSet<UUID> hashSet = new HashSet<UUID>();
        String skinSearchName = searchName != null && !searchName.isEmpty() ? searchName.toLowerCase(Locale.ROOT) : null;
        for (TextureModelKey textureModelKey : textureCache.keySet()) {
            if (!skinModel.equals((Object)textureModelKey.getSkinModel()) || skinSearchName != null && !textureModelKey.getResourceName().isEmpty() && !textureModelKey.getResourceName().toLowerCase(Locale.ROOT).contains(skinSearchName)) continue;
            hashSet.add(textureModelKey.getUUID());
        }
        return hashSet;
    }

    public static ResourceLocation getOrCreateTextureWithDefault(SkinDataCapable<?> skinData, ResourceLocation defaultResourceLocation) {
        UUID skinUUID = skinData.getSkinUUID();
        if (skinUUID.equals(Constants.BLANK_UUID)) {
            return defaultResourceLocation;
        }
        TextureModelKey textureModelKey = new TextureModelKey(skinUUID, skinData.getSkinModel());
        ResourceLocation resourceLocation = textureCache.get(textureModelKey);
        if (resourceLocation != null) {
            return resourceLocation;
        }
        ResourceLocation createdResourceLocation = CustomTextureManager.createTexture(textureModelKey, skinData);
        return createdResourceLocation != null ? createdResourceLocation : defaultResourceLocation;
    }

    private static ResourceLocation createTexture(TextureModelKey textureModelKey, SkinDataCapable<?> skinData) {
        UUID skinUUID = textureModelKey.getUUID();
        if (!textureReloadProtection.add(skinUUID)) {
            if (reloadProtectionCounter++ > 10000) {
                textureReloadProtection.clear();
                reloadProtectionCounter = 0;
            }
            return null;
        }
        SkinModel skinModel = skinData.getSkinModel();
        Path textureDataFolder = CustomSkinDataFiles.getCustomSkinDataFolder(skinModel);
        if (textureDataFolder == null) {
            return null;
        }
        ResourceLocation localTextureCache = TextureManager.searchCachedTexture(textureModelKey, textureDataFolder);
        if (localTextureCache != null) {
            textureCache.put(textureModelKey, localTextureCache);
            return localTextureCache;
        }
        log.error("{} Unable to load custom texture {} {} from {}", (Object)LOG_PREFIX, (Object)skinModel, (Object)skinUUID, (Object)textureDataFolder);
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null) {
            player.displayClientMessage((Component)TextComponent.getText("[Custom Texture Manager] Unable to load custom texture " + String.valueOf(textureModelKey) + " from: " + String.valueOf(textureDataFolder)).withStyle(ChatFormatting.RED), false);
        }
        return null;
    }

    public static void registerTexture(SkinModel skinModel, File textureFile) {
        CustomTextureManager.registerTexture(TextureManager.getTextureModelKey(skinModel, textureFile), textureFile);
    }

    public static void registerTexture(TextureModelKey textureModelKey, File textureFile) {
        ResourceLocation resourceLocation = TextureManager.addCustomTexture(textureModelKey, textureFile);
        if (resourceLocation != null) {
            textureCache.put(textureModelKey, resourceLocation);
        }
    }

    public static void clearTextureCache() {
        textureReloadProtection.clear();
        textureCache.clear();
    }
}

