/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.io;

import de.markusbordihn.easynpc.client.texture.CustomTextureManager;
import de.markusbordihn.easynpc.data.skin.SkinModel;
import de.markusbordihn.easynpc.io.DataFileHandler;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CustomSkinDataFiles {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");
    protected static final String DATA_FOLDER_NAME = "skin";
    protected static final String TEMPLATE_PREFIX = "_template.png";

    private CustomSkinDataFiles() {
    }

    public static void registerCustomSkinData() {
        log.info("{} custom skin data ...", (Object)"\ud83d\udde3 Register Easy NPC: Core");
        Path skinDataFolder = CustomSkinDataFiles.getCustomSkinDataFolder();
        if (skinDataFolder == null) {
            return;
        }
        for (SkinModel skinModel : SkinModel.values()) {
            Path skinModelFolder = CustomSkinDataFiles.getCustomSkinDataFolder(skinModel);
            if (skinModelFolder == null) continue;
            String skinModelName = skinModel.getName();
            Map resourceLocations = Minecraft.getInstance().getResourceManager().listResources("textures/entity/" + skinModelName, fileName -> fileName.toString().endsWith(TEMPLATE_PREFIX));
            for (ResourceLocation resourceLocation : resourceLocations.keySet()) {
                File skinModelTemplateFile = skinModelFolder.resolve(DataFileHandler.getFileNameFromResourceLocation(resourceLocation)).toFile();
                if (skinModelTemplateFile.exists()) {
                    log.warn("Skin model template file {} already exists, skipping copy!", (Object)skinModelTemplateFile);
                    continue;
                }
                log.info("Copy skin model template file {} to {} ...", (Object)resourceLocation, (Object)skinModelTemplateFile);
                DataFileHandler.copyResourceFile(resourceLocation, skinModelTemplateFile);
            }
        }
        CustomSkinDataFiles.registerTextureFiles();
    }

    public static void registerTextureFiles() {
        Path skinDataFolder = CustomSkinDataFiles.getCustomSkinDataFolder();
        if (skinDataFolder == null) {
            return;
        }
        log.info("{} custom skins from {} ...", (Object)"\ud83d\udde3 Register Easy NPC: Core", (Object)skinDataFolder);
        for (SkinModel skinModel : SkinModel.values()) {
            Path skinModelFolder = CustomSkinDataFiles.getCustomSkinDataFolder(skinModel);
            if (skinModelFolder == null || !skinModelFolder.toFile().exists() || !skinModelFolder.toFile().isDirectory()) continue;
            try (Stream<Path> skinPaths = Files.walk(skinModelFolder, new FileVisitOption[0]);){
                skinPaths.filter(skinPath -> Files.isRegularFile(skinPath, new LinkOption[0]) && skinPath.toString().endsWith(".png")).forEach(skinPath -> CustomTextureManager.registerTexture(skinModel, skinPath.toFile()));
            }
            catch (IOException e) {
                log.error("Error reading custom skin files from {} for {}:", (Object)skinModelFolder, (Object)skinModel, (Object)e);
            }
        }
    }

    public static void refreshRegisterTextureFiles() {
        CustomTextureManager.clearTextureCache();
        CustomSkinDataFiles.registerTextureFiles();
    }

    public static Path getCustomSkinDataFolder() {
        return DataFileHandler.getOrCreateCustomDataFolder(DATA_FOLDER_NAME);
    }

    public static Path getCustomSkinDataFolder(SkinModel skinModel) {
        Path skinDataFolder = CustomSkinDataFiles.getCustomSkinDataFolder();
        if (skinDataFolder == null) {
            return null;
        }
        String skinModelName = skinModel.getName();
        Path skinDataFolderPath = skinDataFolder.resolve(skinModelName);
        try {
            if (Files.exists(skinDataFolderPath, new LinkOption[0]) && Files.isDirectory(skinDataFolderPath, new LinkOption[0])) {
                return skinDataFolderPath;
            }
            log.info("Created new skin data folder {} at {}!", (Object)skinModelName, (Object)skinDataFolderPath);
            return Files.createDirectories(skinDataFolderPath, new FileAttribute[0]);
        }
        catch (IOException e) {
            log.error("Error creating skin data folder {} at {}:", (Object)skinModelName, (Object)skinDataFolderPath, (Object)e);
            return null;
        }
    }
}

