/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.data;

import de.markusbordihn.easynpc.data.model.ModelPartType;
import de.markusbordihn.easynpc.data.rotation.CustomRotation;
import de.markusbordihn.easynpc.data.synched.SynchedDataIndex;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.network.syncher.EntityDataSerializersManager;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;

public interface ModelRotationDataCapable<T extends PathfinderMob>
extends EasyNPC<T> {
    public static final CustomRotation DEFAULT_MODEL_PART_ROTATION = new CustomRotation(0.0f, 0.0f, 0.0f);
    public static final String EASY_NPC_DATA_MODEL_ROTATION_TAG = "Rotation";
    public static final StreamCodec<RegistryFriendlyByteBuf, Map<ModelPartType, CustomRotation>> MODEL_PART_ROTATION_STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, Map<ModelPartType, CustomRotation>>(){

        public Map<ModelPartType, CustomRotation> decode(RegistryFriendlyByteBuf registryFriendlyByteBuf) {
            CompoundTag compoundTag = registryFriendlyByteBuf.readNbt();
            EnumMap<ModelPartType, CustomRotation> modelPartMap = new EnumMap<ModelPartType, CustomRotation>(ModelPartType.class);
            for (String key : compoundTag.keySet()) {
                ModelPartType modelPartType = ModelPartType.get(key);
                if (modelPartType == null) continue;
                modelPartMap.put(modelPartType, new CustomRotation(modelPartType, compoundTag));
            }
            return modelPartMap;
        }

        public void encode(RegistryFriendlyByteBuf registryFriendlyByteBuf, Map<ModelPartType, CustomRotation> modelPartMap) {
            CompoundTag compoundTag = new CompoundTag();
            for (Map.Entry<ModelPartType, CustomRotation> entry : modelPartMap.entrySet()) {
                compoundTag.put(entry.getKey().getTagName(), (Tag)entry.getValue().save());
            }
            registryFriendlyByteBuf.writeNbt((Tag)compoundTag);
        }
    };

    public static void registerSyncedModelRotationData(EnumMap<SynchedDataIndex, EntityDataAccessor<?>> map, Class<? extends Entity> entityClass) {
        log.info("Registering Synched Model Rotation Data for {}.", (Object)entityClass.getSimpleName());
        map.put(SynchedDataIndex.MODEL_ROTATION, SynchedEntityData.defineId(entityClass, EntityDataSerializersManager.MODEL_PART_ROTATION));
    }

    default public EnumMap<ModelPartType, CustomRotation> getModelPartRotation() {
        EnumMap<ModelPartType, CustomRotation> modelPartMap = (EnumMap<ModelPartType, CustomRotation>)this.getSynchedEntityData(SynchedDataIndex.MODEL_ROTATION);
        if (modelPartMap == null) {
            modelPartMap = new EnumMap<ModelPartType, CustomRotation>(ModelPartType.class);
            this.setModelPartRotation(modelPartMap);
        }
        return modelPartMap;
    }

    default public void setModelPartRotation(EnumMap<ModelPartType, CustomRotation> modelPartMap) {
        if (modelPartMap != null) {
            this.setSynchedEntityData(SynchedDataIndex.MODEL_ROTATION, modelPartMap, true);
        }
    }

    default public void setModelPartRotation(ModelPartType modelPartType, CustomRotation rotation) {
        EnumMap<ModelPartType, CustomRotation> modelPartMap = this.getModelPartRotation();
        if (modelPartType != null) {
            modelPartMap.put(modelPartType, rotation);
            this.setModelPartRotation(new EnumMap<ModelPartType, CustomRotation>(modelPartMap));
        }
    }

    default public CustomRotation getModelPartRotation(ModelPartType modelPartType) {
        EnumMap<ModelPartType, CustomRotation> modelPartMap = this.getModelPartRotation();
        return modelPartMap.getOrDefault((Object)modelPartType, DEFAULT_MODEL_PART_ROTATION);
    }

    default public void setModelRotation(float y) {
        CustomRotation rotation = this.getModelPartRotation(ModelPartType.ROOT);
        this.setModelRotation(rotation.x(), y, rotation.z());
    }

    default public void setModelRotation(float x, float y, float z) {
        LivingEntity livingEntity;
        Entity entity = this.getEntity();
        if (entity != null) {
            entity.setYRot(y);
            entity.setYBodyRot(y);
            entity.setYHeadRot(y);
            entity.yRotO = y;
        }
        if ((livingEntity = this.getLivingEntity()) != null) {
            livingEntity.yBodyRotO = y;
            livingEntity.yHeadRotO = y;
        }
        this.setModelPartRotation(ModelPartType.ROOT, new CustomRotation(x, y, z).withLocked(y != 0.0f));
    }

    default public boolean hasChangedModelRotation() {
        EnumMap<ModelPartType, CustomRotation> modelPartMap = this.getModelPartRotation();
        for (CustomRotation rotation : modelPartMap.values()) {
            if (!rotation.hasChanged() || rotation == modelPartMap.get((Object)ModelPartType.ROOT) && rotation.hasChangedYaw()) continue;
            return true;
        }
        return false;
    }

    default public void defineSynchedModelRotationData(SynchedEntityData.Builder builder) {
        this.defineSynchedEntityData(builder, SynchedDataIndex.MODEL_ROTATION, new EnumMap(ModelPartType.class));
    }

    default public void addAdditionalModelRotationData(CompoundTag compoundTag) {
        CompoundTag rotationsTag = new CompoundTag();
        EnumMap<ModelPartType, CustomRotation> modelPartMap = this.getModelPartRotation();
        for (Map.Entry<ModelPartType, CustomRotation> entry : modelPartMap.entrySet()) {
            rotationsTag.put(entry.getKey().getTagName(), (Tag)entry.getValue().save());
        }
        compoundTag.put(EASY_NPC_DATA_MODEL_ROTATION_TAG, (Tag)rotationsTag);
    }

    default public void readAdditionalModelRotationData(CompoundTag compoundTag) {
        if (!compoundTag.contains(EASY_NPC_DATA_MODEL_ROTATION_TAG)) {
            return;
        }
        CompoundTag rotationsTag = compoundTag.getCompoundOrEmpty(EASY_NPC_DATA_MODEL_ROTATION_TAG);
        EnumMap<ModelPartType, CustomRotation> modelPartMap = new EnumMap<ModelPartType, CustomRotation>(ModelPartType.class);
        for (String key : rotationsTag.keySet()) {
            ModelPartType modelPartType = ModelPartType.get(key);
            if (modelPartType == null) continue;
            modelPartMap.put(modelPartType, new CustomRotation(modelPartType, rotationsTag));
        }
        this.setModelPartRotation(modelPartMap);
    }
}

