/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.data.screen;

import java.util.UUID;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public record ScreenData(UUID uuid, UUID dialogId, UUID dialogButtonId, UUID actionDataEntryId, int pageIndex, class_2487 additionalData) {
    public static final String SCREEN_DATA_ACTION_DATA_ENTRY_ID_TAG = "ActionDataEntryId";
    public static final String SCREEN_DATA_ADDITIONAL_DATA_TAG = "AdditionalData";
    public static final String SCREEN_DATA_DIALOG_BUTTON_ID_TAG = "DialogButtonId";
    public static final String SCREEN_DATA_DIALOG_ID_TAG = "DialogId";
    public static final String SCREEN_DATA_PAGE_INDEX_TAG = "PageIndex";
    public static final String SCREEN_DATA_TAG = "ScreenData";
    public static final String SCREEN_DATA_UUID_TAG = "UUID";
    private static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");

    public ScreenData(UUID uuid, UUID dialogId) {
        this(uuid, dialogId, null, null, 0, new class_2487());
    }

    public static boolean hasScreenData(class_2487 compoundTag) {
        return compoundTag != null && compoundTag.method_10545(SCREEN_DATA_TAG);
    }

    public static ScreenData decode(class_2487 compoundTag) {
        if (!ScreenData.hasScreenData(compoundTag)) {
            log.error("Unable to decode screen data from compound tag: {}", (Object)compoundTag);
            return null;
        }
        class_2487 screenDataTag = compoundTag.method_10562(SCREEN_DATA_TAG);
        UUID uuid = screenDataTag.method_25926(SCREEN_DATA_UUID_TAG);
        UUID dialogID = screenDataTag.method_10545(SCREEN_DATA_DIALOG_ID_TAG) ? screenDataTag.method_25926(SCREEN_DATA_DIALOG_ID_TAG) : null;
        UUID dialogButtonId = screenDataTag.method_10545(SCREEN_DATA_DIALOG_BUTTON_ID_TAG) ? screenDataTag.method_25926(SCREEN_DATA_DIALOG_BUTTON_ID_TAG) : null;
        UUID actionDataEntryId = screenDataTag.method_10545(SCREEN_DATA_ACTION_DATA_ENTRY_ID_TAG) ? screenDataTag.method_25926(SCREEN_DATA_ACTION_DATA_ENTRY_ID_TAG) : null;
        int pageIndex = screenDataTag.method_10550(SCREEN_DATA_PAGE_INDEX_TAG);
        class_2487 data = screenDataTag.method_10545(SCREEN_DATA_ADDITIONAL_DATA_TAG) ? screenDataTag.method_10562(SCREEN_DATA_ADDITIONAL_DATA_TAG) : new class_2487();
        return new ScreenData(uuid, dialogID, dialogButtonId, actionDataEntryId, pageIndex, data);
    }

    public class_2487 encode() {
        class_2487 screenDataTag = new class_2487();
        screenDataTag.method_25927(SCREEN_DATA_UUID_TAG, this.uuid);
        if (this.dialogId != null) {
            screenDataTag.method_25927(SCREEN_DATA_DIALOG_ID_TAG, this.dialogId);
        }
        if (this.dialogButtonId != null) {
            screenDataTag.method_25927(SCREEN_DATA_DIALOG_BUTTON_ID_TAG, this.dialogButtonId);
        }
        if (this.actionDataEntryId != null) {
            screenDataTag.method_25927(SCREEN_DATA_ACTION_DATA_ENTRY_ID_TAG, this.actionDataEntryId);
        }
        screenDataTag.method_10569(SCREEN_DATA_PAGE_INDEX_TAG, this.pageIndex);
        if (this.additionalData != null) {
            screenDataTag.method_10566(SCREEN_DATA_ADDITIONAL_DATA_TAG, (class_2520)this.additionalData);
        }
        class_2487 compoundTag = new class_2487();
        compoundTag.method_10566(SCREEN_DATA_TAG, (class_2520)screenDataTag);
        return compoundTag;
    }
}

