/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.data;

import de.markusbordihn.easynpc.data.model.ModelPartType;
import de.markusbordihn.easynpc.data.position.CustomPosition;
import de.markusbordihn.easynpc.data.synched.SynchedDataIndex;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.network.syncher.EntityDataSerializersManager;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_1314;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2940;
import net.minecraft.class_2945;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

public interface ModelPositionDataCapable<T extends class_1314>
extends EasyNPC<T> {
    public static final CustomPosition DEFAULT_MODEL_PART_POSITION = new CustomPosition(0.0f, 0.0f, 0.0f);
    public static final String EASY_NPC_DATA_MODEL_POSITION_TAG = "Position";
    public static final class_9139<class_9129, Map<ModelPartType, CustomPosition>> MODEL_PART_POSITION_STREAM_CODEC = new class_9139<class_9129, Map<ModelPartType, CustomPosition>>(){

        public Map<ModelPartType, CustomPosition> decode(class_9129 registryFriendlyByteBuf) {
            class_2487 compoundTag = registryFriendlyByteBuf.method_10798();
            EnumMap<ModelPartType, CustomPosition> modelPartMap = new EnumMap<ModelPartType, CustomPosition>(ModelPartType.class);
            for (String key : compoundTag.method_10541()) {
                ModelPartType modelPartType = ModelPartType.get(key);
                if (modelPartType == null) continue;
                modelPartMap.put(modelPartType, new CustomPosition(modelPartType, compoundTag));
            }
            return modelPartMap;
        }

        public void encode(class_9129 registryFriendlyByteBuf, Map<ModelPartType, CustomPosition> modelPartMap) {
            class_2487 compoundTag = new class_2487();
            for (Map.Entry<ModelPartType, CustomPosition> entry : modelPartMap.entrySet()) {
                compoundTag.method_10566(entry.getKey().getTagName(), (class_2520)entry.getValue().save());
            }
            registryFriendlyByteBuf.method_10794((class_2520)compoundTag);
        }
    };

    public static void registerSyncedModelPositionData(EnumMap<SynchedDataIndex, class_2940<?>> map, Class<? extends class_1297> entityClass) {
        log.info("Registering Synched Model Position Data for {}.", (Object)entityClass.getSimpleName());
        map.put(SynchedDataIndex.MODEL_POSITION, class_2945.method_12791(entityClass, EntityDataSerializersManager.MODEL_PART_POSITION));
    }

    default public EnumMap<ModelPartType, CustomPosition> getModelPartPosition() {
        EnumMap<ModelPartType, CustomPosition> modelPartMap = (EnumMap<ModelPartType, CustomPosition>)this.getSynchedEntityData(SynchedDataIndex.MODEL_POSITION);
        if (modelPartMap == null) {
            modelPartMap = new EnumMap<ModelPartType, CustomPosition>(ModelPartType.class);
            this.setModelPartPosition(modelPartMap);
        }
        return modelPartMap;
    }

    default public void setModelPartPosition(EnumMap<ModelPartType, CustomPosition> modelPartMap) {
        if (modelPartMap != null) {
            this.setSynchedEntityData(SynchedDataIndex.MODEL_POSITION, modelPartMap, true);
        }
    }

    default public void setModelPartPosition(ModelPartType modelPartType, CustomPosition Position) {
        EnumMap<ModelPartType, CustomPosition> modelPartMap = this.getModelPartPosition();
        if (modelPartType != null) {
            modelPartMap.put(modelPartType, Position);
            this.setModelPartPosition(new EnumMap<ModelPartType, CustomPosition>(modelPartMap));
        }
    }

    default public CustomPosition getModelPartPosition(ModelPartType modelPartType) {
        EnumMap<ModelPartType, CustomPosition> modelPartMap = this.getModelPartPosition();
        return modelPartMap.getOrDefault((Object)modelPartType, DEFAULT_MODEL_PART_POSITION);
    }

    default public boolean hasChangedModelPosition() {
        EnumMap<ModelPartType, CustomPosition> modelPartMap = this.getModelPartPosition();
        for (Map.Entry<ModelPartType, CustomPosition> entry : modelPartMap.entrySet()) {
            if (!entry.getValue().hasChanged()) continue;
            return true;
        }
        return false;
    }

    default public void defineSynchedModelPositionData(class_2945.class_9222 builder) {
        this.defineSynchedEntityData(builder, SynchedDataIndex.MODEL_POSITION, new EnumMap(ModelPartType.class));
    }

    default public void addAdditionalModelPositionData(class_2487 compoundTag) {
        class_2487 positionsTag = new class_2487();
        EnumMap<ModelPartType, CustomPosition> modelPartMap = this.getModelPartPosition();
        for (Map.Entry<ModelPartType, CustomPosition> entry : modelPartMap.entrySet()) {
            positionsTag.method_10566(entry.getKey().getTagName(), (class_2520)entry.getValue().save());
        }
        compoundTag.method_10566(EASY_NPC_DATA_MODEL_POSITION_TAG, (class_2520)positionsTag);
    }

    default public void readAdditionalModelPositionData(class_2487 compoundTag) {
        if (!compoundTag.method_10545(EASY_NPC_DATA_MODEL_POSITION_TAG)) {
            return;
        }
        class_2487 positionTag = compoundTag.method_10562(EASY_NPC_DATA_MODEL_POSITION_TAG);
        EnumMap<ModelPartType, CustomPosition> modelPartMap = new EnumMap<ModelPartType, CustomPosition>(ModelPartType.class);
        for (String key : positionTag.method_10541()) {
            ModelPartType modelPartType = ModelPartType.get(key);
            if (modelPartType == null) continue;
            modelPartMap.put(modelPartType, new CustomPosition(modelPartType, positionTag));
        }
        this.setModelPartPosition(modelPartMap);
    }
}

