/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.ai.goal;

import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.OwnerDataCapable;
import java.util.EnumSet;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CustomOwnerHurtByTargetGoal<T extends EasyNPC<?>>
extends TargetGoal {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");
    private final OwnerDataCapable<?> ownerData;
    private LivingEntity ownerLastHurtBy;
    private int timestamp;

    public CustomOwnerHurtByTargetGoal(T easyNPC) {
        super(easyNPC.getMob(), false);
        this.ownerData = easyNPC.getEasyNPCOwnerData();
        this.setFlags(EnumSet.of(Goal.Flag.TARGET));
    }

    public boolean canUse() {
        if (this.ownerData == null || !this.ownerData.hasNPCOwner()) {
            return false;
        }
        LivingEntity owner = this.ownerData.getOwner();
        if (owner == null) {
            return false;
        }
        this.ownerLastHurtBy = owner.getLastHurtByMob();
        int lastHurtByTimestamp = owner.getLastHurtByMobTimestamp();
        return lastHurtByTimestamp != this.timestamp && this.canAttack(this.ownerLastHurtBy, TargetingConditions.DEFAULT) && this.isRevengeTargetValid(this.ownerLastHurtBy);
    }

    public void start() {
        this.mob.setTarget(this.ownerLastHurtBy);
        LivingEntity owner = this.ownerData.getOwner();
        if (owner != null) {
            this.timestamp = owner.getLastHurtByMobTimestamp();
        }
        super.start();
    }

    private boolean isRevengeTargetValid(LivingEntity target) {
        if (target == null) {
            return false;
        }
        if (target == this.ownerData.getOwner()) {
            return false;
        }
        return target.isAlive() && !target.isInvulnerable() && target != this.mob;
    }
}

