/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.renderer.entity.raw;

import de.markusbordihn.easynpc.client.renderer.entity.EasyNPCEntityRenderer;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.npc.raw.WolfRaw;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.WolfRenderer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.entity.state.WolfRenderState;
import net.minecraft.resources.ResourceLocation;

public class WolfRawRenderer
extends WolfRenderer
implements EasyNPCEntityRenderer {
    protected static final Map<WolfRaw.VariantType, ResourceLocation> TEXTURE_BY_VARIANT_TYPE = (Map)Util.make(new EnumMap(WolfRaw.VariantType.class), map -> {
        map.put(WolfRaw.VariantType.DEFAULT, ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/entity/wolf/wolf.png"));
        map.put(WolfRaw.VariantType.ANGRY, ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/entity/wolf/wolf_angry.png"));
        map.put(WolfRaw.VariantType.TAMED, ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/entity/wolf/wolf_tame.png"));
    });
    protected static final ResourceLocation DEFAULT_TEXTURE = TEXTURE_BY_VARIANT_TYPE.get((Object)WolfRaw.VariantType.DEFAULT);

    public WolfRawRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public ResourceLocation getTextureLocation(WolfRenderState renderState) {
        EasyNPC easyNPC = this.getEasyNPC((LivingEntityRenderState)renderState);
        if (easyNPC != null) {
            return this.getEntityTexture(easyNPC);
        }
        return DEFAULT_TEXTURE;
    }

    @Override
    public ResourceLocation getDefaultTexture() {
        return DEFAULT_TEXTURE;
    }

    @Override
    public ResourceLocation getTextureByVariant(Enum<?> variantType) {
        return TEXTURE_BY_VARIANT_TYPE.getOrDefault(variantType, DEFAULT_TEXTURE);
    }
}

