/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.screen.render;

import de.markusbordihn.easynpc.data.model.ModelPartType;
import de.markusbordihn.easynpc.data.model.ModelPose;
import de.markusbordihn.easynpc.data.profession.Profession;
import de.markusbordihn.easynpc.data.render.EntityRenderConfig;
import de.markusbordihn.easynpc.data.render.EntityRenderOverrides;
import de.markusbordihn.easynpc.data.render.RenderDataSet;
import de.markusbordihn.easynpc.data.render.RenderType;
import de.markusbordihn.easynpc.data.rotation.CustomRotation;
import de.markusbordihn.easynpc.data.scale.CustomScale;
import de.markusbordihn.easynpc.data.skin.SkinDataEntry;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.ModelDataCapable;
import de.markusbordihn.easynpc.entity.easynpc.data.ProfessionDataCapable;
import de.markusbordihn.easynpc.entity.easynpc.data.RenderDataCapable;
import de.markusbordihn.easynpc.entity.easynpc.data.SkinDataCapable;
import de.markusbordihn.easynpc.entity.easynpc.data.VariantDataCapable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;

public class EntityScreenRenderer {
    private EntityScreenRenderer() {
    }

    public static void renderEntity(GuiGraphics guiGraphics, EasyNPC<?> easyNPC, EntityRenderConfig config, float mouseX, float mouseY) {
        int bottom;
        int top;
        int right;
        int left;
        if (easyNPC == null || easyNPC.getLivingEntity() == null) {
            return;
        }
        LivingEntity livingEntity = easyNPC.getLivingEntity();
        EntityRenderState backupState = new EntityRenderState(livingEntity, easyNPC, config);
        EntityScreenRenderer.applyRenderModifications(easyNPC, config, backupState);
        int renderScale = config.scale();
        if (config.scissorBox() != null) {
            CustomScale originalScale;
            float multiplier = config.scissorBox().scaleMultiplier();
            renderScale = (int)((float)config.scale() * multiplier);
            ModelDataCapable modelData = easyNPC.getEasyNPCModelData();
            if (modelData != null && (originalScale = modelData.getModelPartScale(ModelPartType.ROOT)) != null) {
                float adjustment = 1.0f / multiplier;
                modelData.setModelPartScale(ModelPartType.ROOT, new CustomScale(originalScale.x() * adjustment, originalScale.y() * adjustment, originalScale.z() * adjustment));
            }
        }
        if (config.scissorBox() != null && config.scissorBox().hasCustomScissor()) {
            left = config.x() + config.scissorBox().left();
            right = left + config.scissorBox().width();
            top = config.y() + config.scissorBox().top();
            bottom = top + config.scissorBox().height();
        } else {
            int entityWidth = (int)((float)renderScale * 2.5f);
            int entityHeight = (int)((float)renderScale * 3.0f);
            left = config.x() - entityWidth / 2;
            right = config.x() + entityWidth / 2;
            top = config.y() - entityHeight;
            bottom = config.y() + (int)((float)renderScale * 0.5f);
        }
        InventoryScreen.renderEntityInInventoryFollowsMouse((GuiGraphics)guiGraphics, (int)left, (int)top, (int)right, (int)bottom, (int)renderScale, (float)0.0f, (float)mouseX, (float)mouseY, (LivingEntity)livingEntity);
        EntityScreenRenderer.restoreEntityState(easyNPC, backupState);
    }

    private static void applyRenderModifications(EasyNPC<?> easyNPC, EntityRenderConfig config, EntityRenderState backupState) {
        ProfessionDataCapable professionData;
        VariantDataCapable variantData;
        SkinDataCapable skinData;
        RenderDataCapable renderData;
        ModelDataCapable modelData;
        Entity entity = easyNPC.getEntity();
        LivingEntity livingEntity = easyNPC.getLivingEntity();
        EntityRenderOverrides overrides = config.overrides();
        if (overrides.invisible() != null) {
            entity.setInvisible(overrides.invisible().booleanValue());
        }
        if (overrides.hideNameTag() != null && overrides.hideNameTag().booleanValue()) {
            Minecraft minecraft = Minecraft.getInstance();
            if (minecraft != null) {
                minecraft.options.hideGui = true;
            } else {
                livingEntity.setCustomName(null);
                livingEntity.setCustomNameVisible(false);
            }
        }
        if ((modelData = easyNPC.getEasyNPCModelData()) != null) {
            if (overrides.rootRotation() != null) {
                modelData.setModelPartRotation(ModelPartType.ROOT, overrides.rootRotation());
            }
            if (overrides.rootScale() != null) {
                modelData.setModelPartScale(ModelPartType.ROOT, overrides.rootScale());
            }
            if (overrides.modelPose() != null) {
                modelData.setModelPose(overrides.modelPose());
            }
        }
        if (overrides.entityPose() != null) {
            entity.setPose(overrides.entityPose());
        }
        if ((renderData = easyNPC.getEasyNPCRenderData()) != null && renderData.getRenderDataSet() != null) {
            RenderDataSet renderDataSet = renderData.getRenderDataSet();
            if (overrides.renderType() != null) {
                renderDataSet.setRenderType(overrides.renderType());
            }
            if (overrides.renderEntityType() != null) {
                renderDataSet.setRenderEntityType(overrides.renderEntityType());
            }
        }
        if ((skinData = easyNPC.getEasyNPCSkinData()) != null && (overrides.skinType() != null || overrides.skinUUID() != null)) {
            SkinDataEntry currentEntry;
            SkinDataEntry modifiedEntry = currentEntry = skinData.getSkinDataEntry();
            if (overrides.skinType() != null) {
                modifiedEntry = modifiedEntry.withType(overrides.skinType());
            }
            if (overrides.skinUUID() != null) {
                modifiedEntry = modifiedEntry.withUUID(overrides.skinUUID());
            }
            skinData.setSkinDataEntry(modifiedEntry);
        }
        if ((variantData = easyNPC.getEasyNPCVariantData()) != null && overrides.variant() != null) {
            variantData.setVariantType(overrides.variant());
        }
        if ((professionData = easyNPC.getEasyNPCProfessionData()) != null && overrides.profession() != null) {
            professionData.setProfession(overrides.profession());
        }
    }

    private static void restoreEntityState(EasyNPC<?> easyNPC, EntityRenderState backupState) {
        ProfessionDataCapable professionData;
        VariantDataCapable variantData;
        SkinDataCapable skinData;
        RenderDataCapable renderData;
        ModelDataCapable modelData;
        Entity entity = easyNPC.getEntity();
        LivingEntity livingEntity = easyNPC.getLivingEntity();
        livingEntity.setCustomName(backupState.customName);
        livingEntity.setCustomNameVisible(backupState.shouldShowName);
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft != null) {
            minecraft.options.hideGui = backupState.minecraftHideGui;
        }
        if ((modelData = easyNPC.getEasyNPCModelData()) != null) {
            if (backupState.rootRotation != null) {
                modelData.setModelPartRotation(ModelPartType.ROOT, backupState.rootRotation);
            }
            if (backupState.rootScale != null) {
                modelData.setModelPartScale(ModelPartType.ROOT, backupState.rootScale);
            }
            if (backupState.modelPose != null) {
                modelData.setModelPose(backupState.modelPose);
            }
        }
        if (backupState.entityPose != null) {
            entity.setPose(backupState.entityPose);
        }
        if ((renderData = easyNPC.getEasyNPCRenderData()) != null && renderData.getRenderDataSet() != null && backupState.renderDataSet != null) {
            if (backupState.renderType != null) {
                renderData.getRenderDataSet().setRenderType(backupState.renderType);
            }
            if (backupState.renderEntityType != null) {
                renderData.getRenderDataSet().setRenderEntityType(backupState.renderEntityType);
            }
        }
        if ((skinData = easyNPC.getEasyNPCSkinData()) != null && backupState.skinDataEntry != null) {
            skinData.setSkinDataEntry(backupState.skinDataEntry);
        }
        if ((variantData = easyNPC.getEasyNPCVariantData()) != null && backupState.variantType != null) {
            variantData.setVariantType(backupState.variantType);
        }
        if ((professionData = easyNPC.getEasyNPCProfessionData()) != null && backupState.profession != null) {
            professionData.setProfession(backupState.profession);
        }
    }

    private static class EntityRenderState {
        final Component customName;
        final boolean shouldShowName;
        final boolean minecraftHideGui;
        final CustomRotation rootRotation;
        final CustomScale rootScale;
        final ModelPose modelPose;
        final Pose entityPose;
        final RenderDataSet renderDataSet;
        final RenderType renderType;
        final EntityType<?> renderEntityType;
        final SkinDataEntry skinDataEntry;
        final Enum<?> variantType;
        final Profession profession;

        EntityRenderState(LivingEntity livingEntity, EasyNPC<?> easyNPC, EntityRenderConfig config) {
            this.customName = livingEntity.getCustomName();
            this.shouldShowName = livingEntity.shouldShowName();
            Minecraft minecraft = Minecraft.getInstance();
            this.minecraftHideGui = minecraft != null ? minecraft.options.hideGui : false;
            ModelDataCapable modelData = easyNPC.getEasyNPCModelData();
            if (modelData != null) {
                this.rootRotation = modelData.getModelPartRotation(ModelPartType.ROOT);
                this.rootScale = modelData.getModelPartScale(ModelPartType.ROOT);
                this.modelPose = modelData.getModelPose();
            } else {
                this.rootRotation = null;
                this.rootScale = null;
                this.modelPose = null;
            }
            this.entityPose = easyNPC.getEntity().getPose();
            RenderDataCapable renderData = easyNPC.getEasyNPCRenderData();
            if (renderData != null && renderData.getRenderDataSet() != null) {
                this.renderDataSet = renderData.getRenderDataSet();
                this.renderType = renderData.getRenderDataSet().getRenderType();
                this.renderEntityType = renderData.getRenderDataSet().getRenderEntityType();
            } else {
                this.renderDataSet = null;
                this.renderType = null;
                this.renderEntityType = null;
            }
            SkinDataCapable skinData = easyNPC.getEasyNPCSkinData();
            this.skinDataEntry = skinData != null ? skinData.getSkinDataEntry() : null;
            VariantDataCapable variantData = easyNPC.getEasyNPCVariantData();
            this.variantType = variantData != null ? variantData.getVariantType() : null;
            ProfessionDataCapable professionData = easyNPC.getEasyNPCProfessionData();
            this.profession = professionData != null ? professionData.getProfession() : null;
        }
    }
}

