/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.commands.arguments;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import de.markusbordihn.easynpc.client.renderer.manager.EntityTypeManager;
import de.markusbordihn.easynpc.network.components.TextComponent;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;

public class EntityTypeArgument
implements ArgumentType<EntityType<? extends Entity>> {
    private static final Collection<String> EXAMPLES = Arrays.asList("minecraft:pig", "minecraft:cow");
    private static final SimpleCommandExceptionType ERROR_UNKNOWN_ENTITY = new SimpleCommandExceptionType((Message)TextComponent.getTranslatedTextRaw("argument.entity.unknown"));

    public static EntityTypeArgument entityType() {
        return new EntityTypeArgument();
    }

    public static EntityType<? extends Entity> getEntityType(CommandContext<CommandSourceStack> commandContext, String entityName) {
        return (EntityType)commandContext.getArgument(entityName, EntityType.class);
    }

    public EntityType<? extends Entity> parse(StringReader stringReader) throws CommandSyntaxException {
        String entityName = stringReader.getRemaining();
        EntityType entityType = (EntityType)EntityType.byString((String)entityName).orElseThrow(() -> ((SimpleCommandExceptionType)ERROR_UNKNOWN_ENTITY).create());
        stringReader.setCursor(stringReader.getCursor() + entityName.length());
        return entityType;
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder suggestionsBuilder) {
        Set knownEntityTypes = EntityTypeManager.getSupportedEntityTypes().stream().map(entityType -> BuiltInRegistries.ENTITY_TYPE.getKey(entityType).toString()).collect(Collectors.toSet());
        return SharedSuggestionProvider.suggest(knownEntityTypes, (SuggestionsBuilder)suggestionsBuilder);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }
}

