/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.data;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import de.markusbordihn.easynpc.data.synched.SynchedDataIndex;
import de.markusbordihn.easynpc.data.trading.TradingDataSet;
import de.markusbordihn.easynpc.data.trading.TradingType;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.SoundDataCapable;
import de.markusbordihn.easynpc.network.components.TextComponent;
import de.markusbordihn.easynpc.network.syncher.EntityDataSerializersManager;
import java.util.EnumMap;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.ItemCost;
import net.minecraft.world.item.trading.Merchant;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.ItemLike;
import org.apache.logging.log4j.Logger;

public interface TradingDataCapable<E extends PathfinderMob>
extends EasyNPC<E>,
Merchant {
    public static final String DATA_OFFERS_TAG = "Offers";
    public static final String DATA_TRADING_DATA_TAG = "TradingData";

    public static void registerSyncedTradingData(EnumMap<SynchedDataIndex, EntityDataAccessor<?>> map, Class<? extends Entity> entityClass) {
        log.info("- Registering Synched Trading Data for {}.", (Object)entityClass.getSimpleName());
        map.put(SynchedDataIndex.TRADING_DATA_SET, SynchedEntityData.defineId(entityClass, EntityDataSerializersManager.TRADING_DATA_SET));
        map.put(SynchedDataIndex.TRADING_INVENTORY, SynchedEntityData.defineId(entityClass, (EntityDataSerializer)EntityDataSerializers.COMPOUND_TAG));
        map.put(SynchedDataIndex.TRADING_MERCHANT_OFFERS, SynchedEntityData.defineId(entityClass, EntityDataSerializersManager.MERCHANT_OFFERS));
    }

    private static ItemCost getItemCost(ItemStack itemStack) {
        return new ItemCost((ItemLike)(itemStack.isEmpty() ? ItemStack.EMPTY.getItem() : itemStack.getItem()), itemStack.getCount());
    }

    private static Optional<ItemCost> getOptionalItemCost(ItemStack itemStack) {
        return itemStack.isEmpty() ? Optional.empty() : Optional.of(TradingDataCapable.getItemCost(itemStack));
    }

    public Player getTradingPlayer();

    public void setTradingPlayer(Player var1);

    public MerchantOffers getMerchantTradingOffers();

    public void setMerchantTradingOffers(MerchantOffers var1);

    public void rewardTradeXp(MerchantOffer var1);

    public void stopTrading();

    default public MerchantOffers getOffers() {
        if (this.getMerchantTradingOffers() == null) {
            this.updateMerchantTradingOffers();
        }
        return this.getMerchantTradingOffers();
    }

    default public void updateMerchantTradingOffers() {
        TradingDataSet tradingDataSet = this.getTradingDataSet();
        MerchantOffers merchantOffers = new MerchantOffers();
        if (tradingDataSet.isType(TradingType.BASIC) || tradingDataSet.isType(TradingType.ADVANCED) || tradingDataSet.isType(TradingType.CUSTOM)) {
            merchantOffers = this.getTradingOffers().copy();
        }
        if (!merchantOffers.isEmpty()) {
            merchantOffers.removeIf(merchantOffer -> merchantOffer.getBaseCostA().isEmpty() && merchantOffer.getCostB().isEmpty() || merchantOffer.getResult().isEmpty());
        }
        this.setMerchantTradingOffers(merchantOffers);
    }

    default public void overrideOffers(MerchantOffers merchantOffers) {
    }

    default public int getVillagerXp() {
        return 0;
    }

    default public void overrideXp(int experience) {
    }

    default public boolean showProgressBar() {
        return true;
    }

    default public SoundEvent getNotifyTradeSound() {
        return SoundEvents.VILLAGER_YES;
    }

    @Override
    default public boolean isClientSideInstance() {
        return this.getEntityLevel() != null && this.getEntityLevel().isClientSide();
    }

    default public void setAdvancedTradingOffers(Container container) {
        log.debug("Setting advanced trading offers for {} with container {}", (Object)this, (Object)container);
        MerchantOffers merchantOffers = new MerchantOffers();
        int merchantOfferIndex = 0;
        for (int tradingOffer = 0; tradingOffer < 25; ++tradingOffer) {
            MerchantOffer existingMerchantOffer;
            ItemStack itemResult;
            ItemStack itemB;
            ItemStack itemA = container.getItem(tradingOffer * 3);
            if (!this.isValidTradingOffer(itemA, itemB = container.getItem(tradingOffer * 3 + 1), itemResult = container.getItem(tradingOffer * 3 + 2))) continue;
            ItemCost itemCostA = TradingDataCapable.getItemCost(itemA);
            Optional<ItemCost> itemCostB = TradingDataCapable.getOptionalItemCost(itemB);
            MerchantOffers existingMerchantOffers = this.getTradingOffers();
            MerchantOffer merchantOffer = existingMerchantOffer = existingMerchantOffers != null && existingMerchantOffers.size() > tradingOffer ? (MerchantOffer)existingMerchantOffers.get(tradingOffer) : null;
            if (existingMerchantOffer != null) {
                merchantOffers.add(merchantOfferIndex++, (Object)new MerchantOffer(itemCostA, itemCostB, itemResult, existingMerchantOffer.getUses(), existingMerchantOffer.getMaxUses(), existingMerchantOffer.getXp(), existingMerchantOffer.getPriceMultiplier(), existingMerchantOffer.getDemand()));
                continue;
            }
            merchantOffers.add(merchantOfferIndex++, (Object)new MerchantOffer(itemCostA, itemCostB, itemResult, 64, 1, 1.0f));
        }
        if (!merchantOffers.isEmpty()) {
            this.getTradingDataSet().setType(TradingType.ADVANCED);
            this.setTradingOffers(merchantOffers);
        }
    }

    default public void setBasicTradingOffers(Container container) {
        log.debug("Setting basic trading offers for {} with container {}", (Object)this, (Object)container);
        MerchantOffers merchantOffers = new MerchantOffers();
        for (int tradingOffer = 0; tradingOffer < 12; ++tradingOffer) {
            ItemStack itemResult;
            ItemStack itemB;
            ItemStack itemA = container.getItem(tradingOffer * 3);
            if (!this.isValidTradingOffer(itemA, itemB = container.getItem(tradingOffer * 3 + 1), itemResult = container.getItem(tradingOffer * 3 + 2))) continue;
            ItemCost itemCostA = TradingDataCapable.getItemCost(itemA);
            Optional<ItemCost> itemCostB = TradingDataCapable.getOptionalItemCost(itemB);
            MerchantOffer merchantOffer = new MerchantOffer(itemCostA, itemCostB, itemResult, this.getTradingDataSet().getMaxUses(), this.getTradingDataSet().getRewardedXP(), 1.0f);
            merchantOffers.add((Object)merchantOffer);
        }
        if (!merchantOffers.isEmpty()) {
            this.getTradingDataSet().setType(TradingType.BASIC);
            this.setTradingOffers(merchantOffers);
        }
    }

    default public void updateBasicTradingOffers() {
        if (this.getTradingDataSet().isType(TradingType.BASIC)) {
            return;
        }
        MerchantOffers merchantOffers = this.getTradingOffers();
        if (merchantOffers == null || merchantOffers.isEmpty()) {
            return;
        }
        MerchantOffers newMerchantOffers = new MerchantOffers();
        for (MerchantOffer merchantOffer : merchantOffers) {
            if (!this.isValidTradingOffer(merchantOffer.getBaseCostA(), merchantOffer.getCostB(), merchantOffer.getResult())) continue;
            MerchantOffer newMerchantOffer = new MerchantOffer(TradingDataCapable.getItemCost(merchantOffer.getBaseCostA()), TradingDataCapable.getOptionalItemCost(merchantOffer.getCostB()), merchantOffer.getResult(), this.getTradingDataSet().getMaxUses(), this.getTradingDataSet().getRewardedXP(), merchantOffer.getPriceMultiplier());
            newMerchantOffers.add((Object)newMerchantOffer);
        }
        this.setTradingOffers(newMerchantOffers);
    }

    default public void resetTradingOffers() {
        MerchantOffers merchantOffers = this.getTradingOffers();
        if (merchantOffers == null || merchantOffers.isEmpty()) {
            return;
        }
        log.debug("Reset trading offers {} for {}", (Object)merchantOffers, (Object)this);
        for (MerchantOffer merchantOffer : merchantOffers) {
            merchantOffer.resetUses();
        }
        this.setTradingOffers(merchantOffers);
        this.getTradingDataSet().setLastReset(System.currentTimeMillis());
    }

    default public MerchantOffers getTradingOffers() {
        return (MerchantOffers)this.getSynchedEntityData(SynchedDataIndex.TRADING_MERCHANT_OFFERS);
    }

    default public void setTradingOffers(MerchantOffers merchantOffers) {
        this.setSynchedEntityData(SynchedDataIndex.TRADING_MERCHANT_OFFERS, new MerchantOffers());
        this.setSynchedEntityData(SynchedDataIndex.TRADING_MERCHANT_OFFERS, merchantOffers);
        this.updateMerchantTradingOffers();
    }

    default public void notifyTrade(MerchantOffer merchantOffer) {
        merchantOffer.increaseUses();
        this.getMob().ambientSoundTime = -this.getMob().getAmbientSoundInterval();
        this.rewardTradeXp(merchantOffer);
        Player player = this.getTradingPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            log.debug("Trade {} with {} for {}", (Object)merchantOffer, (Object)serverPlayer, (Object)this);
        }
    }

    default public void notifyTradeUpdated(ItemStack itemStack) {
        if (!this.isClientSideInstance() && this.getMob().ambientSoundTime > -this.getMob().getAmbientSoundInterval() + 20) {
            this.getMob().ambientSoundTime = -this.getMob().getAmbientSoundInterval();
            SoundDataCapable soundData = this.getEasyNPCSoundData();
            soundData.playDefaultTradeUpdatedSound(!itemStack.isEmpty());
        }
    }

    default public void rewardMerchantTradeXp(MerchantOffer merchantOffer) {
        if (merchantOffer.shouldRewardExp() && merchantOffer.getXp() > 0) {
            LivingEntity livingEntity = this.getLivingEntity();
            int tradeExperience = 3 + livingEntity.getRandom().nextInt(merchantOffer.getXp());
            livingEntity.level().addFreshEntity((Entity)new ExperienceOrb(livingEntity.level(), livingEntity.getX(), livingEntity.getY() + 0.5, livingEntity.getZ(), tradeExperience));
        }
    }

    default public boolean hasTradingData() {
        TradingType tradingType = this.getTradingDataSet().getType();
        return (tradingType == TradingType.BASIC || tradingType == TradingType.ADVANCED) && this.getTradingOffers() != null && !this.getTradingOffers().isEmpty() || tradingType == TradingType.CUSTOM;
    }

    default public void stopMerchantTrading() {
        Merchant merchant = this.getMerchant();
        if (merchant != null) {
            merchant.setTradingPlayer(null);
        }
    }

    default public void setAdvancedTradingMaxUses(int tradingOfferIndex, int maxUses) {
        MerchantOffers merchantOffers = this.getTradingOffers();
        if (merchantOffers == null || merchantOffers.isEmpty() || merchantOffers.size() <= tradingOfferIndex) {
            return;
        }
        MerchantOffer merchantOffer = (MerchantOffer)merchantOffers.get(tradingOfferIndex);
        if (merchantOffer == null) {
            return;
        }
        merchantOffers.set(tradingOfferIndex, (Object)new MerchantOffer(TradingDataCapable.getItemCost(merchantOffer.getBaseCostA()), TradingDataCapable.getOptionalItemCost(merchantOffer.getCostB()), merchantOffer.getResult(), 0, maxUses, merchantOffer.getXp(), merchantOffer.getPriceMultiplier(), merchantOffer.getDemand()));
        this.setTradingOffers(merchantOffers);
    }

    default public void setAdvancedTradingXp(int tradingOfferIndex, int xp) {
        MerchantOffers merchantOffers = this.getTradingOffers();
        if (merchantOffers == null || merchantOffers.isEmpty() || merchantOffers.size() <= tradingOfferIndex) {
            return;
        }
        MerchantOffer merchantOffer = (MerchantOffer)merchantOffers.get(tradingOfferIndex);
        if (merchantOffer == null) {
            return;
        }
        merchantOffers.set(tradingOfferIndex, (Object)new MerchantOffer(TradingDataCapable.getItemCost(merchantOffer.getBaseCostA()), TradingDataCapable.getOptionalItemCost(merchantOffer.getCostB()), merchantOffer.getResult(), merchantOffer.getUses(), merchantOffer.getMaxUses(), xp, merchantOffer.getPriceMultiplier(), merchantOffer.getDemand()));
        this.setTradingOffers(merchantOffers);
    }

    default public void setAdvancedTradingPriceMultiplier(int tradingOfferIndex, float priceMultiplier) {
        MerchantOffers merchantOffers = this.getTradingOffers();
        if (merchantOffers == null || merchantOffers.isEmpty() || merchantOffers.size() <= tradingOfferIndex) {
            return;
        }
        MerchantOffer merchantOffer = (MerchantOffer)merchantOffers.get(tradingOfferIndex);
        if (merchantOffer == null) {
            return;
        }
        merchantOffers.set(tradingOfferIndex, (Object)new MerchantOffer(TradingDataCapable.getItemCost(merchantOffer.getBaseCostA()), TradingDataCapable.getOptionalItemCost(merchantOffer.getCostB()), merchantOffer.getResult(), merchantOffer.getUses(), merchantOffer.getMaxUses(), merchantOffer.getXp(), priceMultiplier, merchantOffer.getDemand()));
        this.setTradingOffers(merchantOffers);
    }

    default public void setAdvancedTradingDemand(int tradingOfferIndex, int demand) {
        MerchantOffers merchantOffers = this.getTradingOffers();
        if (merchantOffers == null || merchantOffers.isEmpty() || merchantOffers.size() <= tradingOfferIndex) {
            return;
        }
        MerchantOffer merchantOffer = (MerchantOffer)merchantOffers.get(tradingOfferIndex);
        if (merchantOffer == null) {
            return;
        }
        merchantOffers.set(tradingOfferIndex, (Object)new MerchantOffer(TradingDataCapable.getItemCost(merchantOffer.getBaseCostA()), TradingDataCapable.getOptionalItemCost(merchantOffer.getCostB()), merchantOffer.getResult(), merchantOffer.getUses(), merchantOffer.getMaxUses(), merchantOffer.getXp(), merchantOffer.getPriceMultiplier(), demand));
        this.setTradingOffers(merchantOffers);
    }

    default public TradingDataSet getTradingDataSet() {
        return (TradingDataSet)this.getSynchedEntityData(SynchedDataIndex.TRADING_DATA_SET);
    }

    default public void setTradingDataSet(TradingDataSet tradingDataSet) {
        this.setSynchedEntityData(SynchedDataIndex.TRADING_DATA_SET, tradingDataSet);
    }

    default public void updateTradingDataSet() {
        TradingDataSet currentTradingDataSet = this.getTradingDataSet();
        this.setTradingDataSet(new TradingDataSet());
        this.setTradingDataSet(currentTradingDataSet);
    }

    default public boolean isValidTradingOffer(ItemStack itemA, ItemStack itemB, ItemStack itemResult) {
        if (itemResult == null || itemA == null && itemB == null) {
            return false;
        }
        return (itemA != null && !itemA.isEmpty() || itemB != null && !itemB.isEmpty()) && !itemResult.isEmpty();
    }

    default public void openTradingScreen(ServerPlayer serverPlayer) {
        if (this.isClientSideInstance()) {
            return;
        }
        Merchant merchant = this.getMerchant();
        if (merchant == null) {
            log.error("No merchant found for {} with {} from {}", (Object)this, (Object)this.getTradingOffers(), (Object)serverPlayer);
            return;
        }
        MerchantOffers merchantOffers = merchant.getOffers();
        if (merchantOffers.isEmpty()) {
            log.error("No trading offers found for {} with {} from {}", (Object)this, (Object)merchantOffers, (Object)serverPlayer);
            return;
        }
        if (merchant.getTradingPlayer() != null && merchant.getTradingPlayer() != serverPlayer) {
            log.warn("Unable to open trading screen for {} with {} from {}, {} is still trading.", (Object)this, (Object)merchantOffers, (Object)serverPlayer, (Object)merchant.getTradingPlayer());
            serverPlayer.closeContainer();
            serverPlayer.sendSystemMessage((Component)TextComponent.getTranslatedText("trading.busy", this.getLivingEntity(), merchant.getTradingPlayer()));
            return;
        }
        if (this.getTradingDataSet().getResetsEveryMin() > 0) {
            long currentTime = System.currentTimeMillis();
            long resetTimeInMillis = (long)this.getTradingDataSet().getResetsEveryMin() * 60L * 1000L;
            if (currentTime - this.getTradingDataSet().getLastReset() > resetTimeInMillis) {
                this.resetTradingOffers();
            }
        }
        log.debug("Open trading screen for {} with {} from {}", (Object)this, (Object)merchantOffers, (Object)serverPlayer);
        merchant.setTradingPlayer((Player)serverPlayer);
        merchant.openTradingScreen((Player)serverPlayer, (Component)(this.getEntity().getCustomName() != null ? this.getEntity().getCustomName() : TextComponent.getTranslatedText("trading")), 140);
    }

    default public void defineSynchedTradingData(SynchedEntityData.Builder builder) {
        this.defineSynchedEntityData(builder, SynchedDataIndex.TRADING_DATA_SET, new TradingDataSet());
        this.defineSynchedEntityData(builder, SynchedDataIndex.TRADING_INVENTORY, new CompoundTag());
        this.defineSynchedEntityData(builder, SynchedDataIndex.TRADING_MERCHANT_OFFERS, new MerchantOffers());
    }

    default public void addAdditionalTradingData(CompoundTag compoundTag, HolderLookup.Provider provider) {
        CompoundTag tradingDataTag = new CompoundTag();
        TradingDataSet tradingDataSet = this.getTradingDataSet();
        if (tradingDataSet != null) {
            tradingDataSet.save(tradingDataTag);
        }
        compoundTag.put(DATA_TRADING_DATA_TAG, (Tag)tradingDataTag);
        MerchantOffers merchantOffers = this.getTradingOffers();
        if (merchantOffers != null && !merchantOffers.isEmpty()) {
            compoundTag.put(DATA_OFFERS_TAG, (Tag)MerchantOffers.CODEC.encodeStart((DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)merchantOffers).getOrThrow());
        }
    }

    default public void readAdditionalTradingData(CompoundTag compoundTag, HolderLookup.Provider provider) {
        CompoundTag tradingDataTag = compoundTag.getCompound(DATA_TRADING_DATA_TAG);
        if (tradingDataTag.contains("TradingDataSet")) {
            TradingDataSet tradingDataSet = new TradingDataSet(tradingDataTag);
            this.setTradingDataSet(tradingDataSet);
        }
        if (!compoundTag.contains(DATA_OFFERS_TAG)) {
            return;
        }
        DataResult dataResult = MerchantOffers.CODEC.parse((DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)compoundTag.get(DATA_OFFERS_TAG));
        dataResult.resultOrPartial(Util.prefix((String)"Failed to load offers: ", arg_0 -> ((Logger)log).warn(arg_0))).ifPresent(this::setTradingOffers);
    }
}

