/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.npc.standard;

import de.markusbordihn.easynpc.data.sound.SoundDataSet;
import de.markusbordihn.easynpc.data.sound.SoundType;
import de.markusbordihn.easynpc.entity.easynpc.npc.raw.EvokerRaw;
import de.markusbordihn.easynpc.entity.easynpc.npc.standard.StandardEasyNPC;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.monster.Evoker;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class EvokerNPC
extends EvokerRaw
implements StandardEasyNPC<EvokerRaw> {
    public static final String ID = "evoker";

    public EvokerNPC(EntityType<? extends Evoker> entityType, Level level) {
        super(entityType, level, EvokerRaw.VariantType.EVOKER);
    }

    public EvokerNPC(EntityType<? extends Evoker> entityType, Level level, Enum<?> variant) {
        super(entityType, level, variant);
        this.setInvulnerable(true);
        this.refreshGroundNavigation();
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 20.0).add(Attributes.FOLLOW_RANGE, 32.0).add(Attributes.KNOCKBACK_RESISTANCE, 0.0).add(Attributes.MOVEMENT_SPEED, (double)0.6f).add(Attributes.ATTACK_DAMAGE, 1.0).add(Attributes.ATTACK_KNOCKBACK, 0.0).add(Attributes.ATTACK_SPEED, 0.0).add(Attributes.ARMOR, 0.0).add(Attributes.ARMOR_TOUGHNESS, 0.0);
    }

    @Override
    public SoundDataSet getDefaultSoundDataSet(SoundDataSet soundDataSet, String variantName) {
        soundDataSet.addDefaultSound(SoundType.AMBIENT, SoundEvents.EVOKER_AMBIENT);
        soundDataSet.addDefaultSound(SoundType.DEATH, SoundEvents.EVOKER_DEATH);
        soundDataSet.addDefaultSound(SoundType.HURT, SoundEvents.EVOKER_HURT);
        soundDataSet.addDefaultSound(SoundType.CAST_SPELL, SoundEvents.EVOKER_CAST_SPELL);
        soundDataSet.addDefaultSound(SoundType.CELEBRATE, SoundEvents.EVOKER_CELEBRATE);
        soundDataSet.addDefaultSound(SoundType.TRADE, SoundEvents.VILLAGER_TRADE);
        soundDataSet.addDefaultSound(SoundType.TRADE_YES, SoundEvents.VILLAGER_YES);
        soundDataSet.addDefaultSound(SoundType.TRADE_NO, SoundEvents.VILLAGER_NO);
        return soundDataSet;
    }

    protected void registerGoals() {
    }

    @Override
    public void travel(Vec3 vec3) {
        this.handleNavigationTravelEvent(vec3);
        if (this.hasTravelTargetObjectives()) {
            super.travel(vec3);
        } else {
            this.calculateEntityAnimation(this instanceof FlyingAnimal);
        }
    }
}

