/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.npc.standard;

import com.google.common.collect.ImmutableList;
import de.markusbordihn.easynpc.data.sound.SoundDataSet;
import de.markusbordihn.easynpc.data.sound.SoundType;
import de.markusbordihn.easynpc.entity.easynpc.npc.raw.PiglinRaw;
import de.markusbordihn.easynpc.entity.easynpc.npc.standard.StandardEasyNPC;
import java.util.Collection;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class PiglinNPC
extends PiglinRaw
implements StandardEasyNPC<PiglinRaw> {
    public static final String ID = "piglin";
    public static final String ID_BRUTE = "piglin_brute";
    public static final String ID_ZOMBIFIED = "piglin_zombified";
    protected static final ImmutableList<MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of((Object)MemoryModuleType.ANGRY_AT, (Object)MemoryModuleType.ATTACK_TARGET, (Object)MemoryModuleType.CELEBRATE_LOCATION, (Object)MemoryModuleType.DANCING);

    public PiglinNPC(EntityType<? extends Piglin> entityType, Level level) {
        this(entityType, level, PiglinRaw.VariantType.PIGLIN);
    }

    public PiglinNPC(EntityType<? extends Piglin> entityType, Level level, Enum<?> variantType) {
        super(entityType, level, variantType);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 20.0).add(Attributes.FOLLOW_RANGE, 32.0).add(Attributes.KNOCKBACK_RESISTANCE, 0.0).add(Attributes.MOVEMENT_SPEED, 0.5).add(Attributes.ATTACK_DAMAGE, 1.0).add(Attributes.ATTACK_KNOCKBACK, 0.0).add(Attributes.ATTACK_SPEED, 0.0).add(Attributes.ARMOR, 0.0).add(Attributes.ARMOR_TOUGHNESS, 0.0);
    }

    @Override
    public SoundDataSet getDefaultSoundDataSet(SoundDataSet soundDataSet, String variantName) {
        PiglinRaw.VariantType soundVariant = PiglinRaw.VariantType.valueOf(variantName);
        switch (soundVariant) {
            case PIGLIN_BRUTE: {
                soundDataSet.addDefaultSound(SoundType.AMBIENT, SoundEvents.PIGLIN_BRUTE_AMBIENT);
                soundDataSet.addDefaultSound(SoundType.HURT, SoundEvents.PIGLIN_BRUTE_HURT);
                soundDataSet.addDefaultSound(SoundType.DEATH, SoundEvents.PIGLIN_BRUTE_DEATH);
                soundDataSet.addDefaultSound(SoundType.STEP, SoundEvents.PIGLIN_BRUTE_STEP);
                break;
            }
            case ZOMBIFIED_PIGLIN: {
                soundDataSet.addDefaultSound(SoundType.AMBIENT, SoundEvents.ZOMBIFIED_PIGLIN_AMBIENT);
                soundDataSet.addDefaultSound(SoundType.HURT, SoundEvents.ZOMBIFIED_PIGLIN_HURT);
                soundDataSet.addDefaultSound(SoundType.DEATH, SoundEvents.ZOMBIFIED_PIGLIN_DEATH);
                soundDataSet.addDefaultSound(SoundType.STEP, SoundEvents.PIGLIN_STEP);
                break;
            }
            default: {
                soundDataSet.addDefaultSound(SoundType.AMBIENT, SoundEvents.PIGLIN_AMBIENT);
                soundDataSet.addDefaultSound(SoundType.HURT, SoundEvents.PIGLIN_HURT);
                soundDataSet.addDefaultSound(SoundType.DEATH, SoundEvents.PIGLIN_DEATH);
                soundDataSet.addDefaultSound(SoundType.STEP, SoundEvents.PIGLIN_STEP);
            }
        }
        soundDataSet.addDefaultSound(SoundType.TRADE, SoundEvents.VILLAGER_TRADE);
        soundDataSet.addDefaultSound(SoundType.TRADE_YES, SoundEvents.VILLAGER_YES);
        soundDataSet.addDefaultSound(SoundType.TRADE_NO, SoundEvents.VILLAGER_NO);
        return soundDataSet;
    }

    protected void registerGoals() {
    }

    public boolean isConverting() {
        return false;
    }

    protected Brain.Provider<Piglin> brainProvider() {
        return Brain.provider(MEMORY_TYPES, (Collection)SENSOR_TYPES);
    }

    @Override
    public void travel(Vec3 vec3) {
        this.handleNavigationTravelEvent(vec3);
        if (this.hasTravelTargetObjectives()) {
            super.travel(vec3);
        } else {
            this.calculateEntityAnimation(this instanceof FlyingAnimal);
        }
    }
}

