/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.renderer.entity.raw;

import de.markusbordihn.easynpc.client.renderer.entity.EasyNPCEntityRenderer;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.npc.raw.SkeletonRaw;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.SkeletonRenderer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.entity.state.SkeletonRenderState;
import net.minecraft.resources.ResourceLocation;

public class SkeletonRawRenderer
extends SkeletonRenderer
implements EasyNPCEntityRenderer {
    protected static final Map<SkeletonRaw.VariantType, ResourceLocation> TEXTURE_BY_VARIANT_TYPE = (Map)Util.make(new EnumMap(SkeletonRaw.VariantType.class), map -> map.put(SkeletonRaw.VariantType.DEFAULT, ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/entity/skeleton/skeleton.png")));
    protected static final ResourceLocation DEFAULT_TEXTURE = TEXTURE_BY_VARIANT_TYPE.get((Object)SkeletonRaw.VariantType.DEFAULT);

    public SkeletonRawRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public ResourceLocation getTextureLocation(SkeletonRenderState renderState) {
        EasyNPC easyNPC = this.getEasyNPC((LivingEntityRenderState)renderState);
        if (easyNPC != null) {
            return this.getEntityTexture(easyNPC);
        }
        return DEFAULT_TEXTURE;
    }

    @Override
    public ResourceLocation getDefaultTexture() {
        return DEFAULT_TEXTURE;
    }

    @Override
    public ResourceLocation getTextureByVariant(Enum<?> variantType) {
        return TEXTURE_BY_VARIANT_TYPE.getOrDefault(variantType, DEFAULT_TEXTURE);
    }
}

