/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import de.markusbordihn.easynpc.client.model.EasyNPCModelManager;
import de.markusbordihn.easynpc.data.display.DisplayAttributeType;
import de.markusbordihn.easynpc.data.model.ModelPartType;
import de.markusbordihn.easynpc.data.model.ModelPose;
import de.markusbordihn.easynpc.data.rotation.CustomRotation;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.DisplayAttributeDataCapable;
import de.markusbordihn.easynpc.entity.easynpc.data.ModelDataCapable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.LightLayer;

public class EasyNPCModel {
    public static boolean setupAnimationStart(EasyNPC<?> easyNPC, EasyNPCModelManager modelManager) {
        if (easyNPC == null || modelManager == null) {
            return false;
        }
        ModelDataCapable modelData = easyNPC.getEasyNPCModelData();
        if (modelData == null) {
            return false;
        }
        return EasyNPCModel.setupAnimation(easyNPC, modelData, modelManager);
    }

    public static boolean setupAnimation(EasyNPC<?> easyNPC, ModelDataCapable<?> modelData, EasyNPCModelManager modelManager) {
        if (easyNPC == null || modelData == null || modelManager == null) {
            return false;
        }
        if (modelData.getModelPose() == ModelPose.DEFAULT) {
            return false;
        }
        modelManager.resetModelParts();
        return modelManager.setupModelParts(modelData);
    }

    public static int getEntityLightLevel(EasyNPC<?> easyNPC, DisplayAttributeDataCapable<?> displayAttributeData, BlockPos blockPos) {
        if (easyNPC == null || displayAttributeData == null || blockPos == null) {
            return 0;
        }
        int entityLightLevel = displayAttributeData.getDisplayIntAttribute(DisplayAttributeType.LIGHT_LEVEL);
        if (entityLightLevel > 0) {
            return entityLightLevel;
        }
        return easyNPC.getLivingEntity().m_9236_().m_45517_(LightLayer.BLOCK, blockPos);
    }

    public static void renderEntityNameTag(EasyNPC<?> easyNPC, ModelDataCapable<?> modelData, PoseStack poseStack) {
        if (easyNPC == null || modelData == null) {
            return;
        }
        CustomRotation rootRotation = modelData.getModelPartRotation(ModelPartType.ROOT);
        if (rootRotation != null) {
            poseStack.m_252880_(0.0f, 1.0f, 0.0f);
            poseStack.m_252781_(Axis.f_252529_.m_252977_(-rootRotation.x()));
            poseStack.m_252781_(Axis.f_252436_.m_252977_(-rootRotation.y()));
            poseStack.m_252781_(Axis.f_252403_.m_252977_(-rootRotation.z()));
            poseStack.m_252880_(0.0f, -1.0f, 0.0f);
        }
    }
}

