/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.screen;

import de.markusbordihn.easynpc.client.screen.ScreenInterface;
import de.markusbordihn.easynpc.client.screen.components.CloseButton;
import de.markusbordihn.easynpc.data.screen.AdditionalScreenData;
import de.markusbordihn.easynpc.data.screen.ScreenData;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.menu.EasyNPCMenu;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.glfw.GLFW;

public class ContainerScreen<T extends EasyNPCMenu>
extends AbstractContainerScreen<T>
implements ScreenInterface {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");
    protected static double formerMouseX = -1.0;
    protected static double formerMouseY = -1.0;
    protected final Minecraft minecraftInstance;
    protected final T menu;
    protected float xMouse;
    protected float yMouse;
    protected int rightPos;
    protected int bottomPos;
    protected boolean renderBackground = true;
    protected boolean showCloseButton = true;
    protected Button closeButton = null;
    protected boolean compactMode = false;

    protected ContainerScreen(T menu, Inventory inventory, Component component) {
        this(menu, inventory, component, 318, 243);
    }

    protected ContainerScreen(T menu, Inventory inventory, Component component, int width, int height) {
        super(menu, inventory, component);
        this.f_97726_ = width;
        this.f_97727_ = height;
        this.menu = menu;
        this.minecraftInstance = Minecraft.m_91087_();
    }

    protected static void resetFormerMousePosition() {
        ContainerScreen.setFormerMousePosition(-1.0, -1.0);
    }

    protected static void setFormerMousePosition(double x, double y) {
        formerMouseX = x;
        formerMouseY = y;
    }

    @Override
    public EasyNPC<?> getEasyNPC() {
        return ((EasyNPCMenu)((Object)this.menu)).getEasyNPC();
    }

    @Override
    public ScreenData getScreenData() {
        return ((EasyNPCMenu)((Object)this.menu)).getScreenData();
    }

    @Override
    public AdditionalScreenData getAdditionalScreenData() {
        return ((EasyNPCMenu)((Object)this.menu)).getAdditionalScreenData();
    }

    public void closeScreen() {
        if (this.minecraftInstance != null) {
            this.minecraftInstance.m_91152_(null);
        }
        this.m_7379_();
    }

    protected void m_7856_() {
        super.m_7856_();
        this.compactMode = this.f_96544_ < 260;
        this.f_97728_ = 7;
        this.f_97729_ = -9;
        this.f_97736_ = (this.f_96544_ - this.f_97727_) / 2 + (this.compactMode ? 2 : 10);
        this.f_97735_ = (this.f_96543_ - this.f_97726_) / 2;
        this.rightPos = this.f_97735_ + this.f_97726_;
        this.bottomPos = this.f_97736_ + this.f_97727_;
        if (formerMouseX > 0.0 && formerMouseY > 0.0) {
            GLFW.glfwSetCursorPos((long)this.minecraftInstance.m_91268_().m_85439_(), (double)formerMouseX, (double)formerMouseY);
            ContainerScreen.resetFormerMousePosition();
        }
        if (this.showCloseButton) {
            this.closeButton = (Button)this.m_142416_((GuiEventListener)new CloseButton(this.rightPos - 15, this.f_97736_ + 4, onPress -> this.closeScreen()));
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        ContainerScreen.setFormerMousePosition(Minecraft.m_91087_().f_91067_.m_91589_(), Minecraft.m_91087_().f_91067_.m_91594_());
        return super.m_6375_(mouseX, mouseY, button);
    }

    public void m_88315_(GuiGraphics guiGraphics, int x, int y, float partialTicks) {
        if (this.renderBackground) {
            super.m_280273_(guiGraphics);
        }
        super.m_88315_(guiGraphics, x, y, partialTicks);
        this.xMouse = x;
        this.yMouse = y;
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        this.renderDefaultScreenBg(guiGraphics, this.f_97735_, this.f_97736_);
        if (!this.compactMode) {
            this.renderDefaultTitleBg(guiGraphics, this.f_97735_, this.f_97736_);
        }
    }

    public void m_7379_() {
        ContainerScreen.resetFormerMousePosition();
        super.m_7379_();
    }

    public boolean m_7933_(int keyCode, int unused1, int unused2) {
        if (keyCode != 257 && keyCode != 335 && keyCode != 69 && keyCode != 73) {
            return super.m_7933_(keyCode, unused1, unused2);
        }
        return keyCode == 257 || keyCode == 335 || keyCode == 73;
    }
}

