/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.commands.selector;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.context.StringRange;
import com.mojang.brigadier.suggestion.Suggestion;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import de.markusbordihn.easynpc.commands.suggestion.EasyNPCSuggestions;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.commands.arguments.selector.EntitySelectorParser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EasyNPCSelectorParser
extends EntitySelectorParser {
    private static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");

    public EasyNPCSelectorParser(StringReader stringReader) {
        this(stringReader, true);
    }

    public EasyNPCSelectorParser(StringReader stringReader, boolean allowSelectors) {
        super(stringReader, allowSelectors);
    }

    public CompletableFuture<Suggestions> m_121249_(SuggestionsBuilder suggestionsBuilder, Consumer<SuggestionsBuilder> consumer) {
        Stream<String> possibleUUIDs;
        StringRange stringRange = StringRange.between((int)suggestionsBuilder.getStart(), (int)suggestionsBuilder.getInput().length());
        ArrayList suggestionsList = new ArrayList();
        try {
            CompletableFuture suggestionsOriginal = super.m_121249_(suggestionsBuilder, consumer);
            List originalSuggestionsList = ((Suggestions)suggestionsOriginal.get()).getList();
            stringRange = ((Suggestions)suggestionsOriginal.get()).getRange();
            originalSuggestionsList.stream().filter(suggestion -> !suggestion.getText().matches("@[pars]")).forEach(suggestion -> {
                if (suggestion.getText().startsWith("@")) {
                    suggestionsList.add(suggestion);
                } else {
                    suggestionsList.add(0, suggestion);
                }
            });
        }
        catch (InterruptedException | ExecutionException e) {
            log.error("Failed to get suggestions:", (Throwable)e);
        }
        String argument = suggestionsBuilder.getRemainingLowerCase();
        if (argument != null && !argument.isEmpty() && !argument.startsWith("@") && (possibleUUIDs = EasyNPCSuggestions.suggestUUID(argument)) != null) {
            possibleUUIDs.forEach(uuid -> {
                for (Suggestion suggestion : suggestionsList) {
                    if (!suggestion.getText().equals(uuid)) continue;
                    return;
                }
                suggestionsList.add(new Suggestion(StringRange.between((int)suggestionsBuilder.getStart(), (int)suggestionsBuilder.getInput().length()), uuid));
            });
        }
        CompletableFuture<Suggestions> suggestions = CompletableFuture.completedFuture(new Suggestions(stringRange, suggestionsList));
        this.m_121270_((suggestionsBuilder1, consumer1) -> suggestions);
        return suggestions;
    }
}

