/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.data.npc;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import de.markusbordihn.easynpc.data.npc.UserDefinedConfiguration;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UserDefinedConfigurationManager {
    private static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final String CONFIG_FILE_NAME = "user_defined_npcs.json";
    private static final String CONFIG_DIRECTORY = "config/easy_npc";
    private static final File CONFIG_DIRECTORY_FILE = new File("config/easy_npc");
    private static final File CONFIG_FILE = new File("config/easy_npc", "user_defined_npcs.json");
    private static final Map<String, UserDefinedConfiguration> configurations = new HashMap<String, UserDefinedConfiguration>();
    private static final String JSON_FIELD_WIDTH = "width";
    private static final String JSON_FIELD_HEIGHT = "height";
    private static final String JSON_FIELD_DESCRIPTION = "description";
    private static boolean initialized = false;

    private UserDefinedConfigurationManager() {
    }

    public static void initialize() {
        if (initialized) {
            return;
        }
        UserDefinedConfigurationManager.loadConfigurations();
        initialized = true;
    }

    public static Map<String, UserDefinedConfiguration> getUserDefinedConfigurations() {
        if (!initialized) {
            UserDefinedConfigurationManager.initialize();
        }
        return Collections.unmodifiableMap(configurations);
    }

    public static UserDefinedConfiguration getConfiguration(String configurationId) {
        if (!initialized) {
            UserDefinedConfigurationManager.initialize();
        }
        return configurations.get(configurationId);
    }

    public static boolean addConfiguration(UserDefinedConfiguration configuration) {
        if (!configuration.isValid()) {
            log.warn("Invalid configuration: {}", (Object)configuration);
            return false;
        }
        if (configurations.containsKey(configuration.id())) {
            log.warn("Configuration with ID {} already exists", (Object)configuration.id());
            return false;
        }
        configurations.put(configuration.id(), configuration);
        UserDefinedConfigurationManager.saveConfigurations();
        return true;
    }

    public static boolean removeConfiguration(String configurationId) {
        if (configurations.remove(configurationId) != null) {
            UserDefinedConfigurationManager.saveConfigurations();
            return true;
        }
        return false;
    }

    private static void loadConfigurations() {
        configurations.clear();
        if (!CONFIG_FILE.exists()) {
            log.info("Configuration file {} does not exist, creating with example configurations", (Object)CONFIG_FILE_NAME);
            UserDefinedConfigurationManager.createExampleConfiguration();
            return;
        }
        try (FileReader reader = new FileReader(CONFIG_FILE);){
            JsonElement jsonElement = JsonParser.parseReader((Reader)reader);
            if (!jsonElement.isJsonObject()) {
                log.error("Invalid JSON format in configuration file");
                return;
            }
            JsonObject rootObject = jsonElement.getAsJsonObject();
            JsonArray configurationsArray = rootObject.getAsJsonArray("user_defined_npcs");
            if (configurationsArray == null) {
                log.warn("No 'user_defined_npcs' array found in configuration file");
                return;
            }
            for (JsonElement configElement : configurationsArray) {
                try {
                    UserDefinedConfiguration config = UserDefinedConfigurationManager.parseConfiguration(configElement.getAsJsonObject());
                    if (config == null || !config.isValid()) continue;
                    configurations.put(config.id(), config);
                }
                catch (Exception e) {
                    log.error("Failed to parse configuration: {}", (Object)e.getMessage(), (Object)e);
                }
            }
            log.info("Loaded {} user-defined NPC configurations", (Object)configurations.size());
        }
        catch (JsonSyntaxException | IOException e) {
            log.error("Failed to load user-defined configurations: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private static UserDefinedConfiguration parseConfiguration(JsonObject configObject) {
        return UserDefinedConfigurationManager.parseConfigurationSafely(configObject);
    }

    private static UserDefinedConfiguration parseConfigurationSafely(JsonObject configObject) {
        try {
            String id = configObject.get("id").getAsString();
            String name = configObject.get("name").getAsString();
            String baseEntityTypeId = configObject.get("base_entity_type").getAsString();
            float width = configObject.has(JSON_FIELD_WIDTH) ? configObject.get(JSON_FIELD_WIDTH).getAsFloat() : 0.6f;
            float height = configObject.has(JSON_FIELD_HEIGHT) ? configObject.get(JSON_FIELD_HEIGHT).getAsFloat() : 1.95f;
            String description = configObject.has(JSON_FIELD_DESCRIPTION) ? configObject.get(JSON_FIELD_DESCRIPTION).getAsString() : "";
            EntityType<?> baseEntityType = UserDefinedConfigurationManager.parseEntityType(baseEntityTypeId);
            if (baseEntityType == null) {
                log.error("Unknown entity type: {}", (Object)baseEntityTypeId);
                return null;
            }
            return new UserDefinedConfiguration(id, name, baseEntityType, width, height, description);
        }
        catch (Exception e) {
            log.error("Failed to parse configuration object: {}", (Object)e.getMessage(), (Object)e);
            return null;
        }
    }

    private static EntityType<?> parseEntityType(String entityTypeId) {
        try {
            ResourceLocation resourceLocation = new ResourceLocation(entityTypeId);
            return (EntityType)BuiltInRegistries.f_256780_.m_7745_(resourceLocation);
        }
        catch (Exception e) {
            log.error("Invalid entity type format: {}", (Object)entityTypeId, (Object)e);
            return null;
        }
    }

    private static void saveConfigurations() {
        try {
            UserDefinedConfigurationManager.ensureConfigDirectoryExists();
            JsonObject rootObject = new JsonObject();
            JsonArray configurationsArray = new JsonArray();
            for (UserDefinedConfiguration config : configurations.values()) {
                JsonObject configObject = new JsonObject();
                configObject.addProperty("id", config.id());
                configObject.addProperty("name", config.name());
                configObject.addProperty("base_entity_type", config.getBaseEntityTypeId());
                configObject.addProperty(JSON_FIELD_WIDTH, (Number)Float.valueOf(config.width()));
                configObject.addProperty(JSON_FIELD_HEIGHT, (Number)Float.valueOf(config.height()));
                configObject.addProperty(JSON_FIELD_DESCRIPTION, config.description());
                configurationsArray.add((JsonElement)configObject);
            }
            rootObject.add("user_defined_npcs", (JsonElement)configurationsArray);
            try (FileWriter writer = new FileWriter(CONFIG_FILE);){
                GSON.toJson((JsonElement)rootObject, (Appendable)writer);
            }
            log.debug("Saved {} user-defined NPC configurations", (Object)configurations.size());
        }
        catch (IOException e) {
            log.error("Failed to save user-defined configurations: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private static void createExampleConfiguration() {
        try {
            UserDefinedConfigurationManager.ensureConfigDirectoryExists();
            UserDefinedConfiguration exampleVillagerNPC = new UserDefinedConfiguration("example_villager", "Villager NPC", EntityType.f_20492_, "An example NPC based on villager");
            configurations.put(exampleVillagerNPC.id(), exampleVillagerNPC);
            UserDefinedConfiguration exampleZombieNPC = new UserDefinedConfiguration("example_zombie", "Zombie NPC", EntityType.f_20501_, "An example NPC based on zombie");
            configurations.put(exampleZombieNPC.id(), exampleZombieNPC);
            UserDefinedConfigurationManager.saveConfigurations();
        }
        catch (Exception e) {
            log.error("Failed to create example configuration: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private static void ensureConfigDirectoryExists() {
        if (!CONFIG_DIRECTORY_FILE.exists() && !CONFIG_DIRECTORY_FILE.mkdirs()) {
            throw new ConfigurationDirectoryException("Failed to create configuration directory: config/easy_npc");
        }
    }

    private static class ConfigurationDirectoryException
    extends RuntimeException {
        public ConfigurationDirectoryException(String message) {
            super(message);
        }
    }
}

