/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.data.rotation;

import de.markusbordihn.easynpc.data.model.ModelPartType;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.FriendlyByteBuf;

public record CustomRotation(float x, float y, float z, boolean locked) {
    public CustomRotation(float x, float y, float z) {
        this(x, y, z, false);
    }

    public CustomRotation(ModelPartType modelPartType, CompoundTag compoundTag) {
        this(compoundTag.m_128437_(modelPartType.getTagName(), 5));
    }

    public CustomRotation(ListTag listTag) {
        this(listTag.m_128775_(0), listTag.m_128775_(1), listTag.m_128775_(2), listTag.m_128775_(3) == 1.0f);
    }

    public CustomRotation(List<Float> list) {
        this(list.get(0).floatValue(), list.get(1).floatValue(), list.get(2).floatValue(), list.get(3).floatValue() == 1.0f);
    }

    public static CustomRotation decode(FriendlyByteBuf buffer) {
        return new CustomRotation(buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readBoolean());
    }

    public CustomRotation withLocked(boolean locked) {
        return new CustomRotation(this.x, this.y, this.z, locked);
    }

    public ListTag save() {
        ListTag listTag = new ListTag();
        listTag.add((Object)FloatTag.m_128566_((float)this.x));
        listTag.add((Object)FloatTag.m_128566_((float)this.y));
        listTag.add((Object)FloatTag.m_128566_((float)this.z));
        listTag.add((Object)FloatTag.m_128566_((float)(this.locked ? 1.0f : 0.0f)));
        return listTag;
    }

    public boolean hasChanged() {
        return this.hasChanged(0.0f, 0.0f, 0.0f);
    }

    public boolean hasChangedYaw() {
        return this.x == 0.0f && this.y != 0.0f && this.z == 0.0f && this.locked;
    }

    public boolean hasChanged(float x, float y, float z) {
        return this.hasChanged(x, y, z, false);
    }

    public boolean hasChanged(float x, float y, float z, boolean locked) {
        return this.x != x || this.y != y || this.z != z || this.locked != locked;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeFloat(this.x);
        buffer.writeFloat(this.y);
        buffer.writeFloat(this.z);
        buffer.writeBoolean(this.locked);
    }
}

