/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.data;

import de.markusbordihn.easynpc.data.model.ModelArmPose;
import de.markusbordihn.easynpc.data.model.ModelPose;
import de.markusbordihn.easynpc.data.model.ModelType;
import de.markusbordihn.easynpc.data.synched.SynchedDataIndex;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.AttackDataCapable;
import de.markusbordihn.easynpc.entity.easynpc.data.ModelPositionDataCapable;
import de.markusbordihn.easynpc.entity.easynpc.data.ModelRotationDataCapable;
import de.markusbordihn.easynpc.entity.easynpc.data.ModelScaleDataCapable;
import de.markusbordihn.easynpc.entity.easynpc.data.ModelVisibilityDataCapable;
import de.markusbordihn.easynpc.entity.easynpc.handlers.AttackHandler;
import de.markusbordihn.easynpc.network.syncher.EntityDataSerializersManager;
import java.util.EnumMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.item.ItemStack;

public interface ModelDataCapable<T extends PathfinderMob>
extends EasyNPC<T>,
ModelPositionDataCapable<T>,
ModelRotationDataCapable<T>,
ModelScaleDataCapable<T>,
ModelVisibilityDataCapable<T> {
    public static final String EASY_NPC_DATA_MODEL_DATA_TAG = "ModelData";
    public static final String EASY_NPC_DATA_MODEL_DEFAULT_POSE_TAG = "DefaultPose";
    public static final String EASY_NPC_DATA_MODEL_POSE_TAG = "Pose";

    public static void registerSyncedModelData(EnumMap<SynchedDataIndex, EntityDataAccessor<?>> map, Class<? extends Entity> entityClass) {
        log.info("Registering Synched Model Data for {}.", (Object)entityClass.getSimpleName());
        map.put(SynchedDataIndex.MODEL_POSE, SynchedEntityData.m_135353_(entityClass, EntityDataSerializersManager.MODEL_POSE));
        ModelPositionDataCapable.registerSyncedModelPositionData(map, entityClass);
        ModelRotationDataCapable.registerSynchedModelRotationData(map, entityClass);
        ModelScaleDataCapable.registerSynchedModelScaleData(map, entityClass);
        ModelVisibilityDataCapable.registerSynchedModelVisibilityData(map, entityClass);
    }

    default public Pose getDefaultPose() {
        return this.getEntity().m_20089_();
    }

    default public void setDefaultPose(Pose pose) {
        this.getEntity().m_20124_(pose);
    }

    default public ModelPose getModelPose() {
        return (ModelPose)((Object)this.getSynchedEntityData(SynchedDataIndex.MODEL_POSE));
    }

    default public void setModelPose(ModelPose modelPose) {
        this.setSynchedEntityData(SynchedDataIndex.MODEL_POSE, modelPose);
    }

    default public ModelType getModelType() {
        return ModelType.HUMANOID;
    }

    default public ModelArmPose getModelArmPose() {
        return this.getModelArmPose(this.getLivingEntity());
    }

    default public ModelArmPose getModelArmPose(LivingEntity livingEntity) {
        Mob mob;
        boolean isAggressive = livingEntity instanceof Mob && (mob = (Mob)livingEntity).m_5912_();
        ItemStack itemStack = livingEntity.m_21205_();
        if (isAggressive && AttackHandler.isBowWeapon(itemStack)) {
            return ModelArmPose.BOW_AND_ARROW;
        }
        AttackDataCapable attackData = this.getEasyNPCAttackData();
        if (AttackHandler.isCrossbowWeapon(itemStack)) {
            if (attackData.m_33309_()) {
                return ModelArmPose.CROSSBOW_CHARGE;
            }
            if (isAggressive) {
                return ModelArmPose.CROSSBOW_HOLD;
            }
        }
        if (isAggressive && AttackHandler.isGunWeapon(itemStack)) {
            return ModelArmPose.GUN_HOLD;
        }
        if (isAggressive && AttackHandler.isMeeleeWeapon(itemStack)) {
            return ModelArmPose.ATTACKING_WITH_MELEE_WEAPON;
        }
        return isAggressive ? ModelArmPose.ATTACKING : ModelArmPose.NEUTRAL;
    }

    default public boolean canUseArmor() {
        return false;
    }

    default public boolean canUseMainHand() {
        return true;
    }

    default public boolean canUseOffHand() {
        return true;
    }

    default public boolean hasChangedModel() {
        return this.hasChangedModelPosition() || this.hasChangedModelRotation() || this.hasChangedModelScale() || this.hasChangedModelVisibility();
    }

    default public void defineSynchedModelData() {
        this.defineSynchedEntityData(SynchedDataIndex.MODEL_POSE, ModelPose.DEFAULT);
        this.defineSynchedModelPositionData();
        this.defineSynchedModelRotationData();
        this.defineSynchedModelScaleData();
        this.defineSynchedModelVisibilityData();
    }

    default public void addAdditionalModelData(CompoundTag compoundTag) {
        CompoundTag modelDataTag = new CompoundTag();
        if (this.getModelPose() != ModelPose.DEFAULT && this.hasChangedModel()) {
            modelDataTag.m_128359_(EASY_NPC_DATA_MODEL_POSE_TAG, this.getModelPose().name());
            modelDataTag.m_128359_(EASY_NPC_DATA_MODEL_DEFAULT_POSE_TAG, Pose.STANDING.name());
        } else {
            modelDataTag.m_128359_(EASY_NPC_DATA_MODEL_POSE_TAG, ModelPose.DEFAULT.name());
            modelDataTag.m_128359_(EASY_NPC_DATA_MODEL_DEFAULT_POSE_TAG, this.getDefaultPose() != null ? this.getDefaultPose().name() : Pose.STANDING.name());
        }
        this.addAdditionalModelPositionData(modelDataTag);
        this.addAdditionalModelRotationData(modelDataTag);
        this.addAdditionalModelScaleData(modelDataTag);
        this.addAdditionalModelVisibilityData(modelDataTag);
        compoundTag.m_128365_(EASY_NPC_DATA_MODEL_DATA_TAG, (Tag)modelDataTag);
    }

    default public void readAdditionalModelData(CompoundTag compoundTag) {
        String defaultPose;
        String modelPose;
        if (!compoundTag.m_128441_(EASY_NPC_DATA_MODEL_DATA_TAG)) {
            return;
        }
        CompoundTag modelDataTag = compoundTag.m_128469_(EASY_NPC_DATA_MODEL_DATA_TAG);
        if (modelDataTag.m_128441_(EASY_NPC_DATA_MODEL_POSE_TAG) && !(modelPose = modelDataTag.m_128461_(EASY_NPC_DATA_MODEL_POSE_TAG)).isEmpty()) {
            this.setModelPose(ModelPose.get(modelPose));
        }
        if (this.getModelPose() == ModelPose.DEFAULT && modelDataTag.m_128441_(EASY_NPC_DATA_MODEL_DEFAULT_POSE_TAG) && !(defaultPose = modelDataTag.m_128461_(EASY_NPC_DATA_MODEL_DEFAULT_POSE_TAG)).isEmpty()) {
            this.setDefaultPose(Pose.valueOf((String)defaultPose));
        }
        this.readAdditionalModelPositionData(modelDataTag);
        this.readAdditionalModelRotationData(modelDataTag);
        this.readAdditionalModelScaleData(modelDataTag);
        this.readAdditionalModelVisibilityData(modelDataTag);
    }
}

