/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.data;

import de.markusbordihn.easynpc.data.model.ModelPartType;
import de.markusbordihn.easynpc.data.scale.CustomScale;
import de.markusbordihn.easynpc.data.synched.SynchedDataIndex;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.network.syncher.EntityDataSerializersManager;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;

public interface ModelScaleDataCapable<T extends PathfinderMob>
extends EasyNPC<T> {
    public static final CustomScale DEFAULT_MODEL_PART_SCALE = new CustomScale(1.0f, 1.0f, 1.0f);
    public static final CustomScale DEFAULT_MODEL_SCALE = new CustomScale(1.0f, 1.0f, 1.0f);
    public static final String EASY_NPC_DATA_MODEL_SCALE_TAG = "Scale";

    public static void registerSynchedModelScaleData(EnumMap<SynchedDataIndex, EntityDataAccessor<?>> map, Class<? extends Entity> entityClass) {
        log.info("Registering Synched Model Scale Data for {}.", (Object)entityClass.getSimpleName());
        map.put(SynchedDataIndex.MODEL_SCALE, SynchedEntityData.m_135353_(entityClass, EntityDataSerializersManager.MODEL_PART_SCALE));
    }

    default public EnumMap<ModelPartType, CustomScale> getModelPartScale() {
        EnumMap<ModelPartType, CustomScale> modelPartMap = (EnumMap<ModelPartType, CustomScale>)this.getSynchedEntityData(SynchedDataIndex.MODEL_SCALE);
        if (modelPartMap == null) {
            modelPartMap = new EnumMap<ModelPartType, CustomScale>(ModelPartType.class);
            this.setModelPartScale(modelPartMap);
        }
        return modelPartMap;
    }

    default public void setModelPartScale(EnumMap<ModelPartType, CustomScale> modelPartMap) {
        if (modelPartMap != null) {
            this.setSynchedEntityData(SynchedDataIndex.MODEL_SCALE, modelPartMap, true);
        }
    }

    default public void setModelPartScale(ModelPartType modelPartType, CustomScale Scale) {
        EnumMap<ModelPartType, CustomScale> modelPartMap = this.getModelPartScale();
        if (modelPartType != null) {
            modelPartMap.put(modelPartType, Scale);
            this.setModelPartScale(new EnumMap<ModelPartType, CustomScale>(modelPartMap));
        }
    }

    default public CustomScale getModelPartScale(ModelPartType modelPartType) {
        EnumMap<ModelPartType, CustomScale> modelPartMap = this.getModelPartScale();
        return modelPartMap.getOrDefault((Object)modelPartType, DEFAULT_MODEL_PART_SCALE);
    }

    default public boolean hasChangedModelScale() {
        EnumMap<ModelPartType, CustomScale> modelPartMap = this.getModelPartScale();
        for (Map.Entry<ModelPartType, CustomScale> entry : modelPartMap.entrySet()) {
            if (!entry.getValue().hasChanged()) continue;
            return true;
        }
        return false;
    }

    default public CustomScale getDefaultModelScale() {
        return DEFAULT_MODEL_SCALE;
    }

    default public void defineSynchedModelScaleData() {
        this.defineSynchedEntityData(SynchedDataIndex.MODEL_SCALE, new EnumMap(ModelPartType.class));
    }

    default public void addAdditionalModelScaleData(CompoundTag compoundTag) {
        CompoundTag positionsTag = new CompoundTag();
        EnumMap<ModelPartType, CustomScale> modelPartMap = this.getModelPartScale();
        for (Map.Entry<ModelPartType, CustomScale> entry : modelPartMap.entrySet()) {
            positionsTag.m_128365_(entry.getKey().getTagName(), (Tag)entry.getValue().save());
        }
        compoundTag.m_128365_(EASY_NPC_DATA_MODEL_SCALE_TAG, (Tag)positionsTag);
    }

    default public void readAdditionalModelScaleData(CompoundTag compoundTag) {
        if (!compoundTag.m_128441_(EASY_NPC_DATA_MODEL_SCALE_TAG)) {
            return;
        }
        CompoundTag positionTag = compoundTag.m_128469_(EASY_NPC_DATA_MODEL_SCALE_TAG);
        EnumMap<ModelPartType, CustomScale> modelPartMap = new EnumMap<ModelPartType, CustomScale>(ModelPartType.class);
        for (String key : positionTag.m_128431_()) {
            ModelPartType modelPartType = ModelPartType.get(key);
            if (modelPartType == null) continue;
            modelPartMap.put(modelPartType, new CustomScale(modelPartType, positionTag));
        }
        this.setModelPartScale(modelPartMap);
    }
}

