/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.npc.standard;

import com.google.common.collect.ImmutableList;
import de.markusbordihn.easynpc.data.sound.SoundDataSet;
import de.markusbordihn.easynpc.data.sound.SoundType;
import de.markusbordihn.easynpc.entity.easynpc.npc.raw.PiglinRaw;
import de.markusbordihn.easynpc.entity.easynpc.npc.standard.StandardEasyNPC;
import java.util.Collection;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class PiglinNPC
extends PiglinRaw
implements StandardEasyNPC<PiglinRaw> {
    public static final String ID = "piglin";
    public static final String ID_BRUTE = "piglin_brute";
    public static final String ID_ZOMBIFIED = "piglin_zombified";
    protected static final ImmutableList<MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of((Object)MemoryModuleType.f_26334_, (Object)MemoryModuleType.f_26372_, (Object)MemoryModuleType.f_26341_, (Object)MemoryModuleType.f_26342_);

    public PiglinNPC(EntityType<? extends Piglin> entityType, Level level) {
        this(entityType, level, PiglinRaw.VariantType.PIGLIN);
    }

    public PiglinNPC(EntityType<? extends Piglin> entityType, Level level, Enum<?> variantType) {
        super(entityType, level, variantType);
    }

    public static AttributeSupplier.Builder m_34770_() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22278_, 0.0).m_22268_(Attributes.f_22279_, 0.5).m_22268_(Attributes.f_22281_, 1.0).m_22268_(Attributes.f_22282_, 0.0).m_22268_(Attributes.f_22283_, 0.0).m_22268_(Attributes.f_22284_, 0.0).m_22268_(Attributes.f_22285_, 0.0);
    }

    @Override
    public SoundDataSet getDefaultSoundDataSet(SoundDataSet soundDataSet, String variantName) {
        PiglinRaw.VariantType soundVariant = PiglinRaw.VariantType.valueOf(variantName);
        switch (soundVariant) {
            case PIGLIN_BRUTE: {
                soundDataSet.addDefaultSound(SoundType.AMBIENT, SoundEvents.f_12301_);
                soundDataSet.addDefaultSound(SoundType.HURT, SoundEvents.f_12304_);
                soundDataSet.addDefaultSound(SoundType.DEATH, SoundEvents.f_12303_);
                soundDataSet.addDefaultSound(SoundType.STEP, SoundEvents.f_12305_);
                break;
            }
            case ZOMBIFIED_PIGLIN: {
                soundDataSet.addDefaultSound(SoundType.AMBIENT, SoundEvents.f_12610_);
                soundDataSet.addDefaultSound(SoundType.HURT, SoundEvents.f_12613_);
                soundDataSet.addDefaultSound(SoundType.DEATH, SoundEvents.f_12612_);
                soundDataSet.addDefaultSound(SoundType.STEP, SoundEvents.f_12299_);
                break;
            }
            default: {
                soundDataSet.addDefaultSound(SoundType.AMBIENT, SoundEvents.f_12239_);
                soundDataSet.addDefaultSound(SoundType.HURT, SoundEvents.f_12244_);
                soundDataSet.addDefaultSound(SoundType.DEATH, SoundEvents.f_12242_);
                soundDataSet.addDefaultSound(SoundType.STEP, SoundEvents.f_12299_);
            }
        }
        soundDataSet.addDefaultSound(SoundType.TRADE, SoundEvents.f_12508_);
        soundDataSet.addDefaultSound(SoundType.TRADE_YES, SoundEvents.f_12509_);
        soundDataSet.addDefaultSound(SoundType.TRADE_NO, SoundEvents.f_12507_);
        return soundDataSet;
    }

    protected void m_8099_() {
    }

    public boolean m_34666_() {
        return false;
    }

    protected Brain.Provider<Piglin> m_5490_() {
        return Brain.m_21923_(MEMORY_TYPES, (Collection)f_34680_);
    }

    @Override
    public void m_7023_(Vec3 vec3) {
        this.handleNavigationTravelEvent(vec3);
        if (this.hasTravelTargetObjectives()) {
            super.m_7023_(vec3);
        } else {
            this.m_267651_(this instanceof FlyingAnimal);
        }
    }
}

