/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.screen;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import de.markusbordihn.easynpc.data.model.ModelPartType;
import de.markusbordihn.easynpc.data.model.ModelPose;
import de.markusbordihn.easynpc.data.profession.Profession;
import de.markusbordihn.easynpc.data.render.RenderDataSet;
import de.markusbordihn.easynpc.data.render.RenderType;
import de.markusbordihn.easynpc.data.rotation.CustomRotation;
import de.markusbordihn.easynpc.data.scale.CustomScale;
import de.markusbordihn.easynpc.data.skin.SkinType;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.DialogDataCapable;
import de.markusbordihn.easynpc.entity.easynpc.data.GuiDataCapable;
import de.markusbordihn.easynpc.entity.easynpc.data.ModelDataCapable;
import de.markusbordihn.easynpc.entity.easynpc.data.ProfessionDataCapable;
import de.markusbordihn.easynpc.entity.easynpc.data.RenderDataCapable;
import de.markusbordihn.easynpc.entity.easynpc.data.SkinDataCapable;
import de.markusbordihn.easynpc.entity.easynpc.data.VariantDataCapable;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Team;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class ScreenHelper {
    protected ScreenHelper() {
    }

    public static void renderEntity(int x, int y, int scale, float yRot, float xRot, LivingEntity livingEntity) {
        float f1;
        float f;
        Minecraft minecraft = Minecraft.m_91087_();
        boolean isDead = livingEntity.m_21224_();
        PoseStack poseStack = RenderSystem.getModelViewStack();
        poseStack.m_85836_();
        if (isDead) {
            f = (float)Math.atan(0.625);
            f1 = (float)Math.atan(-0.625);
            poseStack.m_85837_((double)x - 25.0, (double)y - 30.0, 1050.0);
        } else {
            f = (float)Math.atan(yRot / 40.0f);
            f1 = (float)Math.atan(xRot / 40.0f);
            poseStack.m_85837_((double)x, (double)y, 1050.0);
        }
        poseStack.m_85841_(1.0f, 1.0f, -1.0f);
        RenderSystem.applyModelViewMatrix();
        PoseStack poseStack1 = new PoseStack();
        poseStack1.m_85837_(0.0, 0.0, 1000.0);
        poseStack1.m_85841_((float)scale, (float)scale, (float)scale);
        Quaternionf quaternionf = new Quaternionf().rotateZ((float)Math.PI);
        Quaternionf quaternionf1 = new Quaternionf().rotateX(f1 * 20.0f * ((float)Math.PI / 180));
        quaternionf.mul((Quaternionfc)quaternionf1);
        poseStack1.m_252781_(quaternionf);
        Component entityCustomName = livingEntity.m_7770_();
        boolean entityShouldShowName = livingEntity.m_6052_();
        float entityXRot = livingEntity.m_146909_();
        float entityYBodyRot = livingEntity.f_20883_;
        float entityYHeadRot = livingEntity.f_20885_;
        float entityYHeadRotO = livingEntity.f_20886_;
        float entityYRot = livingEntity.m_146908_();
        boolean entityInvisible = livingEntity.m_20145_();
        Team entityTeam = livingEntity.m_5647_();
        livingEntity.m_6842_(false);
        livingEntity.f_20883_ = 180.0f + f * 20.0f;
        livingEntity.m_146922_(180.0f + f * 40.0f);
        livingEntity.m_146926_(-f1 * 20.0f);
        livingEntity.f_20885_ = livingEntity.m_146908_();
        if (entityTeam instanceof PlayerTeam) {
            PlayerTeam playerTeam = (PlayerTeam)entityTeam;
            livingEntity.m_9236_().m_6188_().m_6519_(livingEntity.m_6302_(), playerTeam);
        }
        boolean minecraftHideGui = false;
        if (minecraft != null) {
            minecraftHideGui = minecraft.f_91066_.f_92062_;
            minecraft.f_91066_.f_92062_ = true;
        } else {
            livingEntity.m_6593_(null);
            livingEntity.m_20340_(false);
        }
        Lighting.m_166384_();
        EntityRenderDispatcher entityRenderDispatcher = Minecraft.m_91087_().m_91290_();
        quaternionf1.conjugate();
        entityRenderDispatcher.m_252923_(quaternionf1);
        entityRenderDispatcher.m_114468_(false);
        MultiBufferSource.BufferSource multiBuffer = Minecraft.m_91087_().m_91269_().m_110104_();
        entityRenderDispatcher.m_114384_((Entity)livingEntity, 0.0, 0.0, 0.0, 0.0f, 1.0f, poseStack1, (MultiBufferSource)multiBuffer, 0xF000F0);
        multiBuffer.m_109911_();
        entityRenderDispatcher.m_114468_(true);
        livingEntity.m_6842_(entityInvisible);
        livingEntity.f_20883_ = entityYBodyRot;
        livingEntity.m_146922_(entityYRot);
        livingEntity.m_146926_(entityXRot);
        livingEntity.f_20885_ = entityYHeadRot;
        livingEntity.f_20886_ = entityYHeadRotO;
        if (entityTeam instanceof PlayerTeam) {
            PlayerTeam playerTeam = (PlayerTeam)entityTeam;
            livingEntity.m_9236_().m_6188_().m_6546_(livingEntity.m_6302_(), playerTeam);
        }
        if (minecraft != null) {
            minecraft.f_91066_.f_92062_ = minecraftHideGui;
        } else {
            livingEntity.m_6593_(entityCustomName);
            livingEntity.m_20340_(entityShouldShowName);
        }
        poseStack.m_85849_();
        RenderSystem.applyModelViewMatrix();
        Lighting.m_84931_();
    }

    public static void renderScaledEntityAvatar(int x, int y, int scale, float yRot, float xRot, EasyNPC<?> easyNPC) {
        ModelDataCapable modelData = easyNPC.getEasyNPCModelData();
        if (modelData != null) {
            ScreenHelper.renderScaledEntityAvatar(x, y, scale, yRot, xRot, easyNPC, modelData);
        } else {
            ScreenHelper.renderEntity(x, y, scale, yRot, xRot, easyNPC.getLivingEntity());
        }
    }

    public static void renderScaledEntityAvatar(int x, int y, float yRot, float xRot, EasyNPC<?> easyNPC) {
        GuiDataCapable guiData = easyNPC.getEasyNPCGuiData();
        ScreenHelper.renderScaledEntityAvatar(x, y, guiData.getEntityGuiScaling(), yRot, xRot, easyNPC);
    }

    public static void renderScaledEntityAvatar(int x, int y, int scale, float yRot, float xRot, EasyNPC<?> easyNPC, ModelDataCapable<?> modelData) {
        CustomScale entityModelRootScale;
        CustomRotation entityModelRootRotation = modelData != null ? modelData.getModelPartRotation(ModelPartType.ROOT) : null;
        CustomScale customScale = entityModelRootScale = modelData != null ? modelData.getModelPartScale(ModelPartType.ROOT) : null;
        if (modelData != null) {
            modelData.setModelPartRotation(ModelPartType.ROOT, new CustomRotation(0.0f, 0.0f, 0.0f));
            modelData.setModelPartScale(ModelPartType.ROOT, new CustomScale(1.0f, 1.0f, 1.0f));
        }
        ScreenHelper.renderEntity(x, y, scale, yRot, xRot, easyNPC.getLivingEntity());
        if (modelData != null) {
            if (entityModelRootRotation != null) {
                modelData.setModelPartRotation(ModelPartType.ROOT, entityModelRootRotation);
            }
            if (entityModelRootScale != null) {
                modelData.setModelPartScale(ModelPartType.ROOT, entityModelRootScale);
            }
        }
    }

    public static void renderCustomPoseEntityAvatar(int x, int y, int scale, float yRot, float xRot, EasyNPC<?> easyNPC) {
        ModelDataCapable modelData = easyNPC.getEasyNPCModelData();
        Entity entity = easyNPC.getEntity();
        ModelPose entityModelPose = modelData.getModelPose();
        Pose entityPose = easyNPC.getEntity().m_20089_();
        modelData.setModelPose(ModelPose.CUSTOM);
        entity.m_20124_(Pose.STANDING);
        ScreenHelper.renderScaledEntityAvatar(x, y, scale, yRot, xRot, easyNPC, modelData);
        modelData.setModelPose(entityModelPose);
        entity.m_20124_(entityPose);
    }

    public static void renderEntityAvatarForScaling(int x, int y, int scale, float yRot, float xRot, EasyNPC<?> easyNPC) {
        ModelDataCapable modelData = easyNPC.getEasyNPCModelData();
        Entity entity = easyNPC.getEntity();
        CustomRotation entityModelRootRotation = modelData.getModelPartRotation(ModelPartType.ROOT);
        boolean entityInvisible = entity.m_20145_();
        modelData.setModelPartRotation(ModelPartType.ROOT, new CustomRotation(0.0f, 0.0f, 0.0f));
        entity.m_6842_(false);
        ScreenHelper.renderEntity(x, y, scale, yRot, xRot, easyNPC.getLivingEntity());
        modelData.setModelPartRotation(ModelPartType.ROOT, entityModelRootRotation);
        entity.m_6842_(entityInvisible);
    }

    public static void renderEntityDialog(int x, int y, float yRot, float xRot, EasyNPC<?> easyNPC) {
        ModelDataCapable modelData = easyNPC.getEasyNPCModelData();
        CustomRotation entityModelRootRotation = modelData.getModelPartRotation(ModelPartType.ROOT);
        modelData.setModelPartRotation(ModelPartType.ROOT, new CustomRotation(0.0f, 0.0f, 0.0f));
        DialogDataCapable dialogData = easyNPC.getEasyNPCDialogData();
        ScreenHelper.renderEntity(x, y, dialogData.getEntityDialogScaling(), yRot, xRot, easyNPC.getLivingEntity());
        modelData.setModelPartRotation(ModelPartType.ROOT, entityModelRootRotation);
    }

    public static void renderEntityCustomModel(int x, int y, int scale, float yRot, float xRot, EasyNPC<?> easyNPC, EntityType<? extends Entity> entityType) {
        GuiDataCapable guiData = easyNPC.getEasyNPCGuiData();
        RenderDataCapable renderData = easyNPC.getEasyNPCRenderData();
        RenderDataSet renderDataSet = renderData.getRenderDataSet();
        RenderType renderType = renderDataSet.getRenderType();
        EntityType<? extends Entity> renderEntityType = renderDataSet.getRenderEntityType();
        renderDataSet.setRenderType(RenderType.CUSTOM);
        renderDataSet.setRenderEntityType(entityType);
        ScreenHelper.renderScaledEntityAvatar(x + guiData.getEntityGuiLeft(), y + guiData.getEntityGuiTop(), scale, yRot, xRot, easyNPC, easyNPC.getEasyNPCModelData());
        renderDataSet.setRenderType(renderType);
        renderDataSet.setRenderEntityType(renderEntityType);
    }

    public static void renderEntityCustomSkin(int x, int y, float yRot, float xRot, EasyNPC<?> easyNPC, UUID userUUID, SkinType skinType) {
        SkinDataCapable skinData = easyNPC.getEasyNPCSkinData();
        GuiDataCapable guiData = easyNPC.getEasyNPCGuiData();
        SkinType entitySkinType = skinData.getSkinType();
        UUID entitySkinUUID = skinData.getSkinUUID();
        skinData.setSkinDataEntry(skinData.getSkinDataEntry().withType(skinType).withUUID(userUUID));
        ScreenHelper.renderScaledEntityAvatar(x + guiData.getEntityGuiLeft(), y + guiData.getEntityGuiTop(), skinData.getEntitySkinScaling(), yRot, xRot, easyNPC, easyNPC.getEasyNPCModelData());
        skinData.setSkinDataEntry(skinData.getSkinDataEntry().withType(entitySkinType).withUUID(entitySkinUUID));
    }

    public static void renderEntityDefaultSkin(int x, int y, float yRot, float xRot, EasyNPC<?> easyNPC, Enum<?> variant, Profession profession) {
        SkinDataCapable skinData = easyNPC.getEasyNPCSkinData();
        VariantDataCapable variantData = easyNPC.getEasyNPCVariantData();
        ProfessionDataCapable professionData = easyNPC.getEasyNPCProfessionData();
        GuiDataCapable guiData = easyNPC.getEasyNPCGuiData();
        SkinType entitySkinType = skinData.getSkinType();
        Enum<?> entityVariant = variantData.getVariantType();
        Profession entityProfession = professionData.getProfession();
        skinData.setSkinDataEntry(skinData.getSkinDataEntry().withType(SkinType.DEFAULT).withName("default"));
        variantData.setVariantType(variant);
        professionData.setProfession(profession);
        ScreenHelper.renderEntity(x + guiData.getEntityGuiLeft(), y + guiData.getEntityGuiTop(), skinData.getEntitySkinScaling(), yRot, xRot, easyNPC.getLivingEntity());
        skinData.setSkinDataEntry(skinData.getSkinDataEntry().withType(entitySkinType));
        variantData.setVariantType(entityVariant);
        professionData.setProfession(entityProfession);
    }
}

