/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.server.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import de.markusbordihn.easynpc.commands.Command;
import de.markusbordihn.easynpc.commands.arguments.EasyNPCArgument;
import de.markusbordihn.easynpc.commands.suggestion.ColorSuggestions;
import de.markusbordihn.easynpc.commands.suggestion.NameVisibilitySuggestions;
import de.markusbordihn.easynpc.data.display.NameVisibilityType;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.handler.NameHandler;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;

public class NameCommand
extends Command {
    private NameCommand() {
    }

    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"name").requires(cs -> cs.m_6761_(2))).then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"npc_target", (ArgumentType)EasyNPCArgument.npc()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.string()).executes(context -> NameCommand.setName((CommandSourceStack)context.getSource(), EasyNPCArgument.getEntityWithAccess((CommandContext<CommandSourceStack>)context, "npc_target"), StringArgumentType.getString((CommandContext)context, (String)"name")))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"color", (ArgumentType)StringArgumentType.word()).suggests((SuggestionProvider)ColorSuggestions.INSTANCE).executes(context -> NameCommand.setNameWithColor((CommandSourceStack)context.getSource(), EasyNPCArgument.getEntityWithAccess((CommandContext<CommandSourceStack>)context, "npc_target"), StringArgumentType.getString((CommandContext)context, (String)"name"), StringArgumentType.getString((CommandContext)context, (String)"color")))).then(Commands.m_82129_((String)"visibility", (ArgumentType)StringArgumentType.word()).suggests((SuggestionProvider)NameVisibilitySuggestions.INSTANCE).executes(context -> NameCommand.setNameWithColorAndVisibility((CommandSourceStack)context.getSource(), EasyNPCArgument.getEntityWithAccess((CommandContext<CommandSourceStack>)context, "npc_target"), StringArgumentType.getString((CommandContext)context, (String)"name"), StringArgumentType.getString((CommandContext)context, (String)"color"), StringArgumentType.getString((CommandContext)context, (String)"visibility"))))))))).then(Commands.m_82127_((String)"color").then(Commands.m_82129_((String)"npc_target", (ArgumentType)EasyNPCArgument.npc()).then(Commands.m_82129_((String)"color", (ArgumentType)StringArgumentType.word()).suggests((SuggestionProvider)ColorSuggestions.INSTANCE).executes(context -> NameCommand.setNameColor((CommandSourceStack)context.getSource(), EasyNPCArgument.getEntityWithAccess((CommandContext<CommandSourceStack>)context, "npc_target"), StringArgumentType.getString((CommandContext)context, (String)"color"))))))).then(Commands.m_82127_((String)"visibility").then(Commands.m_82129_((String)"npc_target", (ArgumentType)EasyNPCArgument.npc()).then(Commands.m_82129_((String)"visibility", (ArgumentType)StringArgumentType.word()).suggests((SuggestionProvider)NameVisibilitySuggestions.INSTANCE).executes(context -> NameCommand.setNameVisibility((CommandSourceStack)context.getSource(), EasyNPCArgument.getEntityWithAccess((CommandContext<CommandSourceStack>)context, "npc_target"), StringArgumentType.getString((CommandContext)context, (String)"visibility"))))))).then(Commands.m_82127_((String)"clear").then(Commands.m_82129_((String)"npc_target", (ArgumentType)EasyNPCArgument.npc()).executes(context -> NameCommand.clearName((CommandSourceStack)context.getSource(), EasyNPCArgument.getEntity((CommandContext<CommandSourceStack>)context, "npc_target")))));
    }

    private static int setName(CommandSourceStack context, EasyNPC<?> easyNPC, String name) {
        if (easyNPC == null || name == null) {
            return 0;
        }
        if (NameHandler.setCustomName(easyNPC, name, -1, NameVisibilityType.ALWAYS)) {
            return NameCommand.sendSuccessMessage(context, "Set name of " + String.valueOf(easyNPC) + " to " + name);
        }
        return 0;
    }

    private static int setNameWithColor(CommandSourceStack context, EasyNPC<?> easyNPC, String name, String colorName) {
        int color;
        if (easyNPC == null || name == null || colorName == null) {
            return 0;
        }
        ChatFormatting chatFormatting = NameCommand.parseChatFormatting(colorName);
        if (chatFormatting == null) {
            return NameCommand.sendFailureMessage(context, "Invalid color: " + colorName);
        }
        int n = color = chatFormatting.m_126665_() != null ? chatFormatting.m_126665_() : -1;
        if (NameHandler.setCustomName(easyNPC, name, color, NameVisibilityType.ALWAYS)) {
            return NameCommand.sendSuccessMessage(context, "Set name of " + String.valueOf(easyNPC) + " to " + name + " with color " + chatFormatting.name().toLowerCase());
        }
        return 0;
    }

    private static int setNameWithColorAndVisibility(CommandSourceStack context, EasyNPC<?> easyNPC, String name, String colorName, String visibilityName) {
        int color;
        if (easyNPC == null || name == null || colorName == null || visibilityName == null) {
            return 0;
        }
        ChatFormatting chatFormatting = NameCommand.parseChatFormatting(colorName);
        if (chatFormatting == null) {
            return NameCommand.sendFailureMessage(context, "Invalid color: " + colorName);
        }
        NameVisibilityType visibility = NameCommand.parseNameVisibilityType(visibilityName);
        if (visibility == null) {
            return NameCommand.sendFailureMessage(context, "Invalid visibility: " + visibilityName);
        }
        int n = color = chatFormatting.m_126665_() != null ? chatFormatting.m_126665_() : -1;
        if (NameHandler.setCustomName(easyNPC, name, color, visibility)) {
            return NameCommand.sendSuccessMessage(context, "Set name of " + String.valueOf(easyNPC) + " to " + name + " with color " + chatFormatting.name().toLowerCase() + " and visibility " + visibility.name().toLowerCase());
        }
        return 0;
    }

    private static int setNameColor(CommandSourceStack context, EasyNPC<?> easyNPC, String colorName) {
        int color;
        if (easyNPC == null || colorName == null) {
            return 0;
        }
        Component currentName = easyNPC.getEntity().m_7770_();
        if (currentName == null) {
            return NameCommand.sendFailureMessage(context, "NPC has no custom name set. Use 'name set' first.");
        }
        ChatFormatting chatFormatting = NameCommand.parseChatFormatting(colorName);
        if (chatFormatting == null) {
            return NameCommand.sendFailureMessage(context, "Invalid color: " + colorName);
        }
        String nameText = currentName.getString();
        boolean isVisible = easyNPC.getEntity().m_20151_();
        NameVisibilityType visibility = isVisible ? NameVisibilityType.ALWAYS : NameVisibilityType.NEVER;
        int n = color = chatFormatting.m_126665_() != null ? chatFormatting.m_126665_() : -1;
        if (NameHandler.setCustomName(easyNPC, nameText, color, visibility)) {
            return NameCommand.sendSuccessMessage(context, "Set color of " + String.valueOf(easyNPC) + " name to " + chatFormatting.name().toLowerCase());
        }
        return 0;
    }

    private static int setNameVisibility(CommandSourceStack context, EasyNPC<?> easyNPC, String visibilityName) {
        if (easyNPC == null || visibilityName == null) {
            return 0;
        }
        Component currentName = easyNPC.getEntity().m_7770_();
        if (currentName == null) {
            return NameCommand.sendFailureMessage(context, "NPC has no custom name set. Use 'name set' first.");
        }
        NameVisibilityType visibility = NameCommand.parseNameVisibilityType(visibilityName);
        if (visibility == null) {
            return NameCommand.sendFailureMessage(context, "Invalid visibility: " + visibilityName);
        }
        String nameText = currentName.getString();
        if (NameHandler.setCustomName(easyNPC, nameText, -1, visibility)) {
            return NameCommand.sendSuccessMessage(context, "Set visibility of " + String.valueOf(easyNPC) + " name to " + visibility.name().toLowerCase());
        }
        return 0;
    }

    private static int clearName(CommandSourceStack context, EasyNPC<?> easyNPC) {
        if (easyNPC == null) {
            return 0;
        }
        if (NameHandler.setCustomName(easyNPC, "", -1, NameVisibilityType.NEVER)) {
            return NameCommand.sendSuccessMessage(context, "Cleared name of " + String.valueOf(easyNPC));
        }
        return 0;
    }

    private static ChatFormatting parseChatFormatting(String colorName) {
        try {
            return ChatFormatting.valueOf((String)colorName.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private static NameVisibilityType parseNameVisibilityType(String visibilityName) {
        try {
            return NameVisibilityType.valueOf(visibilityName.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }
}

