/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.texture;

import de.markusbordihn.easynpc.Constants;
import de.markusbordihn.easynpc.client.texture.TextureManager;
import de.markusbordihn.easynpc.client.texture.TextureModelKey;
import de.markusbordihn.easynpc.data.skin.SkinModel;
import de.markusbordihn.easynpc.data.skin.SkinType;
import de.markusbordihn.easynpc.entity.easynpc.data.SkinDataCapable;
import de.markusbordihn.easynpc.io.PlayerSkinDataFiles;
import de.markusbordihn.easynpc.network.components.TextComponent;
import de.markusbordihn.easynpc.utils.PlayersUtils;
import java.io.File;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_746;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PlayerTextureManager {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");
    private static final HashMap<TextureModelKey, class_2960> textureCache = new HashMap();
    private static final HashMap<TextureModelKey, SkinType> textureSkinTypeCache = new HashMap();
    private static final HashSet<UUID> textureReloadProtection = new HashSet();
    private static final String LOG_PREFIX = "[Player Texture Manager] ";

    private PlayerTextureManager() {
    }

    public static Set<UUID> getTextureCacheKeys(SkinModel skinModel) {
        HashSet<UUID> hashSet = new HashSet<UUID>();
        for (TextureModelKey textureModelKey : textureCache.keySet()) {
            if (!skinModel.equals((Object)textureModelKey.getSkinModel()) || !PlayerTextureManager.hasTextureSkinData(textureModelKey)) continue;
            hashSet.add(textureModelKey.getUUID());
        }
        return hashSet;
    }

    public static SkinType getTextureSkinType(TextureModelKey textureModelKey) {
        return textureSkinTypeCache.get(textureModelKey);
    }

    public static boolean hasTextureSkinData(TextureModelKey textureModelKey) {
        return textureSkinTypeCache.containsKey(textureModelKey);
    }

    public static class_2960 getOrCreateTextureWithDefault(SkinDataCapable<?> skinData, class_2960 defaultResourceLocation) {
        UUID skinUUID = skinData.getSkinUUID();
        if (skinUUID.equals(Constants.BLANK_UUID)) {
            return defaultResourceLocation;
        }
        TextureModelKey textureModelKey = new TextureModelKey(skinUUID, skinData.getSkinModel());
        class_2960 resourceLocation = textureCache.get(textureModelKey);
        if (resourceLocation != null) {
            if (!PlayerTextureManager.hasTextureSkinData(textureModelKey)) {
                textureSkinTypeCache.put(textureModelKey, skinData.getSkinType());
            }
            return resourceLocation;
        }
        UUID playerUUID = skinData.getSkinUUID();
        class_2960 createdResourceLocation = PlayerTextureManager.createTexture(textureModelKey, skinData, playerUUID);
        return createdResourceLocation != null ? createdResourceLocation : defaultResourceLocation;
    }

    private static class_2960 createTexture(TextureModelKey textureModelKey, SkinDataCapable<?> skinData, UUID playerUUID) {
        if (!textureReloadProtection.add(playerUUID)) {
            return null;
        }
        SkinModel skinModel = skinData.getSkinModel();
        Path textureDataFolder = PlayerSkinDataFiles.getPlayerSkinDataFolder(skinModel);
        if (textureDataFolder == null) {
            return null;
        }
        class_2960 localTextureCache = TextureManager.getCachedTexture(textureModelKey, textureDataFolder);
        if (localTextureCache != null) {
            textureCache.put(textureModelKey, localTextureCache);
            textureSkinTypeCache.put(textureModelKey, skinData.getSkinType());
            return localTextureCache;
        }
        String playerSkinUrl = PlayersUtils.getUserTexture(playerUUID);
        if (playerSkinUrl == null || playerSkinUrl.isEmpty()) {
            log.error("{} Unable to get player skin URL for UUID: {}", (Object)LOG_PREFIX, (Object)playerUUID);
            return null;
        }
        log.debug("{} Got player skin URL for {}: {}", (Object)LOG_PREFIX, (Object)playerUUID, (Object)playerSkinUrl);
        log.debug("{} Starting remote texture download for {}: {}", (Object)LOG_PREFIX, (Object)playerUUID, (Object)playerSkinUrl);
        class_2960 resourceLocation = TextureManager.addRemoteTexture(textureModelKey, playerSkinUrl, textureDataFolder);
        if (resourceLocation != null) {
            log.info("{} Successfully loaded player texture for {}: {}", (Object)LOG_PREFIX, (Object)playerUUID, (Object)resourceLocation);
            textureCache.put(textureModelKey, resourceLocation);
            textureSkinTypeCache.put(textureModelKey, skinData.getSkinType());
            return resourceLocation;
        }
        log.error("{} Unable to load player {} texture {} from {}!", (Object)LOG_PREFIX, (Object)playerUUID, (Object)textureModelKey, (Object)textureDataFolder);
        class_746 player = class_310.method_1551().field_1724;
        if (player != null) {
            player.method_7353((class_2561)TextComponent.getText("[Player Texture Manager] Unable to load player " + String.valueOf(playerUUID) + " texture " + String.valueOf(textureModelKey) + ": " + playerSkinUrl).method_27692(class_124.field_1061), false);
        }
        return null;
    }

    public static void registerTexture(SkinModel skinModel, File textureFile) {
        PlayerTextureManager.registerTexture(TextureManager.getTextureModelKey(skinModel, textureFile), textureFile);
    }

    public static void registerTexture(TextureModelKey textureModelKey, File textureFile) {
        class_2960 resourceLocation = TextureManager.addCustomTexture(textureModelKey, textureFile);
        if (resourceLocation != null) {
            textureCache.put(textureModelKey, resourceLocation);
        }
    }
}

