/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.data.action;

import de.markusbordihn.easynpc.data.action.ActionDataEntry;
import de.markusbordihn.easynpc.data.action.ActionDataSet;
import de.markusbordihn.easynpc.data.action.ActionEventType;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

public class ActionEventSet {
    public static final String DATA_ACTION_EVENT_SET_TAG = "ActionEventSet";
    public static final class_9139<class_9129, ActionEventSet> STREAM_CODEC = new class_9139<class_9129, ActionEventSet>(){

        public ActionEventSet decode(class_9129 registryFriendlyByteBuf) {
            return new ActionEventSet(registryFriendlyByteBuf.method_10798());
        }

        public void encode(class_9129 registryFriendlyByteBuf, ActionEventSet actionEventSet) {
            registryFriendlyByteBuf.method_10794((class_2520)actionEventSet.createTag());
        }
    };
    private final EnumMap<ActionEventType, ActionDataSet> actionsMap = new EnumMap(ActionEventType.class);
    private boolean hasDistanceActionEvent = false;

    public ActionEventSet() {
    }

    public ActionEventSet(class_2487 compoundTag) {
        this.load(compoundTag);
    }

    public void setActionEvent(ActionEventType actionEventType, ActionDataSet actionDataSet) {
        if (actionEventType != null && actionEventType != ActionEventType.NONE && actionDataSet != null) {
            this.actionsMap.put(actionEventType, actionDataSet);
            this.updateHasDistanceAction();
        }
    }

    public ActionDataEntry getActionEvent(ActionEventType actionEventType) {
        ActionDataSet actionDataSet;
        if (actionEventType != null && actionEventType != ActionEventType.NONE && (actionDataSet = this.actionsMap.get((Object)actionEventType)) != null && !actionDataSet.isEmpty()) {
            return actionDataSet.getRandomEntry();
        }
        return null;
    }

    public ActionDataSet getActionEvents(ActionEventType actionEventType) {
        if (actionEventType != ActionEventType.NONE && this.actionsMap.containsKey((Object)actionEventType)) {
            return this.actionsMap.get((Object)actionEventType);
        }
        return new ActionDataSet();
    }

    public boolean hasActionEvent(ActionEventType actionEventType) {
        if (actionEventType != null && actionEventType != ActionEventType.NONE) {
            ActionDataSet actions = this.actionsMap.get((Object)actionEventType);
            return actions != null && !actions.isEmpty();
        }
        return false;
    }

    public void updateHasDistanceAction() {
        this.hasDistanceActionEvent = this.actionsMap.containsKey((Object)ActionEventType.ON_DISTANCE_NEAR) && !this.actionsMap.get((Object)ActionEventType.ON_DISTANCE_NEAR).isEmpty() || this.actionsMap.containsKey((Object)ActionEventType.ON_DISTANCE_CLOSE) && !this.actionsMap.get((Object)ActionEventType.ON_DISTANCE_CLOSE).isEmpty() || this.actionsMap.containsKey((Object)ActionEventType.ON_DISTANCE_VERY_CLOSE) && !this.actionsMap.get((Object)ActionEventType.ON_DISTANCE_VERY_CLOSE).isEmpty() || this.actionsMap.containsKey((Object)ActionEventType.ON_DISTANCE_TOUCH) && !this.actionsMap.get((Object)ActionEventType.ON_DISTANCE_TOUCH).isEmpty();
    }

    public void clear() {
        this.actionsMap.clear();
        this.hasDistanceActionEvent = false;
    }

    public void load(class_2487 compoundTag) {
        if (!compoundTag.method_10545(DATA_ACTION_EVENT_SET_TAG)) {
            return;
        }
        this.clear();
        class_2487 actionDataSetTag = compoundTag.method_10562(DATA_ACTION_EVENT_SET_TAG);
        for (ActionEventType actionEventType : ActionEventType.values()) {
            ActionDataSet actionDataEntryList = new ActionDataSet(actionDataSetTag, actionEventType.name());
            if (actionDataEntryList.isEmpty()) continue;
            this.actionsMap.put(actionEventType, actionDataEntryList);
        }
        this.updateHasDistanceAction();
    }

    public class_2487 save(class_2487 compoundTag) {
        class_2487 actionsTag = new class_2487();
        for (Map.Entry<ActionEventType, ActionDataSet> entry : this.actionsMap.entrySet()) {
            ActionEventType actionEventType = entry.getKey();
            ActionDataSet actionDataSet = entry.getValue();
            actionDataSet.save(actionsTag, actionEventType.name());
        }
        compoundTag.method_10566(DATA_ACTION_EVENT_SET_TAG, (class_2520)actionsTag);
        return compoundTag;
    }

    public class_2487 createTag() {
        return this.save(new class_2487());
    }

    public String toString() {
        return "ActionEventSet [ hasDistanceActionEvent=" + this.hasDistanceActionEvent + ", " + String.valueOf(this.actionsMap) + "]";
    }
}

