/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.data.attribute;

import de.markusbordihn.easynpc.data.attribute.CombatAttributes;
import de.markusbordihn.easynpc.data.attribute.EntityAttributeType;
import de.markusbordihn.easynpc.data.attribute.EntityAttributesInterface;
import de.markusbordihn.easynpc.data.attribute.EnvironmentalAttributes;
import de.markusbordihn.easynpc.data.attribute.InteractionAttributes;
import de.markusbordihn.easynpc.data.attribute.MovementAttributes;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

public class EntityAttributes {
    public static final String ENTITY_ATTRIBUTE_TAG = "EntityAttribute";
    public static final class_9139<class_9129, EntityAttributes> STREAM_CODEC = new class_9139<class_9129, EntityAttributes>(){

        public EntityAttributes decode(class_9129 registryFriendlyByteBuf) {
            return new EntityAttributes(registryFriendlyByteBuf.method_10798());
        }

        public void encode(class_9129 registryFriendlyByteBuf, EntityAttributes value) {
            registryFriendlyByteBuf.method_10794((class_2520)value.createTag());
        }
    };
    private final Map<EntityAttributeType, EntityAttributesInterface> attributeMap = new EnumMap<EntityAttributeType, EntityAttributesInterface>(EntityAttributeType.class);

    public EntityAttributes() {
        this.setAttribute(EntityAttributeType.COMBAT, new CombatAttributes());
        this.setAttribute(EntityAttributeType.ENVIRONMENTAL, new EnvironmentalAttributes());
        this.setAttribute(EntityAttributeType.INTERACTION, new InteractionAttributes());
        this.setAttribute(EntityAttributeType.MOVEMENT, new MovementAttributes());
    }

    public EntityAttributes(class_2487 compoundTag) {
        this();
        this.load(compoundTag);
    }

    public void load(class_2487 compoundTag) {
        if (!compoundTag.method_10545(ENTITY_ATTRIBUTE_TAG) || compoundTag.method_10562(ENTITY_ATTRIBUTE_TAG).method_33133()) {
            return;
        }
        class_2487 entityAttributeTag = compoundTag.method_10562(ENTITY_ATTRIBUTE_TAG);
        this.setAttribute(EntityAttributeType.COMBAT, CombatAttributes.decode(entityAttributeTag));
        this.setAttribute(EntityAttributeType.ENVIRONMENTAL, EnvironmentalAttributes.decode(entityAttributeTag));
        this.setAttribute(EntityAttributeType.INTERACTION, InteractionAttributes.decode(entityAttributeTag));
        this.setAttribute(EntityAttributeType.MOVEMENT, MovementAttributes.decode(entityAttributeTag));
    }

    public boolean hasAttribute(EntityAttributeType entityAttributeType) {
        return this.attributeMap.containsKey((Object)entityAttributeType);
    }

    public EntityAttributesInterface getAttribute(EntityAttributeType entityAttributeType) {
        return this.attributeMap.get((Object)entityAttributeType);
    }

    public void setAttribute(EntityAttributeType entityAttributeType, EntityAttributesInterface attribute) {
        this.attributeMap.put(entityAttributeType, attribute);
    }

    public boolean hasCombatAttributes() {
        return this.hasAttribute(EntityAttributeType.COMBAT);
    }

    public CombatAttributes getCombatAttributes() {
        return (CombatAttributes)this.getAttribute(EntityAttributeType.COMBAT);
    }

    public void setCombatAttributes(CombatAttributes combatAttributes) {
        this.setAttribute(EntityAttributeType.COMBAT, combatAttributes);
    }

    public boolean hasEnvironmentalAttributes() {
        return this.hasAttribute(EntityAttributeType.ENVIRONMENTAL);
    }

    public EnvironmentalAttributes getEnvironmentalAttributes() {
        return (EnvironmentalAttributes)this.getAttribute(EntityAttributeType.ENVIRONMENTAL);
    }

    public void setEnvironmentalAttributes(EnvironmentalAttributes environmentalAttributes) {
        this.setAttribute(EntityAttributeType.ENVIRONMENTAL, environmentalAttributes);
    }

    public boolean hasInteractionAttributes() {
        return this.hasAttribute(EntityAttributeType.INTERACTION);
    }

    public InteractionAttributes getInteractionAttributes() {
        return (InteractionAttributes)this.getAttribute(EntityAttributeType.INTERACTION);
    }

    public void setInteractionAttributes(InteractionAttributes interactionAttributes) {
        this.setAttribute(EntityAttributeType.INTERACTION, interactionAttributes);
    }

    public boolean hasMovementAttributes() {
        return this.hasAttribute(EntityAttributeType.MOVEMENT);
    }

    public MovementAttributes getMovementAttributes() {
        return (MovementAttributes)this.getAttribute(EntityAttributeType.MOVEMENT);
    }

    public void setMovementAttributes(MovementAttributes movementAttributes) {
        this.setAttribute(EntityAttributeType.MOVEMENT, movementAttributes);
    }

    public class_2487 save(class_2487 compoundTag) {
        class_2487 entityAttributeTag = new class_2487();
        this.attributeMap.forEach((type, attribute) -> {
            if (attribute instanceof CombatAttributes) {
                CombatAttributes combatAttributes = (CombatAttributes)attribute;
                combatAttributes.encode(entityAttributeTag);
            } else if (attribute instanceof EnvironmentalAttributes) {
                EnvironmentalAttributes environmentalAttributes = (EnvironmentalAttributes)attribute;
                environmentalAttributes.encode(entityAttributeTag);
            } else if (attribute instanceof InteractionAttributes) {
                InteractionAttributes interactionAttributes = (InteractionAttributes)attribute;
                interactionAttributes.encode(entityAttributeTag);
            } else if (attribute instanceof MovementAttributes) {
                MovementAttributes movementAttributes = (MovementAttributes)attribute;
                movementAttributes.encode(entityAttributeTag);
            }
        });
        compoundTag.method_10566(ENTITY_ATTRIBUTE_TAG, (class_2520)entityAttributeTag);
        return compoundTag;
    }

    public class_2487 createTag() {
        return this.save(new class_2487());
    }
}

