/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.server.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import de.markusbordihn.easynpc.access.AccessManager;
import de.markusbordihn.easynpc.commands.Command;
import de.markusbordihn.easynpc.commands.arguments.EasyNPCArgument;
import de.markusbordihn.easynpc.data.model.ModelPartType;
import de.markusbordihn.easynpc.data.model.ModelPose;
import de.markusbordihn.easynpc.data.rotation.CustomRotation;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.ModelDataCapable;
import java.util.Collection;
import java.util.Locale;
import java.util.UUID;
import net.minecraft.class_2168;
import net.minecraft.class_2170;

public class RotateCommand
extends Command {
    private RotateCommand() {
    }

    public static ArgumentBuilder<class_2168, ?> register() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"rotate").requires(cs -> cs.method_9259(0))).then(class_2170.method_9244((String)"npc_targets", (ArgumentType)EasyNPCArgument.npc()).then(class_2170.method_9244((String)"yaw", (ArgumentType)FloatArgumentType.floatArg((float)0.0f, (float)360.0f)).executes(context -> {
            float yaw = FloatArgumentType.getFloat((CommandContext)context, (String)"yaw");
            Collection<? extends EasyNPC<?>> easyNPCs = EasyNPCArgument.getEntitiesWithAccess((CommandContext<class_2168>)context, "npc_targets");
            return RotateCommand.rotateEntity((class_2168)context.getSource(), easyNPCs, yaw);
        })))).then(class_2170.method_9244((String)"npc_targets", (ArgumentType)EasyNPCArgument.npc()).then(class_2170.method_9244((String)"modelPart", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> {
            EasyNPC<?> easyNPC = EasyNPCArgument.getEntityWithAccess((CommandContext<class_2168>)context, "npc_targets");
            if (easyNPC != null) {
                ModelDataCapable modelData = easyNPC.getEasyNPCModelData();
                for (ModelPartType partType : modelData.getModelType().getModelParts()) {
                    builder.suggest(partType.name().toLowerCase(Locale.ROOT));
                }
            }
            return builder.buildFuture();
        }).then(class_2170.method_9244((String)"x", (ArgumentType)FloatArgumentType.floatArg((float)-360.0f, (float)360.0f)).then(class_2170.method_9244((String)"y", (ArgumentType)FloatArgumentType.floatArg((float)-360.0f, (float)360.0f)).then(class_2170.method_9244((String)"z", (ArgumentType)FloatArgumentType.floatArg((float)-360.0f, (float)360.0f)).executes(context -> {
            String partString = StringArgumentType.getString((CommandContext)context, (String)"modelPart");
            float x = FloatArgumentType.getFloat((CommandContext)context, (String)"x");
            float y = FloatArgumentType.getFloat((CommandContext)context, (String)"y");
            float z = FloatArgumentType.getFloat((CommandContext)context, (String)"z");
            ModelPartType modelPartType = ModelPartType.get(partString);
            if (modelPartType == ModelPartType.UNKNOWN) {
                return RotateCommand.sendFailureMessage((class_2168)context.getSource(), "Invalid model part " + partString);
            }
            Collection<? extends EasyNPC<?>> easyNPCs = EasyNPCArgument.getEntitiesWithAccess((CommandContext<class_2168>)context, "npc_targets");
            return RotateCommand.rotateModelPart((class_2168)context.getSource(), easyNPCs, modelPartType, new CustomRotation(x, y, z));
        }))))));
    }

    private static int rotateEntity(class_2168 context, Collection<? extends EasyNPC<?>> easyNPCs, float yaw) {
        int rotated = 0;
        for (EasyNPC<?> easyNPC : easyNPCs) {
            UUID uuid = easyNPC.getEntityUUID();
            if (AccessManager.hasAccess(context, uuid)) {
                ModelDataCapable modelData = easyNPC.getEasyNPCModelData();
                if (modelData != null) {
                    modelData.setModelRotation(yaw);
                }
                ++rotated;
                continue;
            }
            RotateCommand.sendFailureMessage(context, "You are not allowed to rotate the Easy NPC " + String.valueOf(uuid) + " !");
        }
        return RotateCommand.sendRotationFeedback(context, easyNPCs, rotated, "body", yaw, 0.0f, 0.0f);
    }

    private static int rotateModelPart(class_2168 context, Collection<? extends EasyNPC<?>> easyNPCs, ModelPartType modelPartType, CustomRotation rotation) {
        int rotated = 0;
        for (EasyNPC<?> easyNPC : easyNPCs) {
            UUID uuid = easyNPC.getEntityUUID();
            if (AccessManager.hasAccess(context, uuid)) {
                ModelDataCapable modelData = easyNPC.getEasyNPCModelData();
                if (!modelData.getModelType().getModelParts().contains((Object)modelPartType)) {
                    RotateCommand.sendFailureMessage(context, "Model part " + String.valueOf((Object)modelPartType) + " not supported by NPC " + String.valueOf(uuid) + ".");
                    continue;
                }
                modelData.setModelPartRotation(modelPartType, rotation);
                modelData.setModelPose(modelData.hasChangedModel() ? ModelPose.CUSTOM : ModelPose.DEFAULT);
                ++rotated;
                continue;
            }
            RotateCommand.sendFailureMessage(context, "You are not allowed to rotate the Easy NPC " + String.valueOf(uuid) + " !");
        }
        return RotateCommand.sendRotationFeedback(context, easyNPCs, rotated, modelPartType.name().toLowerCase(Locale.ROOT), rotation.x(), rotation.y(), rotation.z());
    }

    private static int sendRotationFeedback(class_2168 context, Collection<? extends EasyNPC<?>> easyNPCs, int rotated, String partName, float x, float y, float z) {
        if (rotated == 1) {
            EasyNPC<?> easyNPC = easyNPCs.iterator().next();
            return RotateCommand.sendSuccessMessage(context, "Rotated model part '" + partName + "' of NPC " + easyNPC.getEntity().method_5476().getString() + " to x:" + x + ", y:" + y + ", z:" + z);
        }
        if (rotated > 1) {
            return RotateCommand.sendSuccessMessage(context, "Rotated model part '" + partName + "' of " + rotated + " of " + easyNPCs.size() + " selected Easy NPCs to x:" + x + ", y:" + y + ", z:" + z);
        }
        return RotateCommand.sendFailureMessage(context, "Nothing was rotated.");
    }
}

