/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.renderer.entity.raw;

import de.markusbordihn.easynpc.client.renderer.entity.EasyNPCEntityRenderer;
import de.markusbordihn.easynpc.data.skin.variant.HorseSkinVariant;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HorseModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.entity.AbstractHorseRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.HorseArmorLayer;
import net.minecraft.client.renderer.entity.layers.HorseMarkingLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.EquineRenderState;
import net.minecraft.client.renderer.entity.state.HorseRenderState;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.animal.horse.Horse;

public class HorseRawRenderer
extends AbstractHorseRenderer<Horse, HorseRenderState, HorseModel>
implements EasyNPCEntityRenderer {
    protected static final ResourceLocation DEFAULT_TEXTURE = HorseSkinVariant.WHITE.getTextureLocation();

    public HorseRawRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new HorseModel(context.bakeLayer(ModelLayers.HORSE)), (EntityModel)new HorseModel(context.bakeLayer(ModelLayers.HORSE_BABY)), 1.1f);
        this.addLayer((RenderLayer)new HorseMarkingLayer((RenderLayerParent)this));
        this.addLayer((RenderLayer)new HorseArmorLayer((RenderLayerParent)this, context.getModelSet(), context.getEquipmentRenderer()));
    }

    public ResourceLocation getTextureLocation(HorseRenderState renderState) {
        return this.getTextureFromRenderState((LivingEntityRenderState)renderState);
    }

    public HorseRenderState createRenderState() {
        return new HorseRenderState();
    }

    public void extractRenderState(Horse horse, HorseRenderState state, float partialTicks) {
        super.extractRenderState((AbstractHorse)horse, (EquineRenderState)state, partialTicks);
        state.variant = horse.getVariant();
        state.markings = horse.getMarkings();
        state.bodyArmorItem = horse.getBodyArmorItem().copy();
    }

    @Override
    public ResourceLocation getDefaultTexture() {
        return DEFAULT_TEXTURE;
    }
}

