/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.screen.components;

import com.mojang.blaze3d.systems.RenderSystem;
import de.markusbordihn.easynpc.network.components.TextComponent;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class CustomButton
extends Button {
    protected static final WidgetSprites SPRITES = new WidgetSprites(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"widget/button"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"widget/button_disabled"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"widget/button_highlighted"));

    public CustomButton(int left, int top, int width, int height) {
        this(left, top, width, height, null, unused -> {});
    }

    public CustomButton(int left, int top, int width, int height, Button.OnPress onPress) {
        this(left, top, width, height, null, onPress);
    }

    public CustomButton(int left, int top, int width, int height, Component component, Button.OnPress onPress) {
        super(left, top, width, height, (Component)(component != null ? component : TextComponent.getBlankText()), onPress, Button.DEFAULT_NARRATION);
    }

    public boolean isHovered() {
        return this.isHovered;
    }

    public void renderButtonText(GuiGraphics guiGraphics, Font font, Component component, int x, int y) {
        if (component != null && !component.getString().isEmpty()) {
            int fgColor = this.active ? 0xFFFFFF : 0xA0A0A0;
            guiGraphics.drawCenteredString(font, component, this.getX() + this.width / 2, this.getY() + (this.height - 8) / 2, fgColor | Mth.ceil((float)(this.alpha * 255.0f)) << 24);
        }
    }

    public void onPress() {
        if (this.onPress != null) {
            super.onPress();
        }
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.renderButton(guiGraphics, mouseX, mouseY, partialTicks);
    }

    public void renderButton(GuiGraphics guiGraphics, int left, int top, float partialTicks) {
        Minecraft minecraft = Minecraft.getInstance();
        Font font = minecraft.font;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        guiGraphics.blitSprite(RenderType::guiTextured, SPRITES.get(this.active, this.isHoveredOrFocused()), this.getX(), this.getY(), this.getWidth(), this.getHeight());
        this.renderButtonText(guiGraphics, font, this.getMessage(), this.getX(), this.getY());
    }
}

