/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.data.condition;

import de.markusbordihn.easynpc.data.condition.ConditionOperationType;
import de.markusbordihn.easynpc.data.condition.ConditionType;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;

public record ConditionDataEntry(ConditionType conditionType, ConditionOperationType operationType, String name, int value, String text) {
    public static final ConditionDataEntry EMPTY = new ConditionDataEntry(ConditionType.NONE, ConditionOperationType.NONE);
    public static final String DATA_TYPE_TAG = "Type";
    public static final String DATA_OPERATION_TAG = "Operation";
    public static final String DATA_NAME_TAG = "Name";
    public static final String DATA_VALUE_TAG = "Value";
    public static final String DATA_TEXT_TAG = "Text";

    public ConditionDataEntry(CompoundTag compoundTag) {
        this(ConditionType.get(compoundTag.getString(DATA_TYPE_TAG)), ConditionOperationType.get(compoundTag.getString(DATA_OPERATION_TAG)), compoundTag.contains(DATA_NAME_TAG) ? compoundTag.getString(DATA_NAME_TAG) : "", compoundTag.contains(DATA_VALUE_TAG) ? compoundTag.getInt(DATA_VALUE_TAG) : 0, compoundTag.contains(DATA_TEXT_TAG) ? compoundTag.getString(DATA_TEXT_TAG) : "");
    }

    public ConditionDataEntry(ConditionType conditionType) {
        this(conditionType, ConditionOperationType.NONE);
    }

    public ConditionDataEntry(ConditionType conditionType, ConditionOperationType operationType) {
        this(conditionType, operationType, "", 0, "");
    }

    public ConditionDataEntry(ConditionType conditionType, ConditionOperationType operationType, String name, int value) {
        this(conditionType, operationType, name, value, "");
    }

    public UUID getId() {
        String idString = DATA_TYPE_TAG + this.hashCode();
        return UUID.nameUUIDFromBytes(idString.getBytes());
    }

    public boolean hasName() {
        return this.name != null && !this.name.isEmpty();
    }

    public boolean hasStringValue() {
        return this.text != null && !this.text.isEmpty();
    }

    public boolean isValid() {
        if (this.conditionType == ConditionType.NONE) {
            return false;
        }
        return switch (this.conditionType) {
            case ConditionType.SCOREBOARD -> {
                if (this.hasName() && this.operationType != null && this.operationType != ConditionOperationType.NONE) {
                    yield true;
                }
                yield false;
            }
            case ConditionType.EXECUTION_LIMIT -> {
                if (this.value > 0 && this.hasStringValue()) {
                    yield true;
                }
                yield false;
            }
            default -> true;
        };
    }

    public ConditionDataEntry withConditionType(ConditionType conditionType) {
        return new ConditionDataEntry(conditionType, this.operationType, this.name, this.value, this.text);
    }

    public ConditionDataEntry withOperationType(ConditionOperationType operationType) {
        return new ConditionDataEntry(this.conditionType, operationType, this.name, this.value, this.text);
    }

    public ConditionDataEntry withName(String name) {
        return new ConditionDataEntry(this.conditionType, this.operationType, name, this.value, this.text);
    }

    public ConditionDataEntry withValue(int value) {
        return new ConditionDataEntry(this.conditionType, this.operationType, this.name, value, this.text);
    }

    public ConditionDataEntry withStringValue(String stringValue) {
        return new ConditionDataEntry(this.conditionType, this.operationType, this.name, this.value, stringValue);
    }

    public ConditionDataEntry create(CompoundTag compoundTag) {
        return new ConditionDataEntry(compoundTag);
    }

    public CompoundTag write(CompoundTag compoundTag) {
        compoundTag.putString(DATA_TYPE_TAG, this.conditionType.name());
        if (this.operationType != null && this.operationType != ConditionOperationType.NONE) {
            compoundTag.putString(DATA_OPERATION_TAG, this.operationType.name());
        }
        if (this.hasName()) {
            compoundTag.putString(DATA_NAME_TAG, this.name.trim());
        }
        if (this.value != 0) {
            compoundTag.putInt(DATA_VALUE_TAG, this.value);
        }
        if (this.hasStringValue()) {
            compoundTag.putString(DATA_TEXT_TAG, this.text);
        }
        return compoundTag;
    }

    public CompoundTag createTag() {
        return this.write(new CompoundTag());
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ConditionDataEntry other = (ConditionDataEntry)object;
        return this.conditionType == other.conditionType && this.operationType == other.operationType && this.name.equals(other.name) && this.value == other.value && this.text.equals(other.text);
    }

    @Override
    public int hashCode() {
        int result = this.conditionType.hashCode();
        result = 31 * result + (this.operationType != null ? this.operationType.hashCode() : 0);
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + this.value;
        result = 31 * result + (this.text != null ? this.text.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "ConditionDataEntry[id=" + String.valueOf(this.getId()) + ", type=" + String.valueOf((Object)this.conditionType) + ", operation=" + String.valueOf((Object)this.operationType) + ", name='" + this.name + "', value=" + this.value + ", text='" + this.text + "']";
    }
}

