/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.data.dialog;

import de.markusbordihn.easynpc.network.components.TextComponent;
import de.markusbordihn.easynpc.utils.TextUtils;
import de.markusbordihn.easynpc.utils.UUIDUtils;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;

public record DialogTextData(UUID id, String text, boolean isTranslationKey) {
    public static final String DATA_TEXT_TAG = "Text";

    public DialogTextData(CompoundTag compoundTag) {
        this(UUIDUtils.textToUUID(compoundTag.getString(DATA_TEXT_TAG)), compoundTag.getString(DATA_TEXT_TAG), TextUtils.isTranslationKey(compoundTag.getString(DATA_TEXT_TAG)));
    }

    public DialogTextData(String text) {
        this(UUIDUtils.textToUUID(text), text, TextUtils.isTranslationKey(text));
    }

    public String getText(int maxLength) {
        return this.text.length() > maxLength ? this.text.substring(0, maxLength - 1) + "\u2026" : this.text;
    }

    public Component getDialogText() {
        return TextComponent.getTextComponentRaw(this.text, this.isTranslationKey);
    }

    public CompoundTag write(CompoundTag compoundTag) {
        compoundTag.putString(DATA_TEXT_TAG, this.text.trim());
        return compoundTag;
    }

    @Override
    public String toString() {
        return "DialogTextData{id=" + String.valueOf(this.id) + ", text='" + this.text + "', isTranslationKey=" + this.isTranslationKey + "}";
    }
}

