/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.model.armpose;

import de.markusbordihn.easynpc.data.model.ModelArmPose;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.handlers.AttackHandler;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;

public class ModelArmPoseUtils {
    public static ModelArmPose getArmPoseForLeftArm(EasyNPC<?> easyNPC) {
        return ModelArmPoseUtils.getArmPose(easyNPC, false);
    }

    public static ModelArmPose getArmPoseForRightArm(EasyNPC<?> easyNPC) {
        return ModelArmPoseUtils.getArmPose(easyNPC, true);
    }

    private static ModelArmPose getArmPose(EasyNPC<?> easyNPC, boolean isRightArm) {
        boolean isRightHanded;
        if (easyNPC == null) {
            return ModelArmPose.DEFAULT;
        }
        LivingEntity livingEntity = easyNPC.getLivingEntity();
        boolean bl = isRightHanded = livingEntity.m_5737_() == HumanoidArm.RIGHT;
        if (livingEntity.m_6117_()) {
            return ModelArmPoseUtils.getArmPoseWhileUsingItem(livingEntity, isRightArm, isRightHanded);
        }
        return ModelArmPoseUtils.getIdleArmPose(easyNPC, livingEntity, isRightArm, isRightHanded);
    }

    private static ModelArmPose getArmPoseWhileUsingItem(LivingEntity livingEntity, boolean isRightArm, boolean isRightHanded) {
        ModelArmPose itemUseModelArmPose;
        boolean isUsingRightHand;
        ItemStack useItem = livingEntity.m_21211_();
        if (useItem.m_41619_()) {
            return ModelArmPose.DEFAULT;
        }
        boolean isUsingMainHand = livingEntity.m_7655_() == InteractionHand.MAIN_HAND;
        boolean bl = isUsingRightHand = isRightHanded && isUsingMainHand || !isRightHanded && !isUsingMainHand;
        if (isRightArm != isUsingRightHand) {
            return ModelArmPose.DEFAULT;
        }
        switch (useItem.m_41780_()) {
            case BOW: {
                ModelArmPose modelArmPose = ModelArmPose.BOW_AND_ARROW;
                break;
            }
            case CROSSBOW: {
                ModelArmPose modelArmPose = ModelArmPose.CROSSBOW_CHARGE;
                break;
            }
            case SPYGLASS: {
                ModelArmPose modelArmPose = ModelArmPose.SPYGLASS;
                break;
            }
            case SPEAR: {
                ModelArmPose modelArmPose = ModelArmPose.ATTACKING_WITH_MELEE_WEAPON;
                break;
            }
            default: {
                ModelArmPose modelArmPose = itemUseModelArmPose = ModelArmPose.DEFAULT;
            }
        }
        if (itemUseModelArmPose != ModelArmPose.DEFAULT) {
            return itemUseModelArmPose;
        }
        if (AttackHandler.isGunWeapon(useItem)) {
            return ModelArmPose.GUN_HOLD;
        }
        return ModelArmPose.DEFAULT;
    }

    private static ModelArmPose getIdleArmPose(EasyNPC<?> easyNPC, LivingEntity livingEntity, boolean isRightArm, boolean isRightHanded) {
        ItemStack currentArmItem;
        Mob mob;
        if (!(easyNPC.getPathfinderMob().m_5448_() != null || livingEntity instanceof Mob && (mob = (Mob)livingEntity).m_5912_())) {
            return ModelArmPose.DEFAULT;
        }
        ItemStack mainHandItem = livingEntity.m_21205_();
        ItemStack offHandItem = livingEntity.m_21206_();
        ItemStack itemInRightArm = isRightHanded ? mainHandItem : offHandItem;
        ItemStack itemInLeftArm = isRightHanded ? offHandItem : mainHandItem;
        ItemStack itemStack = currentArmItem = isRightArm ? itemInRightArm : itemInLeftArm;
        if (currentArmItem.m_41619_()) {
            return ModelArmPose.DEFAULT;
        }
        if (currentArmItem.m_41720_() instanceof CrossbowItem) {
            return ModelArmPose.CROSSBOW_HOLD;
        }
        if (AttackHandler.isBowWeapon(currentArmItem)) {
            return ModelArmPose.BOW_AND_ARROW;
        }
        if (AttackHandler.isGunWeapon(currentArmItem)) {
            return ModelArmPose.GUN_HOLD;
        }
        if (AttackHandler.isMeleeWeapon(currentArmItem)) {
            return ModelArmPose.ATTACKING_WITH_MELEE_WEAPON;
        }
        return ModelArmPose.DEFAULT;
    }
}

