/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.renderer.entity.standard;

import de.markusbordihn.easynpc.client.renderer.entity.EasyNPCEntityRenderer;
import de.markusbordihn.easynpc.client.texture.CustomTextureManager;
import de.markusbordihn.easynpc.client.texture.RemoteTextureManager;
import de.markusbordihn.easynpc.data.skin.variant.HumanoidSkinVariant;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.SkinDataCapable;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidArmorModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.PathfinderMob;

public class PlayerRenderer<T extends PathfinderMob>
extends LivingEntityRenderer<T, PlayerModel<T>>
implements EasyNPCEntityRenderer {
    protected static final ResourceLocation DEFAULT_TEXTURE = HumanoidSkinVariant.STEVE.getTextureLocation();

    public PlayerRenderer(EntityRendererProvider.Context context) {
        this(context, false);
    }

    public PlayerRenderer(EntityRendererProvider.Context context, boolean slim) {
        super(context, (EntityModel)new PlayerModel(context.m_174023_(slim ? ModelLayers.f_171166_ : ModelLayers.f_171162_), slim), 0.5f);
        this.m_115326_((RenderLayer)new HumanoidArmorLayer((RenderLayerParent)this, (HumanoidModel)new HumanoidArmorModel(context.m_174023_(slim ? ModelLayers.f_171167_ : ModelLayers.f_171164_)), (HumanoidModel)new HumanoidArmorModel(context.m_174023_(slim ? ModelLayers.f_171168_ : ModelLayers.f_171165_)), context.m_266367_()));
        this.m_115326_((RenderLayer)new ItemInHandLayer((RenderLayerParent)this, context.m_234598_()));
    }

    public ResourceLocation getTextureLocation(T entity) {
        if (entity instanceof EasyNPC) {
            EasyNPC easyNPC = (EasyNPC)entity;
            return this.getEntityPlayerTexture(easyNPC);
        }
        return DEFAULT_TEXTURE;
    }

    @Override
    public ResourceLocation getDefaultTexture() {
        return DEFAULT_TEXTURE;
    }

    @Override
    public ResourceLocation getCustomTexture(SkinDataCapable<?> entity) {
        return CustomTextureManager.getOrCreateTextureWithDefault(entity, this.getDefaultTexture());
    }

    @Override
    public ResourceLocation getRemoteTexture(SkinDataCapable<?> entity) {
        return RemoteTextureManager.getOrCreateTextureWithDefault(entity, this.getDefaultTexture());
    }
}

