/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.renderer.screen;

import de.markusbordihn.easynpc.data.model.ModelPartType;
import de.markusbordihn.easynpc.data.model.ModelPose;
import de.markusbordihn.easynpc.data.render.EntityRenderConfig;
import de.markusbordihn.easynpc.data.render.EntityRenderOverrides;
import de.markusbordihn.easynpc.data.rotation.CustomRotation;
import de.markusbordihn.easynpc.data.scale.CustomScale;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.ModelDataCapable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;

public class EntityScreenRenderer {
    protected EntityScreenRenderer() {
    }

    public static void renderEntity(GuiGraphics guiGraphics, EasyNPC<?> easyNPC, EntityRenderConfig config) {
        if (easyNPC == null || easyNPC.getLivingEntity() == null) {
            return;
        }
        LivingEntity livingEntity = easyNPC.getLivingEntity();
        EntityRenderState backupState = new EntityRenderState(livingEntity, easyNPC);
        EntityScreenRenderer.applyRenderModifications(easyNPC, config);
        int renderScale = config.scale();
        if (config.scissorBox() != null) {
            CustomScale originalScale;
            float multiplier = config.scissorBox().scaleMultiplier();
            renderScale = (int)((float)config.scale() * multiplier);
            ModelDataCapable modelData = easyNPC.getEasyNPCModelData();
            if (modelData != null && (originalScale = modelData.getModelPartScale(ModelPartType.ROOT)) != null) {
                float adjustment = 1.0f / multiplier;
                modelData.setModelPartScale(ModelPartType.ROOT, new CustomScale(originalScale.x() * adjustment, originalScale.y() * adjustment, originalScale.z() * adjustment));
            }
        }
        InventoryScreen.m_274545_((GuiGraphics)guiGraphics, (int)config.x(), (int)config.y(), (int)renderScale, (float)config.rotationYaw(), (float)config.rotationPitch(), (LivingEntity)livingEntity);
        EntityScreenRenderer.restoreEntityState(easyNPC, backupState);
    }

    protected static void applyRenderModifications(EasyNPC<?> easyNPC, EntityRenderConfig config) {
        ModelDataCapable modelData;
        Entity entity = easyNPC.getEntity();
        LivingEntity livingEntity = easyNPC.getLivingEntity();
        EntityRenderOverrides overrides = config.overrides();
        if (overrides.invisible() != null) {
            entity.m_6842_(overrides.invisible().booleanValue());
        }
        if (overrides.hideNameTag() != null && overrides.hideNameTag().booleanValue()) {
            Minecraft minecraft = Minecraft.m_91087_();
            if (minecraft != null) {
                minecraft.f_91066_.f_92062_ = true;
            } else {
                livingEntity.m_6593_(null);
                livingEntity.m_20340_(false);
            }
        }
        if ((modelData = easyNPC.getEasyNPCModelData()) != null) {
            if (overrides.rootRotation() != null) {
                modelData.setModelPartRotation(ModelPartType.ROOT, overrides.rootRotation());
            }
            if (overrides.rootScale() != null) {
                modelData.setModelPartScale(ModelPartType.ROOT, overrides.rootScale());
            }
            if (overrides.modelPose() != null) {
                modelData.setModelPose(overrides.modelPose());
            }
        }
        if (overrides.entityPose() != null) {
            entity.m_20124_(overrides.entityPose());
        }
    }

    protected static void restoreEntityState(EasyNPC<?> easyNPC, EntityRenderState backupState) {
        ModelDataCapable modelData;
        Entity entity = easyNPC.getEntity();
        LivingEntity livingEntity = easyNPC.getLivingEntity();
        livingEntity.m_6593_(backupState.customName);
        livingEntity.m_20340_(backupState.shouldShowName);
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft != null) {
            minecraft.f_91066_.f_92062_ = backupState.minecraftHideGui;
        }
        if ((modelData = easyNPC.getEasyNPCModelData()) != null) {
            if (backupState.rootRotation != null) {
                modelData.setModelPartRotation(ModelPartType.ROOT, backupState.rootRotation);
            }
            if (backupState.rootScale != null) {
                modelData.setModelPartScale(ModelPartType.ROOT, backupState.rootScale);
            }
            if (backupState.modelPose != null) {
                modelData.setModelPose(backupState.modelPose);
            }
        }
        if (backupState.entityPose != null) {
            entity.m_20124_(backupState.entityPose);
        }
    }

    protected static class EntityRenderState {
        final Component customName;
        final boolean shouldShowName;
        final boolean minecraftHideGui;
        final CustomRotation rootRotation;
        final CustomScale rootScale;
        final ModelPose modelPose;
        final Pose entityPose;

        EntityRenderState(LivingEntity livingEntity, EasyNPC<?> easyNPC) {
            this.customName = livingEntity.m_7770_();
            this.shouldShowName = livingEntity.m_6052_();
            Minecraft minecraft = Minecraft.m_91087_();
            this.minecraftHideGui = minecraft != null ? minecraft.f_91066_.f_92062_ : false;
            ModelDataCapable modelData = easyNPC.getEasyNPCModelData();
            if (modelData != null) {
                this.rootRotation = modelData.getModelPartRotation(ModelPartType.ROOT);
                this.rootScale = modelData.getModelPartScale(ModelPartType.ROOT);
                this.modelPose = modelData.getModelPose();
            } else {
                this.rootRotation = null;
                this.rootScale = null;
                this.modelPose = null;
            }
            this.entityPose = easyNPC.getEntity().m_20089_();
        }
    }
}

