/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.commands.suggestion;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import de.markusbordihn.easynpc.io.CustomPresetDataFiles;
import de.markusbordihn.easynpc.io.DataPresetDataFiles;
import de.markusbordihn.easynpc.io.DefaultPresetDataFiles;
import de.markusbordihn.easynpc.io.WorldPresetDataFiles;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;

public class PresetSuggestions {
    private static final long REFRESH_COOLDOWN_MS = 5000L;
    private static long lastCustomRefreshTime = 0L;
    private static long lastWorldRefreshTime = 0L;

    private PresetSuggestions() {
    }

    public static CompletableFuture<Suggestions> suggest(CommandContext<CommandSourceStack> context, SuggestionsBuilder build) {
        long currentTime = System.currentTimeMillis();
        if (currentTime - lastWorldRefreshTime >= 5000L) {
            WorldPresetDataFiles.refreshPresetResourceLocations();
            lastWorldRefreshTime = currentTime;
        }
        return SharedSuggestionProvider.m_82957_(WorldPresetDataFiles.getPresetResourceLocations(), (SuggestionsBuilder)build);
    }

    public static CompletableFuture<Suggestions> suggestCustom(CommandContext<CommandSourceStack> context, SuggestionsBuilder build) {
        long currentTime = System.currentTimeMillis();
        if (currentTime - lastCustomRefreshTime >= 5000L) {
            CustomPresetDataFiles.refreshPresetResourceLocations();
            lastCustomRefreshTime = currentTime;
        }
        return SharedSuggestionProvider.m_82957_(CustomPresetDataFiles.getPresetResourceLocations(), (SuggestionsBuilder)build);
    }

    public static CompletableFuture<Suggestions> suggestData(CommandContext<CommandSourceStack> context, SuggestionsBuilder build) {
        return SharedSuggestionProvider.m_82957_(DataPresetDataFiles.getPresetResourceLocations(((CommandSourceStack)context.getSource()).m_81377_()), (SuggestionsBuilder)build);
    }

    public static CompletableFuture<Suggestions> suggestDefault(CommandContext<CommandSourceStack> context, SuggestionsBuilder build) {
        return SharedSuggestionProvider.m_82957_(DefaultPresetDataFiles.getPresetResourceLocations(((CommandSourceStack)context.getSource()).m_81377_()), (SuggestionsBuilder)build);
    }

    public static CompletableFuture<Suggestions> suggestWorld(CommandContext<CommandSourceStack> context, SuggestionsBuilder build) {
        long currentTime = System.currentTimeMillis();
        if (currentTime - lastWorldRefreshTime >= 5000L) {
            WorldPresetDataFiles.refreshPresetResourceLocations();
            lastWorldRefreshTime = currentTime;
        }
        return SharedSuggestionProvider.m_82957_(WorldPresetDataFiles.getPresetResourceLocations(), (SuggestionsBuilder)build);
    }
}

