/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.ai.goal;

import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.handlers.AttackHandler;
import java.util.EnumSet;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.CrossbowAttackMob;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;

public class CrossbowAttackGoal<T extends EasyNPC<?>>
extends Goal {
    public static final UniformInt PATHFINDING_DELAY_RANGE = TimeUtil.m_145020_((int)1, (int)2);
    private final double speedModifier;
    private final float attackRadiusSqr;
    private final PathfinderMob pathfinderMob;
    private final CrossbowAttackMob crossbowAttackMob;
    private int attackDelay;
    private CrossbowState crossbowState;
    private int seeTime;
    private int updatePathDelay;

    public CrossbowAttackGoal(T easyNPC, double speedModifier, float attackRange) {
        this.pathfinderMob = easyNPC.getPathfinderMob();
        this.crossbowAttackMob = easyNPC.getCrossbowAttackMob();
        this.speedModifier = speedModifier;
        this.attackRadiusSqr = attackRange * attackRange;
        this.crossbowState = CrossbowState.UNCHARGED;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        return this.crossbowAttackMob != null && this.isValidTarget() && AttackHandler.isHoldingCrossbowWeapon((LivingEntity)this.pathfinderMob);
    }

    public boolean m_8045_() {
        return this.isValidTarget() && (this.m_8036_() || !this.pathfinderMob.m_21573_().m_26571_()) && AttackHandler.isHoldingCrossbowWeapon((LivingEntity)this.pathfinderMob);
    }

    private boolean isValidTarget() {
        return this.pathfinderMob.m_5448_() != null && this.pathfinderMob.m_5448_().m_6084_();
    }

    public void m_8041_() {
        super.m_8041_();
        this.pathfinderMob.m_21561_(false);
        this.pathfinderMob.m_6710_(null);
        this.seeTime = 0;
        if (this.pathfinderMob.m_6117_()) {
            this.pathfinderMob.m_5810_();
            this.crossbowAttackMob.m_6136_(false);
            ItemStack useItem = this.pathfinderMob.m_21211_();
            this.clearChargedProjectiles(useItem);
        }
    }

    public void m_8056_() {
        super.m_8056_();
        this.pathfinderMob.m_21561_(true);
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8037_() {
        boolean shouldNavigateToTarget;
        boolean hasSeen;
        LivingEntity livingentity = this.pathfinderMob.m_5448_();
        if (livingentity == null) {
            return;
        }
        boolean hasLineOfSight = this.pathfinderMob.m_21574_().m_148306_((Entity)livingentity);
        boolean bl = hasSeen = this.seeTime > 0;
        if (hasLineOfSight != hasSeen) {
            this.seeTime = 0;
        }
        this.seeTime = hasLineOfSight ? ++this.seeTime : --this.seeTime;
        double distanceToTarget = this.pathfinderMob.m_20280_((Entity)livingentity);
        boolean bl2 = shouldNavigateToTarget = (distanceToTarget > (double)this.attackRadiusSqr || this.seeTime < 5) && this.attackDelay == 0;
        if (shouldNavigateToTarget) {
            --this.updatePathDelay;
            if (this.updatePathDelay <= 0) {
                this.pathfinderMob.m_21573_().m_5624_((Entity)livingentity, this.canRun() ? this.speedModifier : this.speedModifier * 0.5);
                this.updatePathDelay = PATHFINDING_DELAY_RANGE.m_214085_(this.pathfinderMob.m_217043_());
            }
        } else {
            this.updatePathDelay = 0;
            this.pathfinderMob.m_21573_().m_26573_();
        }
        this.pathfinderMob.m_21563_().m_24960_((Entity)livingentity, 30.0f, 30.0f);
        if (this.crossbowState == CrossbowState.UNCHARGED) {
            if (!shouldNavigateToTarget) {
                this.pathfinderMob.m_6672_(AttackHandler.getCrossbowHoldingHand((LivingEntity)this.pathfinderMob));
                this.crossbowState = CrossbowState.CHARGING;
                this.crossbowAttackMob.m_6136_(true);
            }
        } else if (this.crossbowState == CrossbowState.CHARGING) {
            ItemStack crossbowItem;
            int chargingTicks;
            if (!this.pathfinderMob.m_6117_()) {
                this.crossbowState = CrossbowState.UNCHARGED;
            }
            if ((chargingTicks = this.pathfinderMob.m_21252_()) >= CrossbowItem.m_40939_((ItemStack)(crossbowItem = this.pathfinderMob.m_21211_()))) {
                this.pathfinderMob.m_21253_();
                this.crossbowState = CrossbowState.CHARGED;
                this.attackDelay = 20 + this.pathfinderMob.m_217043_().m_188503_(20);
                this.crossbowAttackMob.m_6136_(false);
            }
        } else if (this.crossbowState == CrossbowState.CHARGED) {
            --this.attackDelay;
            if (this.attackDelay == 0) {
                this.crossbowState = CrossbowState.READY_TO_ATTACK;
            }
        } else if (this.crossbowState == CrossbowState.READY_TO_ATTACK && hasLineOfSight) {
            this.crossbowAttackMob.m_6504_(livingentity, 1.0f);
            ItemStack crossbowInHand = this.pathfinderMob.m_21120_(AttackHandler.getCrossbowHoldingHand((LivingEntity)this.pathfinderMob));
            this.clearChargedProjectiles(crossbowInHand);
            this.crossbowState = CrossbowState.UNCHARGED;
        }
    }

    private void clearChargedProjectiles(ItemStack crossbowItem) {
        if (crossbowItem.m_41619_() || !(crossbowItem.m_41720_() instanceof CrossbowItem)) {
            return;
        }
        CompoundTag itemTag = crossbowItem.m_41784_();
        if (itemTag.m_128425_("ChargedProjectiles", 9)) {
            itemTag.m_128365_("ChargedProjectiles", (Tag)new ListTag());
        }
    }

    private boolean canRun() {
        return this.crossbowState == CrossbowState.UNCHARGED;
    }

    static enum CrossbowState {
        UNCHARGED,
        CHARGING,
        CHARGED,
        READY_TO_ATTACK;

    }
}

