/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.entity.easynpc.ai.goal;

import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.NavigationDataCapable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.phys.Vec3;

public class MoveBackToHomeGoal<T extends EasyNPC<?>>
extends Goal {
    private final float stopDistance;
    private final NavigationDataCapable<?> navigationData;
    private final PathfinderMob pathfinderMob;
    private final double speedModifier;
    private final int interval;
    protected double wantedX;
    protected double wantedY;
    protected double wantedZ;

    public MoveBackToHomeGoal(T easyNPCEntity, double speedModifier, float stopDistance) {
        this(easyNPCEntity, speedModifier, stopDistance, 240);
    }

    public MoveBackToHomeGoal(T easyNPCEntity, double speedModifier, float stopDistance, int interval) {
        this.stopDistance = stopDistance;
        this.speedModifier = speedModifier;
        this.interval = interval;
        this.navigationData = easyNPCEntity.getEasyNPCNavigationData();
        this.pathfinderMob = easyNPCEntity.getPathfinderMob();
    }

    public boolean m_8036_() {
        if (this.pathfinderMob.m_20160_() || this.pathfinderMob.m_217043_().m_188503_(MoveBackToHomeGoal.m_186073_((int)this.interval)) != 0 || this.pathfinderMob.m_5912_() && this.pathfinderMob.m_5448_() != null || this.reachedHome()) {
            return false;
        }
        Vec3 vec3 = this.getPosition();
        if (vec3 == null) {
            return false;
        }
        BlockPos blockPos = this.navigationData.getHomePosition();
        this.wantedX = blockPos.m_123341_();
        this.wantedY = blockPos.m_123342_();
        this.wantedZ = blockPos.m_123343_();
        return true;
    }

    public boolean m_8045_() {
        return !this.pathfinderMob.m_21573_().m_26571_() && !this.pathfinderMob.m_20160_() && this.pathfinderMob.m_5448_() == null;
    }

    public void m_8056_() {
        this.pathfinderMob.m_21573_().m_26519_(this.wantedX, this.wantedY, this.wantedZ, this.speedModifier);
    }

    public void m_8041_() {
        this.pathfinderMob.m_21573_().m_26573_();
        super.m_8041_();
    }

    private Vec3 getPosition() {
        SectionPos homePosition;
        if (this.reachedHome()) {
            return null;
        }
        SectionPos currentPosition = SectionPos.m_123199_((BlockPos)this.pathfinderMob.m_20183_());
        return currentPosition != (homePosition = SectionPos.m_123199_((BlockPos)this.navigationData.getHomePosition())) ? DefaultRandomPos.m_148412_((PathfinderMob)this.pathfinderMob, (int)10, (int)7, (Vec3)Vec3.m_82539_((Vec3i)homePosition), (double)1.5707963705062866) : null;
    }

    private boolean reachedHome() {
        if (this.navigationData == null) {
            return true;
        }
        if (!this.navigationData.hasHomePosition()) {
            return this.navigationData.getGroundPathNavigation().m_26571_();
        }
        if (this.pathfinderMob.m_20183_().equals((Object)this.navigationData.getHomePosition())) {
            return true;
        }
        BlockPos blockPos = this.pathfinderMob.m_20183_();
        Vec3i vec3i = new Vec3i(blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_());
        return this.navigationData.getHomePosition().m_123314_(vec3i, (double)this.stopDistance);
    }
}

