/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.io;

import de.markusbordihn.easynpc.client.texture.RemoteTextureManager;
import de.markusbordihn.easynpc.data.skin.SkinModel;
import de.markusbordihn.easynpc.io.DataFileHandler;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RemoteSkinDataFiles {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");
    protected static final String DATA_FOLDER_NAME = "remote_skin";

    private RemoteSkinDataFiles() {
    }

    public static void registerRemoteSkinData() {
        log.info("{} remote skin data ...", (Object)"\ud83d\udde3 Register Easy NPC: Core");
        Path skinDataFolder = RemoteSkinDataFiles.getRemoteSkinDataFolder();
        if (skinDataFolder == null) {
            return;
        }
        for (SkinModel skinModel : SkinModel.values()) {
            Path skinModelFolder = RemoteSkinDataFiles.getRemoteSkinDataFolder(skinModel);
            if (skinModelFolder == null || !Files.exists(skinModelFolder, new LinkOption[0]) || !Files.isDirectory(skinModelFolder, new LinkOption[0])) continue;
            for (String skinFileName : skinModelFolder.toFile().list()) {
                Path skinFilePath = skinModelFolder.resolve(skinFileName);
                File skinFile = skinFilePath.toFile();
                if (!skinFile.exists() || !skinFileName.endsWith(".png")) continue;
                RemoteTextureManager.registerTexture(skinModel, skinFile);
            }
        }
    }

    public static Path getRemoteSkinDataFolder() {
        return DataFileHandler.getOrCreateCacheFolder(DATA_FOLDER_NAME);
    }

    public static Path getRemoteSkinDataFolder(SkinModel skinModel) {
        Path remoteSkinDataFolder = RemoteSkinDataFiles.getRemoteSkinDataFolder();
        if (remoteSkinDataFolder == null) {
            return null;
        }
        String skinModelName = skinModel.getName();
        Path skinDataFolderPath = remoteSkinDataFolder.resolve(skinModelName);
        try {
            if (Files.exists(skinDataFolderPath, new LinkOption[0]) && Files.isDirectory(skinDataFolderPath, new LinkOption[0])) {
                return skinDataFolderPath;
            }
            log.info("Created new remote skin data folder {} at {}!", (Object)skinModelName, (Object)skinDataFolderPath);
            return Files.createDirectories(skinDataFolderPath, new FileAttribute[0]);
        }
        catch (IOException e) {
            log.error("Could not create remote skin data folder {} at {}:", (Object)skinModelName, (Object)remoteSkinDataFolder.resolve(skinModelName), (Object)e);
            return null;
        }
    }
}

