/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.network;

import de.markusbordihn.easynpc.network.NetworkHandlerInterface;
import de.markusbordihn.easynpc.network.NetworkHandlerManagerType;
import de.markusbordihn.easynpc.network.message.NetworkMessageRecord;
import de.markusbordihn.easynpc.network.message.client.OpenMenuCallbackMessage;
import de.markusbordihn.easynpc.network.message.client.SyncDataMessage;
import de.markusbordihn.easynpc.network.message.server.ExecuteActionEventMessage;
import de.markusbordihn.easynpc.network.message.server.ExecuteDialogButtonActionMessage;
import de.markusbordihn.easynpc.network.message.server.OpenMenuMessage;
import de.markusbordihn.easynpc.network.message.server.RequestDataSyncMessage;
import net.minecraft.server.level.ServerPlayer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NetworkHandlerManager {
    private static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");
    private static volatile NetworkHandlerInterface networkHandler;
    private static volatile NetworkHandlerManagerType networkHandlerManagerType;

    private NetworkHandlerManager() {
    }

    public static void registerHandler(NetworkHandlerInterface networkHandler) {
        log.info("{} Network Handler ...", (Object)"\ud83d\udde3 Register Easy NPC: Core");
        NetworkHandlerManager.networkHandler = networkHandler;
    }

    public static NetworkHandlerInterface getHandler() {
        return networkHandler;
    }

    public static void registerNetworkMessages(NetworkHandlerManagerType networkHandlerType) {
        log.info("Registering network messages for {} side ...", (Object)networkHandlerType);
        networkHandlerManagerType = networkHandlerType;
        NetworkHandlerManager.registerClientNetworkHandler();
        NetworkHandlerManager.registerServerNetworkHandler();
    }

    public static boolean isClientNetworkHandler() {
        return networkHandlerManagerType == NetworkHandlerManagerType.CLIENT || networkHandlerManagerType == NetworkHandlerManagerType.BOTH;
    }

    public static boolean isServerNetworkHandler() {
        return networkHandlerManagerType == NetworkHandlerManagerType.SERVER || networkHandlerManagerType == NetworkHandlerManagerType.BOTH;
    }

    public static void sendMessageToServer(NetworkMessageRecord networkMessageRecord) {
        NetworkHandlerInterface networkHandler = NetworkHandlerManager.getHandler();
        if (networkHandler != null) {
            networkHandler.sendMessageToServer(networkMessageRecord);
        }
    }

    public static void sendMessageToPlayer(NetworkMessageRecord networkMessageRecord, ServerPlayer serverPlayer) {
        NetworkHandlerInterface networkHandler = NetworkHandlerManager.getHandler();
        if (networkHandler != null) {
            networkHandler.sendMessageToPlayer(networkMessageRecord, serverPlayer);
        }
    }

    public static void registerClientNetworkHandler() {
        NetworkHandlerInterface networkHandler = NetworkHandlerManager.getHandler();
        if (networkHandler == null) {
            log.error("Failed to register client network handler!");
            return;
        }
        networkHandler.registerClientNetworkMessage(OpenMenuCallbackMessage.MESSAGE_ID, OpenMenuCallbackMessage.class, OpenMenuCallbackMessage::create);
        networkHandler.registerClientNetworkMessage(SyncDataMessage.MESSAGE_ID, SyncDataMessage.class, SyncDataMessage::create);
    }

    public static void registerServerNetworkHandler() {
        NetworkHandlerInterface networkHandler = NetworkHandlerManager.getHandler();
        if (networkHandler == null) {
            log.error("Failed to register server network handler!");
            return;
        }
        networkHandler.registerServerNetworkMessage(ExecuteActionEventMessage.MESSAGE_ID, ExecuteActionEventMessage.class, ExecuteActionEventMessage::create);
        networkHandler.registerServerNetworkMessage(ExecuteDialogButtonActionMessage.MESSAGE_ID, ExecuteDialogButtonActionMessage.class, ExecuteDialogButtonActionMessage::create);
        networkHandler.registerServerNetworkMessage(OpenMenuMessage.MESSAGE_ID, OpenMenuMessage.class, OpenMenuMessage::create);
        networkHandler.registerServerNetworkMessage(RequestDataSyncMessage.MESSAGE_ID, RequestDataSyncMessage.class, RequestDataSyncMessage::create);
    }

    static {
        networkHandlerManagerType = NetworkHandlerManagerType.BOTH;
    }
}

