/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.server.commands;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import de.markusbordihn.easynpc.commands.Command;
import de.markusbordihn.easynpc.entity.ModCustomEntityType;
import de.markusbordihn.easynpc.entity.ModEntityTypeProvider;
import de.markusbordihn.easynpc.entity.ModNPCEntityType;
import de.markusbordihn.easynpc.entity.ModRawEntityType;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.entity.SignText;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class TestCommand
extends Command {
    private TestCommand() {
    }

    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)Commands.m_82127_((String)"test").requires(commandSource -> commandSource.m_6761_(2))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"spawn").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"raw_npc").executes(context -> TestCommand.spawnAllEntities((CommandSourceStack)context.getSource(), ModRawEntityType.class))).then(Commands.m_82129_((String)"type", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> {
            for (ModRawEntityType type : ModRawEntityType.values()) {
                builder.suggest(type.name().toLowerCase());
            }
            return builder.buildFuture();
        }).executes(context -> {
            ModRawEntityType type;
            String input = StringArgumentType.getString((CommandContext)context, (String)"type").toUpperCase();
            try {
                type = ModRawEntityType.valueOf(input);
            }
            catch (IllegalArgumentException e) {
                throw new SimpleCommandExceptionType((Message)Component.m_237113_((String)("Unknown NPC type: " + input))).create();
            }
            return TestCommand.spawnSingleEntity((CommandSourceStack)context.getSource(), type);
        })))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"standard_npc").executes(context -> TestCommand.spawnAllEntities((CommandSourceStack)context.getSource(), ModNPCEntityType.class))).then(Commands.m_82129_((String)"type", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> {
            for (ModNPCEntityType type : ModNPCEntityType.values()) {
                builder.suggest(type.name().toLowerCase());
            }
            return builder.buildFuture();
        }).executes(context -> {
            ModNPCEntityType type;
            String input = StringArgumentType.getString((CommandContext)context, (String)"type").toUpperCase();
            try {
                type = ModNPCEntityType.valueOf(input);
            }
            catch (IllegalArgumentException e) {
                throw new SimpleCommandExceptionType((Message)Component.m_237113_((String)("Unknown NPC type: " + input))).create();
            }
            return TestCommand.spawnSingleEntity((CommandSourceStack)context.getSource(), type);
        })))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"custom_npc").executes(context -> TestCommand.spawnAllEntities((CommandSourceStack)context.getSource(), ModCustomEntityType.class))).then(Commands.m_82129_((String)"type", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> {
            for (ModCustomEntityType type : ModCustomEntityType.values()) {
                builder.suggest(type.name().toLowerCase());
            }
            return builder.buildFuture();
        }).executes(context -> {
            ModCustomEntityType type;
            String input = StringArgumentType.getString((CommandContext)context, (String)"type").toUpperCase();
            try {
                type = ModCustomEntityType.valueOf(input);
            }
            catch (IllegalArgumentException e) {
                throw new SimpleCommandExceptionType((Message)Component.m_237113_((String)("Unknown NPC type: " + input))).create();
            }
            return TestCommand.spawnSingleEntity((CommandSourceStack)context.getSource(), type);
        }))));
    }

    public static <T extends Enum<T>> int spawnAllEntities(CommandSourceStack source, Class<T> enumClass) throws CommandSyntaxException {
        ServerPlayer player = source.m_81375_();
        ServerLevel level = player.m_284548_();
        BlockPos basePos = player.m_20183_().m_7918_(0, 1, 0);
        int index = 0;
        for (Enum type : (Enum[])enumClass.getEnumConstants()) {
            int xOffset = index % 5 * 10;
            int zOffset = index / 5 * 10;
            BlockPos npcPos = basePos.m_7918_(xOffset, 0, zOffset);
            EntityType entityType = (EntityType)BuiltInRegistries.f_256780_.m_6246_(((ModEntityTypeProvider)((Object)type)).getResourceKey());
            TestCommand.spawnNpcInTestArea(level, npcPos, entityType);
            ++index;
        }
        source.m_288197_(() -> Component.m_237113_((String)("Spawned " + ((Enum[])enumClass.getEnumConstants()).length + " " + enumClass.getSimpleName() + "s for testing.")), false);
        return 1;
    }

    public static <T extends Enum<T>> int spawnSingleEntity(CommandSourceStack source, T type) throws CommandSyntaxException {
        ServerPlayer player = source.m_81375_();
        ServerLevel level = player.m_284548_();
        BlockPos basePos = player.m_20183_().m_7918_(0, 1, 0);
        EntityType entityType = (EntityType)BuiltInRegistries.f_256780_.m_6246_(((ModEntityTypeProvider)((Object)type)).getResourceKey());
        TestCommand.spawnNpcInTestArea(level, basePos, entityType);
        source.m_288197_(() -> Component.m_237113_((String)("Spawned " + type.getClass().getSimpleName() + ": " + type.name())), false);
        return 1;
    }

    private static void spawnNpcInTestArea(ServerLevel level, BlockPos centerPos, EntityType<?> entityType) {
        int dz;
        int dx;
        int radius = 3;
        TestCommand.fillArea(level, centerPos.m_7918_(-radius, -1, -radius), centerPos.m_7918_(radius, 4, radius), Blocks.f_50016_.m_49966_());
        for (dx = -radius; dx <= radius; ++dx) {
            for (dz = -radius; dz <= radius; ++dz) {
                BlockPos floorPos = centerPos.m_7918_(dx, -1, dz);
                if (Math.abs(dx) == radius && Math.abs(dz) == radius) {
                    level.m_46597_(floorPos, Blocks.f_50141_.m_49966_());
                    continue;
                }
                level.m_46597_(floorPos, Blocks.f_50333_.m_49966_());
            }
        }
        for (dx = -radius; dx <= radius; ++dx) {
            for (dz = -radius; dz <= radius; ++dz) {
                boolean isCorner;
                boolean isEdge = Math.abs(dx) == radius || Math.abs(dz) == radius;
                boolean bl = isCorner = Math.abs(dx) == radius && Math.abs(dz) == radius;
                if (!isEdge) continue;
                for (int dy = 0; dy < (isCorner ? 3 : 1); ++dy) {
                    BlockPos wallPos = centerPos.m_7918_(dx, dy, dz);
                    level.m_46597_(wallPos, Blocks.f_50132_.m_49966_());
                }
            }
        }
        TestCommand.fillArea(level, centerPos.m_7918_(-radius, 3, -radius), centerPos.m_7918_(radius, 3, radius), Blocks.f_50398_.m_49966_());
        for (dx = -1; dx <= 1; ++dx) {
            for (dz = -1; dz <= 1; ++dz) {
                BlockPos lowerSlabPos = centerPos.m_7918_(dx, 3, dz);
                level.m_46597_(lowerSlabPos, Blocks.f_50705_.m_49966_());
            }
        }
        BlockPos gatePos = centerPos.m_7918_(0, 0, radius);
        level.m_46597_(gatePos, (BlockState)Blocks.f_50192_.m_49966_().m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)Direction.SOUTH));
        BlockPos signPos = centerPos.m_7918_(0, 4, 0);
        level.m_46597_(signPos, Blocks.f_50095_.m_49966_());
        BlockEntity blockEntity = level.m_7702_(signPos);
        if (blockEntity instanceof SignBlockEntity) {
            SignBlockEntity sign = (SignBlockEntity)blockEntity;
            sign.m_276956_(new SignText().m_276913_(0, (Component)Component.m_237113_((String)"EntityType:")).m_276913_(1, (Component)Component.m_237113_((String)entityType.m_147048_())), false);
            sign.m_6596_();
        }
        entityType.m_262455_(level, (CompoundTag)null, null, centerPos, MobSpawnType.COMMAND, true, false);
    }

    private static void fillArea(ServerLevel level, BlockPos from, BlockPos to, BlockState blockState) {
        BlockPos.m_121990_((BlockPos)from, (BlockPos)to).forEach(pos -> level.m_46597_(pos.m_7949_(), blockState));
    }
}

