/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.utils;

import de.markusbordihn.easynpc.data.scale.CustomScale;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceLocation;

public class CompoundTagUtils {
    public static final String ID_PREFIX = "id_";
    public static final String X_TAG = "X";
    public static final String Y_TAG = "Y";
    public static final String Z_TAG = "Z";

    private CompoundTagUtils() {
    }

    public static CompoundTag writeBlockPos(BlockPos blockPos) {
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.m_128405_(X_TAG, blockPos.m_123341_());
        compoundTag.m_128405_(Y_TAG, blockPos.m_123342_());
        compoundTag.m_128405_(Z_TAG, blockPos.m_123343_());
        return compoundTag;
    }

    public static BlockPos readBlockPos(CompoundTag compoundTag) {
        if (!(compoundTag != null && compoundTag.m_128441_(X_TAG) && compoundTag.m_128441_(Y_TAG) && compoundTag.m_128441_(Z_TAG))) {
            return BlockPos.f_121853_;
        }
        return new BlockPos(compoundTag.m_128451_(X_TAG), compoundTag.m_128451_(Y_TAG), compoundTag.m_128451_(Z_TAG));
    }

    public static CompoundTag writeScale(float x, float y, float z) {
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.m_128350_(X_TAG, x);
        compoundTag.m_128350_(Y_TAG, y);
        compoundTag.m_128350_(Z_TAG, z);
        return compoundTag;
    }

    public static CompoundTag writeCustomScale(CustomScale customScale) {
        return CompoundTagUtils.writeScale(customScale.x(), customScale.y(), customScale.z());
    }

    public static CustomScale readCustomScale(CompoundTag compoundTag) {
        if (compoundTag == null) {
            return null;
        }
        return new CustomScale(compoundTag.m_128457_(X_TAG), compoundTag.m_128457_(Y_TAG), compoundTag.m_128457_(Z_TAG));
    }

    public static ListTag writeResourceLocations(Set<ResourceLocation> resourceLocations) {
        ListTag listTag = new ListTag();
        resourceLocations.forEach(resourceLocation -> {
            int hashCode = resourceLocation.hashCode();
            CompoundTag compoundTag = new CompoundTag();
            compoundTag.m_128359_(ID_PREFIX + hashCode, resourceLocation.toString());
            listTag.add((Object)compoundTag);
        });
        return listTag;
    }

    public static Set<ResourceLocation> readResourceLocations(ListTag listTag) {
        HashSet<ResourceLocation> resourceLocations = new HashSet<ResourceLocation>();
        listTag.forEach(tag -> {
            CompoundTag compoundTag = (CompoundTag)tag;
            compoundTag.m_128431_().forEach(key -> {
                if (key.startsWith(ID_PREFIX)) {
                    resourceLocations.add(new ResourceLocation(compoundTag.m_128461_(key)));
                }
            });
        });
        return resourceLocations;
    }
}

