/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc;

import com.mojang.brigadier.CommandDispatcher;
import cpw.mods.modlauncher.Launcher;
import cpw.mods.modlauncher.api.IEnvironment;
import cpw.mods.modlauncher.api.TypesafeMap;
import de.markusbordihn.easynpc.Constants;
import de.markusbordihn.easynpc.block.ModBlocks;
import de.markusbordihn.easynpc.client.ClientEvents;
import de.markusbordihn.easynpc.client.model.ModModelLayer;
import de.markusbordihn.easynpc.client.renderer.BlockEntityRenderer;
import de.markusbordihn.easynpc.client.renderer.EntityRenderer;
import de.markusbordihn.easynpc.client.screen.ClientScreens;
import de.markusbordihn.easynpc.commands.ModArgumentTypes;
import de.markusbordihn.easynpc.commands.manager.CommandManager;
import de.markusbordihn.easynpc.compat.CompatHandler;
import de.markusbordihn.easynpc.compat.CompatManager;
import de.markusbordihn.easynpc.component.ModDataComponents;
import de.markusbordihn.easynpc.config.Config;
import de.markusbordihn.easynpc.debug.DebugManager;
import de.markusbordihn.easynpc.entity.LivingEntityEvents;
import de.markusbordihn.easynpc.entity.ModEntityType;
import de.markusbordihn.easynpc.io.DataFileHandler;
import de.markusbordihn.easynpc.item.ModItems;
import de.markusbordihn.easynpc.menu.MenuHandler;
import de.markusbordihn.easynpc.menu.MenuManager;
import de.markusbordihn.easynpc.menu.ModMenuTypes;
import de.markusbordihn.easynpc.network.ClientNetworkMessageHandler;
import de.markusbordihn.easynpc.network.NetworkHandler;
import de.markusbordihn.easynpc.network.NetworkHandlerManager;
import de.markusbordihn.easynpc.network.NetworkHandlerManagerType;
import de.markusbordihn.easynpc.network.NetworkMessageHandlerManager;
import de.markusbordihn.easynpc.network.ServerNetworkMessageHandler;
import de.markusbordihn.easynpc.network.syncher.EntityDataSerializersManager;
import de.markusbordihn.easynpc.server.ServerEvents;
import de.markusbordihn.easynpc.tabs.ModTabs;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.EntityLeaveLevelEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.bus.BusGroup;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="easy_npc")
public class EasyNPCMain {
    private static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");

    public EasyNPCMain(FMLJavaModLoadingContext context) {
        BusGroup modBusGroup = context.getModBusGroup();
        log.info("Initializing {} (Forge) ...", (Object)"Easy NPC");
        log.info("{} Debug Manager ...", (Object)"\ud83d\udde3 Register Easy NPC: Core");
        Optional version = Launcher.INSTANCE.environment().getProperty((TypesafeMap.Key)IEnvironment.Keys.VERSION.get());
        if (version.isPresent() && "MOD_DEV".equals(version.get())) {
            DebugManager.setDevelopmentEnvironment(true);
        }
        DebugManager.checkForDebugLogging("Easy NPC: Core");
        log.info("{} Constants ...", (Object)"\ud83d\udde3 Register Easy NPC: Core");
        Constants.GAME_DIR = FMLPaths.GAMEDIR.get();
        Constants.CONFIG_DIR = FMLPaths.CONFIGDIR.get();
        log.info("{} Configuration ...", (Object)"\ud83d\udde3 Register Easy NPC: Core");
        Config.register(FMLEnvironment.dist == Dist.DEDICATED_SERVER);
        log.info("{} Common Data Files ...", (Object)"\ud83d\udde3 Register Easy NPC: Core");
        DataFileHandler.registerCommonDataFiles();
        log.info("{} Entity Data Serializers ...", (Object)"\ud83d\udde3 Register Easy NPC: Core");
        EntityDataSerializersManager.register();
        log.info("{} Compatibility Handler ...", (Object)"\ud83d\udde3 Register Easy NPC: Core");
        CompatManager.registerCompatHandler(new CompatHandler());
        log.info("{} Command Argument Types ...", (Object)"\ud83d\udde3 Register Easy NPC: Core");
        ModArgumentTypes.COMMAND_ARGUMENT_TYPES.register(modBusGroup);
        log.info("{} Entity Types ...", (Object)"\ud83d\udde3 Register Easy NPC: Core");
        ModEntityType.ENTITY_TYPES.register(modBusGroup);
        log.info("{} Blocks ...", (Object)"\ud83d\udde3 Register Easy NPC: Core");
        ModBlocks.BLOCKS.register(modBusGroup);
        log.info("{} Blocks Entity Types ...", (Object)"\ud83d\udde3 Register Easy NPC: Core");
        ModBlocks.BLOCK_ENTITY_TYPES.register(modBusGroup);
        log.info("{} Items ...", (Object)"\ud83d\udde3 Register Easy NPC: Core");
        ModItems.ITEMS.register(modBusGroup);
        log.info("{} Menu Types ...", (Object)"\ud83d\udde3 Register Easy NPC: Core");
        ModMenuTypes.MENU_TYPES.register(modBusGroup);
        log.info("{} Menu Handler ...", (Object)"\ud83d\udde3 Register Easy NPC: Core");
        MenuManager.registerMenuHandler(new MenuHandler());
        log.info("{} Mod Data Components ...", (Object)"\ud83d\udde3 Register Easy NPC: Core");
        ModDataComponents.DATA_COMPONENTS.register(modBusGroup);
        log.info("{} Network Handler ...", (Object)"\ud83d\udde3 Register Easy NPC: Core");
        NetworkMessageHandlerManager.registerClientHandler(new ClientNetworkMessageHandler());
        log.info("{} Creative Tabs ...", (Object)"\ud83d\udde3 Register Easy NPC: Core");
        ModTabs.CREATIVE_TABS.register(modBusGroup);
        FMLCommonSetupEvent.getBus((BusGroup)modBusGroup).addListener(this::commonSetup);
        EntityAttributeCreationEvent.BUS.addListener(ModEntityType::entityAttributeCreation);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            this.registerClientEvents(modBusGroup);
        }
        RegisterCommandsEvent.BUS.addListener(this::registerCommands);
        ServerStartingEvent.BUS.addListener(this::onServerStarting);
        TickEvent.ServerTickEvent.Post.BUS.addListener(this::onServerTick);
        EntityJoinLevelEvent.BUS.addListener((byte)127, this::onEntityJoinLevel);
        EntityLeaveLevelEvent.BUS.addListener((byte)127, this::onEntityLeaveLevel);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            this.registerClientGameEvents();
        }
    }

    private void registerClientEvents(BusGroup modBusGroup) {
        log.info("{} Client MOD bus events ...", (Object)"\ud83d\udde3 Register Easy NPC: Core");
        FMLClientSetupEvent.getBus((BusGroup)modBusGroup).addListener(this::onClientSetup);
        EntityRenderersEvent.RegisterRenderers.BUS.addListener(this::onRegisterRenderers);
        EntityRenderersEvent.RegisterLayerDefinitions.BUS.addListener(this::onRegisterLayerDefinitions);
    }

    private void registerClientGameEvents() {
        log.info("{} Client GAME bus events ...", (Object)"\ud83d\udde3 Register Easy NPC: Core");
        ClientPlayerNetworkEvent.LoggingOut.BUS.addListener(this::onPlayerLoggedOut);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            NetworkHandlerManager.registerHandler(new NetworkHandler());
            NetworkHandlerManager.registerNetworkMessages(NetworkHandlerManagerType.BOTH);
        });
    }

    private void onClientSetup(FMLClientSetupEvent event) {
        ClientScreens.registerScreens(event);
        event.enqueueWork(() -> {
            ClientEvents.handleClientStartedEvent(Minecraft.getInstance());
            NetworkMessageHandlerManager.registerServerHandler(new ServerNetworkMessageHandler());
        });
    }

    private void onRegisterRenderers(EntityRenderersEvent.RegisterRenderers event) {
        EntityRenderer.register(event);
        BlockEntityRenderer.register(event);
    }

    private void onRegisterLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
        ModModelLayer.registerEntityLayerDefinitions(event);
    }

    private void onPlayerLoggedOut(ClientPlayerNetworkEvent.LoggingOut event) {
        ClientEvents.handleWorldUnloadEvent();
    }

    private void registerCommands(RegisterCommandsEvent event) {
        CommandManager.registerCommands((CommandDispatcher<CommandSourceStack>)event.getDispatcher(), event.getBuildContext());
    }

    private void onServerStarting(ServerStartingEvent event) {
        ServerEvents.handleServerStarting(event.getServer());
    }

    private void onServerTick(TickEvent.ServerTickEvent event) {
        ServerEvents.handleServerTick(event.server());
    }

    private void onEntityJoinLevel(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            LivingEntityEvents.handleLivingEntityJoinEvent(livingEntity);
        }
    }

    private void onEntityLeaveLevel(EntityLeaveLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            LivingEntityEvents.handleLivingEntityLeaveEvent(livingEntity);
        }
    }
}

