/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.gui;

import de.markusbordihn.easynpc.client.renderer.manager.EntityTypeManager;
import de.markusbordihn.easynpc.client.renderer.manager.RendererManager;
import de.markusbordihn.easynpc.data.render.RenderType;
import de.markusbordihn.easynpc.data.skin.SkinType;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.RenderDataCapable;
import de.markusbordihn.easynpc.entity.easynpc.data.SkinDataCapable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.entity.CatRenderer;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.HumanoidMobRenderer;
import net.minecraft.client.renderer.entity.VillagerRenderer;
import net.minecraft.client.renderer.entity.state.CatRenderState;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.entity.state.HumanoidRenderState;
import net.minecraft.client.renderer.entity.state.VillagerRenderState;
import net.minecraft.client.renderer.entity.state.ZombieVillagerRenderState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.monster.ZombieVillager;
import net.minecraft.world.entity.npc.Villager;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class InventoryScreenHandler {
    private static final ThreadLocal<Boolean> BYPASS_MIXIN = ThreadLocal.withInitial(() -> false);

    public static boolean isBypassMixin() {
        return BYPASS_MIXIN.get();
    }

    public static void setBypassMixin(boolean bypass) {
        BYPASS_MIXIN.set(bypass);
    }

    public static boolean onRenderEntityInInventory(GuiGraphics guiGraphics, int left, int top, int right, int bottom, float scale, Vector3f translation, Quaternionf rotation, Quaternionf entityRotation, LivingEntity entity, EasyNPC<?> easyNPC) {
        if (InventoryScreenHandler.isBypassMixin()) {
            return false;
        }
        RenderDataCapable renderData = easyNPC.getEasyNPCRenderData();
        if (renderData != null && renderData.getRenderDataSet() != null && renderData.getRenderDataSet().getRenderType() == RenderType.CUSTOM_ENTITY && renderData.getRenderDataSet().getRenderEntityType() != null) {
            return InventoryScreenHandler.renderCustomEntityInInventory(guiGraphics, left, top, right, bottom, scale, translation, rotation, entityRotation, renderData.getRenderDataSet().getRenderEntityType(), easyNPC);
        }
        SkinDataCapable skinData = easyNPC.getEasyNPCSkinData();
        if (skinData != null && skinData.getSkinType() != SkinType.NONE) {
            return InventoryScreenHandler.renderSkinEntityInInventory(guiGraphics, left, top, right, bottom, scale, translation, rotation, entityRotation, skinData, easyNPC);
        }
        EntityRenderDispatcher entityRenderDispatcher = Minecraft.getInstance().getEntityRenderDispatcher();
        EntityRenderer entityrenderer = entityRenderDispatcher.getRenderer((Entity)entity);
        EntityRenderState entityrenderstate = entityrenderer.createRenderState((Entity)entity, 1.0f);
        entityrenderstate.hitboxesRenderState = null;
        guiGraphics.submitEntityRenderState(entityrenderstate, scale, translation, rotation, entityRotation, left, top, right, bottom);
        return true;
    }

    public static boolean renderCustomEntityInInventory(GuiGraphics guiGraphics, int left, int top, int right, int bottom, float scale, Vector3f translation, Quaternionf rotation, Quaternionf entityRotation, EntityType<? extends Entity> entityType, EasyNPC<?> easyNPC) {
        PathfinderMob customEntity = EntityTypeManager.getPathfinderMob(entityType, easyNPC.getEntityLevel());
        if (customEntity == null) {
            return false;
        }
        RendererManager.copyCustomLivingEntityData(easyNPC.getPathfinderMob(), (LivingEntity)customEntity);
        EntityRenderDispatcher entityRenderDispatcher = Minecraft.getInstance().getEntityRenderDispatcher();
        EntityRenderer entityrenderer = entityRenderDispatcher.getRenderer((Entity)customEntity);
        EntityRenderState entityrenderstate = entityrenderer.createRenderState((Entity)customEntity, 1.0f);
        entityrenderstate.hitboxesRenderState = null;
        guiGraphics.submitEntityRenderState(entityrenderstate, scale, translation, rotation, entityRotation, left, top, right, bottom);
        return true;
    }

    public static boolean renderSkinEntityInInventory(GuiGraphics guiGraphics, int left, int top, int right, int bottom, float scale, Vector3f translation, Quaternionf rotation, Quaternionf entityRotation, SkinDataCapable<?> skinData, EasyNPC<?> easyNPC) {
        LivingEntity livingEntity = easyNPC.getLivingEntity();
        EntityRenderDispatcher entityRenderDispatcher = Minecraft.getInstance().getEntityRenderDispatcher();
        EntityRenderer entityRenderer = entityRenderDispatcher.getRenderer((Entity)livingEntity);
        EntityRenderState baseRenderState = entityRenderer.createRenderState((Entity)livingEntity, 1.0f);
        if (baseRenderState instanceof HumanoidRenderState) {
            HumanoidRenderState humanoidRenderState = (HumanoidRenderState)baseRenderState;
            guiGraphics.submitEntityRenderState((EntityRenderState)humanoidRenderState, scale, translation, rotation, entityRotation, left, top, right, bottom);
            return true;
        }
        if (baseRenderState instanceof CatRenderState && livingEntity instanceof Cat) {
            CatRenderState customCatRenderState = (CatRenderState)entityRenderer.createRenderState();
            CatRenderer catRenderer = (CatRenderer)entityRenderer;
            catRenderer.extractRenderState((Cat)livingEntity, customCatRenderState, 1.0f);
            customCatRenderState.texture = catRenderer.getTextureLocation(customCatRenderState);
            customCatRenderState.hitboxesRenderState = null;
            guiGraphics.submitEntityRenderState((EntityRenderState)customCatRenderState, scale, translation, rotation, entityRotation, left, top, right, bottom);
            return true;
        }
        if (baseRenderState instanceof VillagerRenderState && livingEntity instanceof Villager) {
            VillagerRenderState customVillagerRenderState = (VillagerRenderState)entityRenderer.createRenderState();
            VillagerRenderer villagerRenderer = (VillagerRenderer)entityRenderer;
            villagerRenderer.extractRenderState((Villager)livingEntity, customVillagerRenderState, 1.0f);
            customVillagerRenderState.hitboxesRenderState = null;
            guiGraphics.submitEntityRenderState((EntityRenderState)customVillagerRenderState, scale, translation, rotation, entityRotation, left, top, right, bottom);
            return true;
        }
        if (baseRenderState instanceof ZombieVillagerRenderState && livingEntity instanceof ZombieVillager) {
            ZombieVillagerRenderState customZombieVillagerRenderState = (ZombieVillagerRenderState)entityRenderer.createRenderState();
            customZombieVillagerRenderState.villagerData = ((ZombieVillager)livingEntity).getVillagerData();
            customZombieVillagerRenderState.hitboxesRenderState = null;
            guiGraphics.submitEntityRenderState((EntityRenderState)customZombieVillagerRenderState, scale, translation, rotation, entityRotation, left, top, right, bottom);
            return true;
        }
        if (entityRenderer instanceof HumanoidMobRenderer) {
            HumanoidMobRenderer humanoidRenderer = (HumanoidMobRenderer)entityRenderer;
            if (baseRenderState instanceof HumanoidRenderState) {
                HumanoidRenderState customHumanoidRenderState = (HumanoidRenderState)entityRenderer.createRenderState();
                humanoidRenderer.extractRenderState(easyNPC.getMob(), customHumanoidRenderState, 1.0f);
                customHumanoidRenderState.hitboxesRenderState = null;
                guiGraphics.submitEntityRenderState((EntityRenderState)customHumanoidRenderState, scale, translation, rotation, entityRotation, left, top, right, bottom);
                return true;
            }
        }
        baseRenderState.hitboxesRenderState = null;
        guiGraphics.submitEntityRenderState(baseRenderState, scale, translation, rotation, entityRotation, left, top, right, bottom);
        return true;
    }
}

