/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import de.markusbordihn.easynpc.block.entity.EasyNPCSpawnerBlockEntity;
import de.markusbordihn.easynpc.client.renderer.blockentity.EasyNPCSpawnerRenderState;
import de.markusbordihn.easynpc.level.BaseEasyNPCSpawner;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;

public class BaseEasyNPCSpawnerBlockEntityRenderer<T extends EasyNPCSpawnerBlockEntity>
implements BlockEntityRenderer<T, EasyNPCSpawnerRenderState> {
    private final EntityRenderDispatcher entityRenderer;

    public BaseEasyNPCSpawnerBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        this.entityRenderer = context.entityRenderer();
    }

    public EasyNPCSpawnerRenderState createRenderState() {
        return new EasyNPCSpawnerRenderState();
    }

    public void extractRenderState(T blockEntity, EasyNPCSpawnerRenderState renderState, float partialTicks, Vec3 cameraPos, @Nullable ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        super.extractRenderState(blockEntity, (BlockEntityRenderState)renderState, partialTicks, cameraPos, crumblingOverlay);
        Level level = blockEntity.getLevel();
        if (level == null) {
            renderState.entityRenderState = null;
            return;
        }
        BaseEasyNPCSpawner baseSpawner = ((EasyNPCSpawnerBlockEntity)((Object)blockEntity)).getSpawner();
        Entity entity = baseSpawner.getOrCreateDisplayEntity(level, blockEntity.getBlockPos());
        if (entity == null) {
            renderState.entityRenderState = null;
            return;
        }
        float scale = 0.53125f;
        float maxDimension = Math.max(entity.getBbWidth(), entity.getBbHeight());
        if (maxDimension > 1.0f) {
            scale /= maxDimension;
        }
        renderState.scale = scale;
        renderState.spinInterpolated = (float)Mth.lerp((double)partialTicks, (double)baseSpawner.getOSpin(), (double)baseSpawner.getSpin()) * 10.0f;
        try {
            EntityRenderer renderer = this.entityRenderer.getRenderer(entity);
            EntityRenderState entityRenderState = renderer.createRenderState(entity, partialTicks);
            renderer.extractRenderState(entity, entityRenderState, partialTicks);
            entityRenderState.lightCoords = renderState.lightCoords;
            renderState.entityRenderState = entityRenderState;
        }
        catch (Exception exception) {
            renderState.entityRenderState = null;
        }
    }

    public void submit(EasyNPCSpawnerRenderState renderState, PoseStack poseStack, SubmitNodeCollector submitNodeCollector, CameraRenderState cameraRenderState) {
        if (renderState.entityRenderState == null) {
            return;
        }
        poseStack.pushPose();
        poseStack.translate(0.5f, 0.0f, 0.5f);
        poseStack.translate(0.0f, 0.4f, 0.0f);
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(renderState.spinInterpolated));
        poseStack.translate(0.0f, -0.2f, 0.0f);
        poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(-30.0f));
        poseStack.scale(renderState.scale, renderState.scale, renderState.scale);
        this.entityRenderer.submit(renderState.entityRenderState, cameraRenderState, 0.0, 0.0, 0.0, poseStack, submitNodeCollector);
        poseStack.popPose();
    }
}

