/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.renderer.entity.custom;

import com.mojang.blaze3d.vertex.PoseStack;
import de.markusbordihn.easynpc.client.model.custom.DopplerModel;
import de.markusbordihn.easynpc.client.renderer.entity.EasyNPCEntityRenderer;
import de.markusbordihn.easynpc.client.renderer.entity.state.EasyNPCRenderStateExtension;
import de.markusbordihn.easynpc.client.renderer.manager.EntityTypeManager;
import de.markusbordihn.easynpc.client.renderer.manager.RendererManager;
import de.markusbordihn.easynpc.data.render.RenderType;
import de.markusbordihn.easynpc.data.skin.variant.DopplerSkinVariant;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.RenderDataCapable;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.HumanoidMobRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.entity.state.HumanoidRenderState;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DopplerRenderer
extends HumanoidMobRenderer<PathfinderMob, HumanoidRenderState, DopplerModel<HumanoidRenderState>>
implements EasyNPCEntityRenderer {
    protected static final ResourceLocation DEFAULT_TEXTURE = DopplerSkinVariant.DOPPLER.getTextureLocation();
    private static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");

    public DopplerRenderer(EntityRendererProvider.Context context, ModelLayerLocation modelLayerLocation) {
        super(context, new DopplerModel(context.bakeLayer(modelLayerLocation)), 0.5f);
    }

    private static boolean renderEntity(EasyNPC<?> entity, EntityModel<?> entityModel, HumanoidRenderState renderState, PoseStack poseStack, SubmitNodeCollector submitNodeCollector, CameraRenderState cameraRenderState) {
        if (!(entity instanceof EasyNPC)) {
            return false;
        }
        EasyNPC<?> easyNPC = entity;
        RenderDataCapable renderData = easyNPC.getEasyNPCRenderData();
        if (renderData == null || renderData.getRenderDataSet() == null || renderData.getRenderDataSet().getRenderType() != RenderType.CUSTOM_ENTITY) {
            return false;
        }
        EntityType<? extends Entity> renderEntityType = renderData.getRenderDataSet().getRenderEntityType();
        PathfinderMob customEntity = EntityTypeManager.getPathfinderMob(renderEntityType, entity.getEntityLevel());
        if (customEntity == null) {
            return false;
        }
        String entityTypeName = EntityTypeManager.getEntityTypeName(renderEntityType);
        LivingEntityRenderer<? extends LivingEntity, ? extends LivingEntityRenderState, ? extends EntityModel<? extends EntityRenderState>> livingEntityRenderer = RendererManager.getLivingEntityRenderer(renderEntityType, customEntity);
        if (livingEntityRenderer != null) {
            try {
                LivingEntityRenderState livingEntityRenderState;
                RendererManager.copyCustomLivingEntityData(entity.getPathfinderMob(), (LivingEntity)customEntity, entityTypeName);
                if (RendererManager.isScreenRendering()) {
                    customEntity.yBodyRot = customEntity.getYHeadRot();
                    customEntity.yBodyRotO = customEntity.yHeadRotO;
                }
                if ((livingEntityRenderState = (LivingEntityRenderState)livingEntityRenderer.createRenderState((Entity)customEntity, 1.0f)) instanceof EasyNPCRenderStateExtension) {
                    EasyNPCRenderStateExtension extension = (EasyNPCRenderStateExtension)livingEntityRenderState;
                    extension.setEasyNpcUUID(easyNPC.getEntityUUID());
                }
                livingEntityRenderer.submit(livingEntityRenderState, poseStack, submitNodeCollector, cameraRenderState);
                return true;
            }
            catch (Exception exception) {
                log.error("Failed to render custom living entity {} ({}):", (Object)customEntity, renderEntityType, (Object)exception);
                EntityTypeManager.addUnsupportedEntityType(renderEntityType);
                return false;
            }
        }
        EntityRenderer<? extends Entity, ? extends EntityRenderState> entityRenderer = RendererManager.getEntityRenderer(renderEntityType, customEntity);
        EntityRenderState entityRenderState = entityRenderer.createRenderState((Entity)customEntity, 1.0f);
        if (entityRenderState instanceof EasyNPCRenderStateExtension) {
            EasyNPCRenderStateExtension extension = (EasyNPCRenderStateExtension)entityRenderState;
            extension.setEasyNpcUUID(easyNPC.getEntityUUID());
        }
        if (entityRenderer != null) {
            try {
                RendererManager.copyCustomLivingEntityData(entity.getPathfinderMob(), (LivingEntity)customEntity, entityTypeName);
                entityRenderer.submit(entityRenderState, poseStack, submitNodeCollector, cameraRenderState);
                return true;
            }
            catch (Exception exception) {
                log.error("Failed to render custom entity {} ({}):", (Object)customEntity, renderEntityType, (Object)exception);
                EntityTypeManager.addUnsupportedEntityType(renderEntityType);
                return false;
            }
        }
        return false;
    }

    public HumanoidRenderState createRenderState() {
        return new HumanoidRenderState();
    }

    public ResourceLocation getTextureLocation(HumanoidRenderState renderState) {
        return this.getTextureFromRenderState((LivingEntityRenderState)renderState);
    }

    @Override
    public ResourceLocation getDefaultTexture() {
        return DEFAULT_TEXTURE;
    }

    public void submit(HumanoidRenderState renderState, PoseStack poseStack, SubmitNodeCollector submitNodeCollector, CameraRenderState cameraRenderState) {
        EasyNPC easyNPC = this.getEasyNPC((LivingEntityRenderState)renderState);
        if (DopplerRenderer.renderEntity(easyNPC, this.getModel(), renderState, poseStack, submitNodeCollector, cameraRenderState)) {
            return;
        }
        super.submit((LivingEntityRenderState)renderState, poseStack, submitNodeCollector, cameraRenderState);
    }
}

