/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.screen;

import de.markusbordihn.easynpc.client.screen.ScreenInterface;
import de.markusbordihn.easynpc.client.screen.components.CloseButton;
import de.markusbordihn.easynpc.data.screen.AdditionalScreenData;
import de.markusbordihn.easynpc.data.screen.ScreenData;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.menu.EasyNPCMenu;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.glfw.GLFW;

public class ContainerScreen<T extends EasyNPCMenu>
extends AbstractContainerScreen<T>
implements ScreenInterface {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");
    protected static double formerMouseX = -1.0;
    protected static double formerMouseY = -1.0;
    protected final Minecraft minecraftInstance;
    protected final T menu;
    protected float xMouse;
    protected float yMouse;
    protected int rightPos;
    protected int bottomPos;
    protected boolean renderBackground = true;
    protected boolean showCloseButton = true;
    protected Button closeButton = null;
    protected boolean compactMode = false;
    private boolean containerClosed = false;

    protected ContainerScreen(T menu, Inventory inventory, Component component) {
        this(menu, inventory, component, 318, 243);
    }

    protected ContainerScreen(T menu, Inventory inventory, Component component, int width, int height) {
        super(menu, inventory, component);
        this.imageWidth = width;
        this.imageHeight = height;
        this.menu = menu;
        this.minecraftInstance = Minecraft.getInstance();
    }

    protected static void resetFormerMousePosition() {
        ContainerScreen.setFormerMousePosition(-1.0, -1.0);
    }

    protected static void setFormerMousePosition(double x, double y) {
        formerMouseX = x;
        formerMouseY = y;
    }

    @Override
    public EasyNPC<?> getEasyNPC() {
        return ((EasyNPCMenu)((Object)this.menu)).getEasyNPC();
    }

    @Override
    public ScreenData getScreenData() {
        return ((EasyNPCMenu)((Object)this.menu)).getScreenData();
    }

    @Override
    public AdditionalScreenData getAdditionalScreenData() {
        return ((EasyNPCMenu)((Object)this.menu)).getAdditionalScreenData();
    }

    protected void init() {
        super.init();
        this.compactMode = this.height < 260;
        this.titleLabelX = 7;
        this.titleLabelY = -9;
        this.topPos = (this.height - this.imageHeight) / 2 + (this.compactMode ? 2 : 10);
        this.leftPos = (this.width - this.imageWidth) / 2;
        this.rightPos = this.leftPos + this.imageWidth;
        this.bottomPos = this.topPos + this.imageHeight;
        if (formerMouseX > 0.0 && formerMouseY > 0.0) {
            GLFW.glfwSetCursorPos((long)this.minecraftInstance.getWindow().handle(), (double)formerMouseX, (double)formerMouseY);
            ContainerScreen.resetFormerMousePosition();
        }
        if (this.showCloseButton) {
            this.closeButton = (Button)this.addRenderableWidget((GuiEventListener)new CloseButton(this.rightPos - 15, this.topPos + 4, onPress -> this.onClose()));
        }
    }

    public boolean mouseClicked(MouseButtonEvent mouseButtonEvent, boolean doubleClick) {
        ContainerScreen.setFormerMousePosition(Minecraft.getInstance().mouseHandler.xpos(), Minecraft.getInstance().mouseHandler.ypos());
        return super.mouseClicked(mouseButtonEvent, doubleClick);
    }

    public void render(GuiGraphics guiGraphics, int x, int y, float partialTicks) {
        if (this.renderBackground) {
            super.renderBackground(guiGraphics, x, y, partialTicks);
        }
        super.render(guiGraphics, x, y, partialTicks);
        this.xMouse = x;
        this.yMouse = y;
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        this.renderDefaultScreenBg(guiGraphics, this.leftPos, this.topPos);
        if (!this.compactMode) {
            this.renderDefaultTitleBg(guiGraphics, this.leftPos, this.topPos);
        }
    }

    public void onClose() {
        ContainerScreen.resetFormerMousePosition();
        if (!this.containerClosed && this.minecraft != null && this.minecraft.player != null) {
            this.containerClosed = true;
            this.minecraft.player.closeContainer();
        }
        super.onClose();
    }

    public void removed() {
        if (!this.containerClosed && this.minecraft != null && this.minecraft.player != null && !this.isSwitchingToAnotherEasyNPCScreen(this.minecraft.screen)) {
            ContainerScreen.resetFormerMousePosition();
            this.containerClosed = true;
            this.minecraft.player.closeContainer();
        }
        super.removed();
    }

    public boolean keyPressed(KeyEvent keyEvent) {
        int keyCode = keyEvent.input();
        if (keyCode != 257 && keyCode != 335 && keyCode != 69 && keyCode != 73) {
            return super.keyPressed(keyEvent);
        }
        return keyCode == 257 || keyCode == 335 || keyCode == 73;
    }
}

